/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.core.preferences;

import java.util.List;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.python.pydev.core.preferences.PydevPrefs;
import org.python.pydev.shared_core.SharedCorePlugin;
import org.python.pydev.shared_core.string.StringUtils;

public class FileTypesPreferences {
    public static final String VALID_SOURCE_FILES = "VALID_SOURCE_FILES";
    public static final String DEFAULT_VALID_SOURCE_FILES = "py, pyw, pyx, pxd, pxi";
    public static final String FIRST_CHOICE_PYTHON_SOURCE_FILE = "FIRST_CHOICE_PYTHON_SOURCE_FILE";
    public static final String DEFAULT_FIRST_CHOICE_PYTHON_SOURCE_FILE = "py";

    public static String[] getWildcardValidSourceFiles() {
        if (SharedCorePlugin.inTestMode()) {
            return new String[]{"*.py", "*.pyw", "*.pyx", "*.pxd", "*.pxi"};
        }
        return PreferencesCacheHelper.get().getCacheWildcardValidSourceFiles();
    }

    public static final String[] getDottedValidSourceFiles() {
        if (SharedCorePlugin.inTestMode()) {
            return new String[]{".py", ".pyw", ".pyx", ".pxd", ".pxi"};
        }
        return PreferencesCacheHelper.get().getCacheDottedValidSourceFiles();
    }

    public static final String[] getValidSourceFiles() {
        if (SharedCorePlugin.inTestMode()) {
            return new String[]{DEFAULT_FIRST_CHOICE_PYTHON_SOURCE_FILE, "pyw", "pyx", "pxd", "pxi"};
        }
        return PreferencesCacheHelper.get().getCacheValidSourceFiles();
    }

    public static final String[] getValidInitFiles() {
        if (SharedCorePlugin.inTestMode()) {
            return new String[]{"__init__.py", "__init__.pyw", "__init__.pyx", "__init__.pxd", "__init__.pxi"};
        }
        return PreferencesCacheHelper.get().getCacheValidInitFiles();
    }

    public static boolean isValidZipFile(String fileName) {
        return fileName.endsWith(".jar") || fileName.endsWith(".zip") || fileName.endsWith(".egg");
    }

    public static boolean isValidDll(String path) {
        return path.endsWith(".pyd") || path.endsWith(".so") || path.endsWith(".dll") || path.endsWith(".a");
    }

    public static boolean isValidDllExtension(String extension) {
        return extension.equals("pyd") || extension.equals("so") || extension.equals("dll") || extension.equals("a");
    }

    public static final String getDefaultDottedPythonExtension() {
        if (SharedCorePlugin.inTestMode()) {
            return ".py";
        }
        return "." + PydevPrefs.getEclipsePreferences().get(FIRST_CHOICE_PYTHON_SOURCE_FILE, DEFAULT_FIRST_CHOICE_PYTHON_SOURCE_FILE);
    }

    public static String[] getWildcardJythonValidZipFiles() {
        return new String[]{"*.jar", "*.zip"};
    }

    public static String[] getWildcardPythonValidZipFiles() {
        return new String[]{"*.egg", "*.zip"};
    }

    public static boolean isCythonFile(String name) {
        return name != null && (name.endsWith(".pyx") || name.endsWith(".pxd") || name.endsWith(".pxi"));
    }

    private static class PreferencesCacheHelper
    implements IEclipsePreferences.IPreferenceChangeListener {
        private static PreferencesCacheHelper singleton;
        private String[] wildcaldValidSourceFiles;
        private String[] dottedValidSourceFiles;
        private String[] pythondValidSourceFiles;
        private String[] pythonValidInitFiles;

        static synchronized PreferencesCacheHelper get() {
            if (singleton == null) {
                singleton = new PreferencesCacheHelper();
            }
            return singleton;
        }

        public PreferencesCacheHelper() {
            PydevPrefs.getEclipsePreferences().addPreferenceChangeListener((IEclipsePreferences.IPreferenceChangeListener)this);
        }

        public void preferenceChange(IEclipsePreferences.PreferenceChangeEvent event) {
            this.wildcaldValidSourceFiles = null;
            this.dottedValidSourceFiles = null;
            this.pythondValidSourceFiles = null;
            this.pythonValidInitFiles = null;
        }

        public String[] getCacheWildcardValidSourceFiles() {
            String[] ret = this.wildcaldValidSourceFiles;
            if (ret == null) {
                String[] validSourceFiles = this.getCacheValidSourceFiles();
                String[] s = new String[validSourceFiles.length];
                int i = 0;
                while (i < validSourceFiles.length) {
                    s[i] = "*." + validSourceFiles[i];
                    ++i;
                }
                this.wildcaldValidSourceFiles = s;
                ret = s;
            }
            return ret;
        }

        public String[] getCacheDottedValidSourceFiles() {
            String[] ret = this.dottedValidSourceFiles;
            if (ret == null) {
                String[] validSourceFiles = this.getCacheValidSourceFiles();
                String[] s = new String[validSourceFiles.length];
                int i = 0;
                while (i < validSourceFiles.length) {
                    s[i] = "." + validSourceFiles[i];
                    ++i;
                }
                this.dottedValidSourceFiles = s;
                ret = s;
            }
            return ret;
        }

        public String[] getCacheValidInitFiles() {
            String[] ret = this.pythonValidInitFiles;
            if (ret == null) {
                String[] cacheValidSourceFiles = this.getCacheValidSourceFiles();
                ret = new String[cacheValidSourceFiles.length];
                int i = 0;
                while (i < ret.length) {
                    ret[i] = "__init__." + cacheValidSourceFiles[i];
                    ++i;
                }
                this.pythonValidInitFiles = ret;
            }
            return ret;
        }

        public String[] getCacheValidSourceFiles() {
            String[] ret = this.pythondValidSourceFiles;
            if (ret == null) {
                String validStr = PydevPrefs.getEclipsePreferences().get(FileTypesPreferences.VALID_SOURCE_FILES, FileTypesPreferences.DEFAULT_VALID_SOURCE_FILES);
                List temp = StringUtils.splitAndRemoveEmptyTrimmed((String)validStr, (char)',');
                String[] s = temp.toArray(new String[temp.size()]);
                int i = 0;
                while (i < s.length) {
                    s[i] = s[i].trim();
                    ++i;
                }
                this.pythondValidSourceFiles = s;
                ret = s;
            }
            return ret;
        }
    }
}

