/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.core.wrap_paragraph;

import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.text.edits.ReplaceEdit;
import org.python.pydev.core.docutils.PySelection;
import org.python.pydev.shared_core.string.TextSelectionUtils;

public class Paragrapher {
    private PySelection selection;
    private IDocument document;
    private int offset;
    public int currentLineNo;
    private String currentLine;
    public String leadingString;
    public String mainText;
    public int offsetOfOriginalParagraph;
    public int lengthOfOriginalParagraph;
    private int numberOfLinesInDocument;
    public final String docDelimiter;
    private int noCols;
    private List<String> paragraph;
    private static Pattern pattern = Pattern.compile("(\\s*#\\s*|\\s*\"\"\"\\s*|\\s*'''\\s*|\\s*\"\\s*|\\s*'\\s*|\\s*)");

    public Paragrapher(PySelection selection, int noCols) {
        this.noCols = noCols;
        this.selection = selection;
        this.document = selection.getDoc();
        this.docDelimiter = TextSelectionUtils.getDelimiter((IDocument)this.document);
        this.offset = selection.getAbsoluteCursorOffset();
        this.currentLineNo = selection.getLineOfOffset(this.offset);
        this.currentLine = selection.getLine(this.currentLineNo);
        Matcher matcher = pattern.matcher(this.currentLine);
        if (matcher.find()) {
            this.leadingString = this.currentLine.substring(0, matcher.end());
            this.mainText = this.currentLine.substring(matcher.end());
        }
        this.offsetOfOriginalParagraph = 0;
        this.lengthOfOriginalParagraph = 0;
        this.numberOfLinesInDocument = this.document.getNumberOfLines();
    }

    private String[] splitLine(String line) {
        Matcher matcher = pattern.matcher(line);
        if (matcher.find()) {
            String leadingString = line.substring(0, matcher.end());
            String mainText = line.substring(matcher.end());
            return new String[]{leadingString, mainText};
        }
        return new String[]{"", line};
    }

    public String getCurrentLine() {
        this.currentLine = this.selection.getLine(this.currentLineNo);
        this.mainText = this.splitLine(this.currentLine)[1];
        return this.mainText;
    }

    public boolean previousLineIsInParagraph() {
        if (this.currentLineNo == 0) {
            return false;
        }
        String previousLine = this.selection.getLine(this.currentLineNo - 1);
        String[] previousLineParts = this.splitLine(previousLine);
        String leadingStringOfPreviousLine = previousLineParts[0];
        String mainTextOfPreviousLine = previousLineParts[1];
        if (mainTextOfPreviousLine.trim().isEmpty() || !leadingStringOfPreviousLine.equals(this.leadingString)) {
            int lineEndsAt;
            String line = this.selection.getLine(this.currentLineNo);
            try {
                lineEndsAt = this.selection.getEndLineOffset(this.currentLineNo);
            }
            catch (BadLocationException e) {
                return false;
            }
            this.offsetOfOriginalParagraph = lineEndsAt - line.length();
            return false;
        }
        return true;
    }

    public boolean nextLineIsInParagraph() {
        if (this.currentLineNo + 1 == this.numberOfLinesInDocument) {
            try {
                this.lengthOfOriginalParagraph = this.selection.getEndLineOffset(this.currentLineNo) - this.offsetOfOriginalParagraph;
            }
            catch (BadLocationException e) {
                return false;
            }
            return false;
        }
        String nextLine = this.selection.getLine(this.currentLineNo + 1);
        String[] nextLineParts = this.splitLine(nextLine);
        String leadingStringOfNextLine = nextLineParts[0];
        String mainTextOfNextLine = nextLineParts[1];
        if (mainTextOfNextLine.trim().isEmpty() || !leadingStringOfNextLine.equals(this.leadingString)) {
            try {
                this.lengthOfOriginalParagraph = this.selection.getEndLineOffset(this.currentLineNo) - this.offsetOfOriginalParagraph;
            }
            catch (BadLocationException e) {
                return false;
            }
            return false;
        }
        return true;
    }

    public String getValidErrorInPos() {
        boolean isDocstring;
        this.paragraph = new ArrayList<String>();
        this.paragraph.add(this.getCurrentLine());
        boolean bl = isDocstring = this.leadingString.contains("\"\"\"") || this.leadingString.contains("'") || this.leadingString.contains("\"");
        if (isDocstring) {
            return "Cannot rewrap docstrings";
        }
        if (this.paragraph.get(0).trim().isEmpty()) {
            return "Currect selection is empty";
        }
        int startingLineNo = this.currentLineNo;
        while (this.previousLineIsInParagraph()) {
            --this.currentLineNo;
            this.paragraph.add(0, this.getCurrentLine());
        }
        this.currentLineNo = startingLineNo;
        while (this.nextLineIsInParagraph()) {
            ++this.currentLineNo;
            this.paragraph.add(this.getCurrentLine());
        }
        if (this.paragraph.size() == 1 && this.paragraph.get(0).length() < this.noCols - this.leadingString.length()) {
            return "Current selection cannot be wrapped";
        }
        return null;
    }

    public ReplaceEdit getReplaceEdit() {
        ArrayList<CallSite> wrappedParagraph = new ArrayList<CallSite>();
        for (String line : this.paragraph) {
            wrappedParagraph.add((CallSite)((Object)(line.trim() + " ")));
        }
        String fullParagraph = String.join((CharSequence)"", wrappedParagraph);
        List<String> rewrappedParagraph = Paragrapher.wrapText(fullParagraph, this.noCols - this.leadingString.length());
        ArrayList<Object> finalParagraph = new ArrayList<Object>();
        for (String line : rewrappedParagraph) {
            finalParagraph.add(this.leadingString + line + this.docDelimiter);
        }
        if (!finalParagraph.isEmpty()) {
            String lastLine = (String)finalParagraph.get(finalParagraph.size() - 1);
            lastLine = lastLine.replace(this.docDelimiter, "");
            finalParagraph.set(finalParagraph.size() - 1, lastLine);
        }
        String newText = String.join((CharSequence)"", finalParagraph);
        ReplaceEdit replaceEdit = new ReplaceEdit(this.offsetOfOriginalParagraph, this.lengthOfOriginalParagraph, newText);
        return replaceEdit;
    }

    public static List<String> wrapText(String text, int width) {
        ArrayList<String> lines = new ArrayList<String>();
        int start = 0;
        while (start < text.length()) {
            int end = Math.min(text.length(), start + width);
            if (end < text.length() && !Character.isWhitespace(text.charAt(end))) {
                while (end > start && !Character.isWhitespace(text.charAt(end))) {
                    --end;
                }
            }
            lines.add(text.substring(start, end).trim());
            start = end;
        }
        return lines;
    }
}

