/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.json.eclipsesource;

import java.io.IOException;
import java.io.Writer;

class JsonWriter {
    private static final int CONTROL_CHARACTERS_START = 0;
    private static final int CONTROL_CHARACTERS_END = 31;
    protected final Writer writer;

    JsonWriter(Writer writer) {
        this.writer = writer;
    }

    void write(String string) throws IOException {
        this.writer.write(string);
    }

    void writeString(String string) throws IOException {
        this.writer.write(34);
        int length = string.length();
        char[] chars = new char[length];
        string.getChars(0, length, chars, 0);
        int i = 0;
        while (i < length) {
            char ch = chars[i];
            if (ch == '\"' || ch == '\\') {
                this.writer.write(92);
                this.writer.write(ch);
            } else if (ch == '\n') {
                this.writer.write(92);
                this.writer.write(110);
            } else if (ch == '\r') {
                this.writer.write(92);
                this.writer.write(114);
            } else if (ch == '\t') {
                this.writer.write("\\t");
            } else if (ch == '\u2028') {
                this.writer.write("\\u2028");
            } else if (ch == '\u2029') {
                this.writer.write("\\u2029");
            } else if (ch >= '\u0000' && ch <= '\u001f') {
                this.writer.write("\\u00");
                if (ch <= '\u000f') {
                    this.writer.write(48);
                }
                this.writer.write(Integer.toHexString(ch));
            } else {
                this.writer.write(ch);
            }
            ++i;
        }
        this.writer.write(34);
    }

    protected void writeBeginObject() throws IOException {
        this.writer.write(123);
    }

    protected void writeEndObject() throws IOException {
        this.writer.write(125);
    }

    protected void writeNameValueSeparator() throws IOException {
        this.writer.write(58);
    }

    protected void writeObjectValueSeparator() throws IOException {
        this.writer.write(44);
    }

    protected void writeBeginArray() throws IOException {
        this.writer.write(91);
    }

    protected void writeEndArray() throws IOException {
        this.writer.write(93);
    }

    protected void writeArrayValueSeparator() throws IOException {
        this.writer.write(44);
    }
}

