/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.json.eclipsesource;

import java.io.IOException;
import java.io.Writer;
import org.python.pydev.json.eclipsesource.JsonWriter;
import org.python.pydev.shared_core.string.FastStringBuffer;

public class PrettyJsonWriter
extends JsonWriter {
    private FastStringBuffer indent = new FastStringBuffer();

    PrettyJsonWriter(Writer writer) {
        super(writer);
    }

    private void writeIndent() throws IOException {
        this.writer.write(this.indent.getInternalCharsArray(), 0, this.indent.length());
    }

    private void increaseIdent() {
        this.indent.appendN(' ', 4);
    }

    private void decreaseIndent() {
        this.indent.deleteLastChars(4);
    }

    private void writeStartScope(char c) throws IOException {
        this.writer.write(c);
        this.writer.write(10);
        this.increaseIdent();
        this.writeIndent();
    }

    private void writeEndScope(char c) throws IOException {
        this.writer.write(10);
        this.decreaseIndent();
        this.writeIndent();
        this.writer.write(c);
        this.writer.write(10);
        this.writeIndent();
    }

    @Override
    protected void writeBeginObject() throws IOException {
        this.writeStartScope('{');
    }

    @Override
    protected void writeEndObject() throws IOException {
        this.writeEndScope('}');
    }

    @Override
    protected void writeNameValueSeparator() throws IOException {
        this.writer.write(58);
        this.writer.write(32);
    }

    @Override
    protected void writeObjectValueSeparator() throws IOException {
        this.writer.write(44);
        this.writer.write(32);
    }

    @Override
    protected void writeBeginArray() throws IOException {
        this.writeStartScope('[');
    }

    @Override
    protected void writeEndArray() throws IOException {
        this.writeEndScope(']');
    }

    @Override
    protected void writeArrayValueSeparator() throws IOException {
        this.writer.write(44);
        this.writer.write(32);
    }
}

