/*
 * Decompiled with CFR 0.152.
 */
package com.python.pydev.analysis;

import com.python.pydev.analysis.AnalysisPlugin;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.dialogs.DialogSettings;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.preference.IPreferenceStore;
import org.osgi.framework.Bundle;
import org.python.pydev.plugin.PydevPlugin;

public class AnalysisUiPlugin {
    private static IDialogSettings dialogSettings = null;
    private static final String FN_DIALOG_SETTINGS = "dialog_settings.xml";

    public static IDialogSettings getDialogSettings() {
        if (dialogSettings == null) {
            AnalysisUiPlugin.loadDialogSettings();
        }
        return dialogSettings;
    }

    private static IPath getStateLocationOrNull() {
        try {
            return AnalysisPlugin.getDefault().getStateLocation();
        }
        catch (IllegalStateException e) {
            return null;
        }
    }

    protected static void loadDialogSettings() {
        String readWritePath;
        File settingsFile;
        dialogSettings = new DialogSettings("Workbench");
        IPath dataLocation = AnalysisUiPlugin.getStateLocationOrNull();
        if (dataLocation != null && (settingsFile = new File(readWritePath = dataLocation.append(FN_DIALOG_SETTINGS).toOSString())).exists()) {
            try {
                dialogSettings.load(readWritePath);
            }
            catch (IOException e) {
                dialogSettings = new DialogSettings("Workbench");
            }
            return;
        }
        URL dsURL = FileLocator.find((Bundle)AnalysisPlugin.getDefault().getBundle(), (IPath)new Path(FN_DIALOG_SETTINGS), null);
        if (dsURL == null) {
            return;
        }
        InputStream is = null;
        try {
            try {
                is = dsURL.openStream();
                BufferedReader reader = new BufferedReader(new InputStreamReader(is, StandardCharsets.UTF_8));
                dialogSettings.load((Reader)reader);
            }
            catch (IOException e) {
                dialogSettings = new DialogSettings("Workbench");
                try {
                    if (is != null) {
                        is.close();
                    }
                }
                catch (IOException iOException) {}
            }
        }
        finally {
            try {
                if (is != null) {
                    is.close();
                }
            }
            catch (IOException iOException) {}
        }
    }

    public static IPreferenceStore getPreferenceStore() {
        return PydevPlugin.getDefault().getPreferenceStore();
    }
}

