/*
 * Decompiled with CFR 0.152.
 */
package com.python.pydev.analysis.additionalinfo;

import com.python.pydev.analysis.additionalinfo.AbstractAdditionalDependencyInfo;
import com.python.pydev.analysis.additionalinfo.AbstractAdditionalTokensInfo;
import com.python.pydev.analysis.additionalinfo.AdditionalInfoAndIInfo;
import com.python.pydev.analysis.additionalinfo.AdditionalProjectInterpreterInfo;
import com.python.pydev.analysis.additionalinfo.AdditionalSystemInterpreterInfo;
import com.python.pydev.analysis.additionalinfo.AttrInfo;
import com.python.pydev.analysis.additionalinfo.ClassInfo;
import com.python.pydev.analysis.additionalinfo.FuncInfo;
import com.python.pydev.analysis.additionalinfo.ModInfo;
import com.python.pydev.analysis.additionalinfo.NameInfo;
import java.util.Arrays;
import java.util.HashSet;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.ui.IMemento;
import org.python.pydev.ast.interpreter_managers.InterpreterManagersAPI;
import org.python.pydev.core.IInfo;
import org.python.pydev.core.IInterpreterManager;
import org.python.pydev.core.IPythonNature;
import org.python.pydev.core.log.Log;
import org.python.pydev.plugin.nature.PythonNature;

public class InfoFactory {
    private static final String TAG_MODULE_NAME = "module_name";
    private static final String TAG_PATH = "path";
    private static final String TAG_NAME = "name";
    private static final String TAG_TYPE = "type";
    private static final String TAG_FILE = "file";
    private static final String TAG_LINE = "line";
    private static final String TAG_COL = "col";
    private static final String TAG_PROJECT_NAME = "project";
    private static final String TAG_MANAGER_IS_PYTHON = "is_python";
    private static final String TAG_MANAGER_INTERPRETER_TYPE = "interpreter_type";
    private static final String TAG_MANAGER_INTERPRETER = "interpreter";
    private AdditionalInfoAndIInfo info;

    public InfoFactory() {
    }

    public InfoFactory(AdditionalInfoAndIInfo input) {
        this.info = input;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public AdditionalInfoAndIInfo createElement(IMemento memento) {
        String[] attributeKeys = null;
        try {
            AbstractAdditionalDependencyInfo additionalInfo;
            Boolean isTagPython;
            AttrInfo info;
            IProject project;
            attributeKeys = memento.getAttributeKeys();
            HashSet<String> keys = new HashSet<String>(Arrays.asList(attributeKeys));
            if (!keys.contains(TAG_NAME)) return null;
            if (!keys.contains(TAG_MODULE_NAME)) return null;
            if (!keys.contains(TAG_PATH)) return null;
            if (!keys.contains(TAG_TYPE)) return null;
            if (!keys.contains(TAG_FILE)) return null;
            if (!keys.contains(TAG_LINE)) return null;
            if (!keys.contains(TAG_COL)) {
                return null;
            }
            String name = memento.getString(TAG_NAME);
            String moduleName = memento.getString(TAG_MODULE_NAME);
            String path = memento.getString(TAG_PATH);
            String file = memento.getString(TAG_FILE);
            int line = memento.getInteger(TAG_LINE);
            int col = memento.getInteger(TAG_COL);
            int type = memento.getInteger(TAG_TYPE);
            String infoName = null;
            String infoModule = null;
            String infoPath = null;
            if (name != null && name.length() > 0) {
                infoName = name;
            }
            if (moduleName != null && moduleName.length() > 0) {
                infoModule = moduleName;
            }
            if (path != null && path.length() > 0) {
                infoPath = path;
            }
            String projectName = null;
            if (keys.contains(TAG_PROJECT_NAME)) {
                projectName = memento.getString(TAG_PROJECT_NAME);
            }
            PythonNature nature = null;
            if (projectName != null && (project = ResourcesPlugin.getWorkspace().getRoot().getProject(projectName)) != null) {
                nature = PythonNature.getPythonNature((IProject)project);
            }
            if (type == 3) {
                info = new AttrInfo(infoName, infoModule, infoPath, (IPythonNature)nature, file, line, col);
            } else if (type == 1) {
                info = new ClassInfo(infoName, infoModule, infoPath, (IPythonNature)nature, file, line, col);
            } else if (type == 2) {
                info = new FuncInfo(infoName, infoModule, infoPath, (IPythonNature)nature, file, line, col);
            } else if (type == 4) {
                info = new NameInfo(infoName, infoModule, infoPath, (IPythonNature)nature, file, line, col);
            } else {
                if (type != 5) throw new AssertionError((Object)("Cannot restore type: " + type));
                info = new ModInfo(infoModule, (IPythonNature)nature, file, line, col);
            }
            IInterpreterManager manager = null;
            if (projectName != null) {
                if (nature != null) {
                    try {
                        AbstractAdditionalDependencyInfo additionalInfo2 = AdditionalProjectInterpreterInfo.getAdditionalInfoForProject((IPythonNature)nature);
                        return new AdditionalInfoAndIInfo((AbstractAdditionalTokensInfo)additionalInfo2, (IInfo)info);
                    }
                    catch (Exception e) {
                        return null;
                    }
                }
            } else if (keys.contains(TAG_MANAGER_INTERPRETER_TYPE) && keys.contains(TAG_MANAGER_INTERPRETER)) {
                Integer interpreterType = memento.getInteger(TAG_MANAGER_INTERPRETER_TYPE);
                if (interpreterType != null) {
                    switch (interpreterType) {
                        case 0: {
                            manager = InterpreterManagersAPI.getPythonInterpreterManager();
                            break;
                        }
                        case 1: {
                            manager = InterpreterManagersAPI.getJythonInterpreterManager();
                            break;
                        }
                        case 2: {
                            manager = InterpreterManagersAPI.getIronpythonInterpreterManager();
                        }
                        default: {
                            break;
                        }
                    }
                }
            } else if (keys.contains(TAG_MANAGER_IS_PYTHON) && keys.contains(TAG_MANAGER_INTERPRETER) && (isTagPython = memento.getBoolean(TAG_MANAGER_IS_PYTHON)) != null) {
                manager = isTagPython != false ? InterpreterManagersAPI.getPythonInterpreterManager() : InterpreterManagersAPI.getJythonInterpreterManager();
            }
            if (manager == null) return null;
            String interpreter = memento.getString(TAG_MANAGER_INTERPRETER);
            try {
                additionalInfo = AdditionalSystemInterpreterInfo.getAdditionalSystemInfo(manager, (String)interpreter);
            }
            catch (Exception e) {
                return null;
            }
            if (additionalInfo == null) return null;
            return new AdditionalInfoAndIInfo((AbstractAdditionalTokensInfo)additionalInfo, (IInfo)info);
        }
        catch (Throwable e) {
            Log.log((Throwable)e);
            return null;
        }
    }

    public void saveState(IMemento memento) {
        if (this.info.info == null) {
            return;
        }
        String declaringModuleName = this.info.info.getDeclaringModuleName();
        if (declaringModuleName == null) {
            declaringModuleName = "";
        }
        memento.putString(TAG_MODULE_NAME, declaringModuleName);
        String path = this.info.info.getPath();
        if (path == null) {
            path = "";
        }
        memento.putString(TAG_PATH, path);
        String name = this.info.info.getName();
        if (name == null) {
            name = "";
        }
        memento.putString(TAG_NAME, name);
        memento.putString(TAG_TYPE, "" + this.info.info.getType());
        if (this.info.additionalInfo instanceof AdditionalProjectInterpreterInfo) {
            AdditionalProjectInterpreterInfo projectInterpreterInfo = (AdditionalProjectInterpreterInfo)this.info.additionalInfo;
            memento.putString(TAG_PROJECT_NAME, projectInterpreterInfo.getProject().getName());
        } else if (this.info.additionalInfo instanceof AdditionalSystemInterpreterInfo) {
            AdditionalSystemInterpreterInfo systemInterpreterInfo = (AdditionalSystemInterpreterInfo)this.info.additionalInfo;
            IInterpreterManager manager = systemInterpreterInfo.getManager();
            memento.putInteger(TAG_MANAGER_INTERPRETER_TYPE, manager.getInterpreterType());
            memento.putString(TAG_MANAGER_INTERPRETER, systemInterpreterInfo.getAdditionalInfoInterpreter());
        }
    }
}

