/*
 * Decompiled with CFR 0.152.
 */
package com.python.pydev.analysis.builder;

import com.python.pydev.analysis.additionalinfo.builders.AnalysisBuilderVisitor;
import com.python.pydev.analysis.additionalinfo.builders.AnalysisRunner;
import java.io.File;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.text.IDocument;
import org.python.pydev.ast.builder.VisitorMemo;
import org.python.pydev.ast.codecompletion.revisited.modules.AbstractModule;
import org.python.pydev.core.IModule;
import org.python.pydev.core.IPythonNature;
import org.python.pydev.core.log.Log;
import org.python.pydev.core.logging.DebugSettings;
import org.python.pydev.parser.jython.SimpleNode;
import org.python.pydev.plugin.nature.PythonNature;
import org.python.pydev.shared_core.model.ISimpleNode;
import org.python.pydev.shared_core.parsing.ChangedParserInfoForObservers;
import org.python.pydev.shared_core.parsing.ErrorParserInfoForObservers;
import org.python.pydev.shared_core.parsing.IParserObserver;
import org.python.pydev.shared_core.parsing.IParserObserver3;
import org.python.pydev.shared_core.structure.Tuple;

public class AnalysisParserObserver
implements IParserObserver,
IParserObserver3 {
    public void parserChanged(ChangedParserInfoForObservers info) {
        PythonNature nature;
        if (DebugSettings.DEBUG_ANALYSIS_REQUESTS) {
            System.out.println("AnalysisParserObserver: parserChanged");
        }
        SimpleNode root = (SimpleNode)info.root;
        if (info.file == null) {
            return;
        }
        IFile fileAdapter = null;
        if (info.file instanceof IFile) {
            fileAdapter = (IFile)info.file;
        }
        if (fileAdapter == null && (fileAdapter = (IFile)info.file.getAdapter(IFile.class)) == null) {
            return;
        }
        boolean force = false;
        boolean forceAnalyzeInThisThread = false;
        if (info.argsToReparse != null && info.argsToReparse.length > 0 && info.argsToReparse[0] instanceof Tuple) {
            Tuple t = (Tuple)info.argsToReparse[0];
            if (t.o1 instanceof String && t.o2 instanceof Boolean) {
                if (t.o1.equals("AnalysisParserObserver:force")) {
                    force = (Boolean)t.o2;
                }
                if (t.o1.equals("AnalysisParserObserver:force:inThisThread")) {
                    forceAnalyzeInThisThread = force = ((Boolean)t.o2).booleanValue();
                }
            }
        }
        if ((nature = PythonNature.getPythonNature((IResource)fileAdapter)) == null) {
            return;
        }
        if (!nature.isOkToUse()) {
            AnalyzeLaterJob job = new AnalyzeLaterJob("Analyze later", info, root, fileAdapter, force, (IPythonNature)nature);
            job.schedule(100L);
            return;
        }
        AnalysisParserObserver.analyze(info, root, fileAdapter, force, (IPythonNature)nature, forceAnalyzeInThisThread);
    }

    private static void analyze(ChangedParserInfoForObservers info, SimpleNode root, IFile fileAdapter, boolean force, IPythonNature nature, boolean forceAnalyzeInThisThread) {
        IModule module;
        if (!nature.startRequests()) {
            return;
        }
        try {
            String moduleName = nature.resolveModuleOnlyInProjectSources((IResource)fileAdapter, true);
            if (moduleName == null) {
                AnalysisRunner.deleteMarkers((IResource)fileAdapter);
                return;
            }
            IPath location = fileAdapter.getLocation();
            if (location == null) {
                return;
            }
            try {
                String file = location.toOSString();
                module = AbstractModule.createModule((SimpleNode)root, (File)new File(file), (String)moduleName, (IPythonNature)nature);
            }
            catch (Exception e) {
                Log.log((Throwable)e);
                return;
            }
        }
        finally {
            nature.endRequests();
        }
        AnalysisBuilderVisitor visitor = new AnalysisBuilderVisitor();
        visitor.memo = new VisitorMemo();
        visitor.memo.put((Object)"IS_FULL_BUILD", (Object)false);
        visitor.memo.put((Object)"DOCUMENT_TIME", (Object)info.documentMillisTime);
        visitor.visitingWillStart((IProgressMonitor)new NullProgressMonitor(), false, null);
        try {
            visitor.doVisitChangedResource(nature, (IResource)fileAdapter, info.doc, null, module, (IProgressMonitor)new NullProgressMonitor(), force, 2, info.documentMillisTime, forceAnalyzeInThisThread);
        }
        finally {
            visitor.visitingEnded((IProgressMonitor)new NullProgressMonitor());
        }
    }

    public void parserChanged(ISimpleNode root, IAdaptable resource, IDocument doc, long docModificationStamp) {
        throw new RuntimeException("As it uses IParserObserver2, this interface should not be asked for.");
    }

    public void parserError(Throwable error, IAdaptable file, IDocument doc) {
    }

    public void parserError(ErrorParserInfoForObservers info) {
    }

    private final class AnalyzeLaterJob
    extends Job {
        private final IPythonNature nature;
        private ChangedParserInfoForObservers info;
        private SimpleNode root;
        private IFile fileAdapter;
        private boolean force;
        private int rescheduleTimes;

        private AnalyzeLaterJob(String name, ChangedParserInfoForObservers info, SimpleNode root, IFile fileAdapter, boolean force, IPythonNature nature) {
            super(name);
            this.rescheduleTimes = 15;
            this.nature = nature;
            this.info = info;
            this.root = root;
            this.fileAdapter = fileAdapter;
            this.force = force;
        }

        protected IStatus run(IProgressMonitor monitor) {
            --this.rescheduleTimes;
            try {
                if (!this.nature.isOkToUse()) {
                    if (this.rescheduleTimes >= 0) {
                        this.schedule(200L);
                    }
                } else {
                    AnalysisParserObserver.analyze(this.info, this.root, this.fileAdapter, this.force, this.nature, false);
                }
            }
            catch (Throwable e) {
                Log.log((Throwable)e);
            }
            return Status.OK_STATUS;
        }
    }
}

