/*
 * Decompiled with CFR 0.152.
 */
package com.python.pydev.analysis.ctrl_1.flake8;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.text.BadLocationException;
import org.python.pydev.core.CheckAnalysisErrors;
import org.python.pydev.core.IAnalysisMarkersParticipant;
import org.python.pydev.core.IAnalysisPreferences;
import org.python.pydev.core.IMarkerInfoForAnalysis;
import org.python.pydev.core.IPyEdit;
import org.python.pydev.core.IPythonNature;
import org.python.pydev.core.docutils.PySelection;
import org.python.pydev.core.formatter.FormatStd;
import org.python.pydev.core.proposals.CompletionProposalFactory;
import org.python.pydev.shared_core.code_completion.ICompletionProposalHandle;
import org.python.pydev.shared_ui.SharedUiPlugin;

public class Flake8IgnoreErrorParticipant
implements IAnalysisMarkersParticipant {
    private Set<String> handled = new HashSet<String>();
    private FormatStd format;

    public Flake8IgnoreErrorParticipant() {
        this(null);
    }

    Flake8IgnoreErrorParticipant(FormatStd format) {
        this.format = format;
    }

    public void addProps(IMarkerInfoForAnalysis markerInfo, IAnalysisPreferences analysisPreferences, String line, PySelection ps, int offset, IPythonNature nature, IPyEdit edit, List<ICompletionProposalHandle> props) throws BadLocationException, CoreException {
        Object attribute = markerInfo.getFlake8MessageId();
        Object message = markerInfo.getMessage();
        if (attribute == null || message == null) {
            return;
        }
        String messageId = attribute.toString();
        if (this.handled.contains(messageId)) {
            return;
        }
        this.handled.add(messageId);
        if (CheckAnalysisErrors.isFlake8ErrorHandledAtLine((String)line, (String)messageId)) {
            return;
        }
        String displayString = "noqa: " + String.valueOf(message);
        ICompletionProposalHandle proposal = CompletionProposalFactory.get().createIgnoreFlake8CompletionProposalInSameLine(messageId, ps.getEndLineOffset(), 0, offset, SharedUiPlugin.getImageCache().get("icons/annotation_obj.gif"), displayString, null, null, 10, edit, line, ps, this.format, markerInfo);
        props.add(proposal);
    }
}

