/*
 * Decompiled with CFR 0.152.
 */
package com.python.pydev.analysis.organizeimports;

import com.python.pydev.analysis.AnalysisPreferences;
import com.python.pydev.analysis.AnalysisUiPlugin;
import com.python.pydev.analysis.marker_quick_fixes.UndefinedVariableFixParticipant;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.TreeMap;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.contentassist.ICompletionProposalExtension2;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.python.pydev.ast.codecompletion.ProposalsComparator;
import org.python.pydev.core.IPyEdit;
import org.python.pydev.core.docutils.PySelection;
import org.python.pydev.core.log.Log;
import org.python.pydev.editor.PyEdit;
import org.python.pydev.editor.actions.IOrganizeImports;
import org.python.pydev.editor.codecompletion.proposals.CtxInsensitiveImportComplProposal;
import org.python.pydev.editor.codefolding.MarkerAnnotationAndPosition;
import org.python.pydev.editor.codefolding.PySourceViewer;
import org.python.pydev.parser.PyParser;
import org.python.pydev.plugin.PydevPlugin;
import org.python.pydev.shared_core.code_completion.IPyCompletionProposal;
import org.python.pydev.shared_core.structure.Tuple;
import org.python.pydev.ui.dialogs.ListContentProvider;
import org.python.pydev.ui.dialogs.TreeSelectionDialog;

public class OrganizeImports
implements IOrganizeImports {
    private static final String DIALOG_SETTINGS = "com.python.pydev.analysis.ORGANIZE_IMPORTS_DIALOG";
    private boolean didChange = false;

    @Override
    public boolean beforePerformArrangeImports(PySelection ps, PyEdit edit, IFile f) {
        if (!AnalysisPreferences.doAutoImportOnOrganizeImports((IAdaptable)edit) || edit == null) {
            return true;
        }
        this.didChange = false;
        ArrayList<MarkerAnnotationAndPosition> undefinedVariablesMarkers = this.getUndefinedVariableMarkers(edit);
        TreeMap<Integer, MarkerAnnotationAndPosition> map = new TreeMap<Integer, MarkerAnnotationAndPosition>();
        for (MarkerAnnotationAndPosition marker : undefinedVariablesMarkers) {
            if (marker.position == null) continue;
            int start = marker.position.offset;
            map.put(start, marker);
        }
        UndefinedVariableFixParticipant variableFixParticipant = new UndefinedVariableFixParticipant(false);
        ArrayList<ICompletionProposalExtension2> completionsToApply = new ArrayList<ICompletionProposalExtension2>();
        HashSet<String> treatedVars = new HashSet<String>();
        Boolean[] keepGoing = new Boolean[]{true};
        final IDialogSettings dialogSettings = AnalysisUiPlugin.getDialogSettings();
        for (MarkerAnnotationAndPosition marker : map.values()) {
            if (!keepGoing[0].booleanValue()) break;
            int start = marker.position.offset;
            int end = start + marker.position.length;
            if (start < 0 || end <= start) continue;
            IDocument doc = ps.getDoc();
            ArrayList props = new ArrayList();
            try {
                String string = doc.get(start, end - start);
                if (treatedVars.contains(string)) continue;
                variableFixParticipant.addProps(marker.asMarkerInfoForAnalysis(), null, null, ps, start, edit.getPythonNature(), (IPyEdit)edit, props);
                if (props.size() <= 0) continue;
                ProposalsComparator proposalsComparator = new ProposalsComparator("", (IPyCompletionProposal.ICompareContext)new ProposalsComparator.CompareContext(edit.getPythonNature()));
                props.sort(proposalsComparator);
                edit.selectAndReveal(start, end - start);
                treatedVars.add(string);
                Shell activeShell = Display.getCurrent().getActiveShell();
                TreeSelectionDialog dialog = new TreeSelectionDialog(activeShell, (ILabelProvider)new LabelProvider(){

                    public Image getImage(Object element) {
                        CtxInsensitiveImportComplProposal comp = (CtxInsensitiveImportComplProposal)element;
                        return comp.getImage();
                    }

                    public String getText(Object element) {
                        CtxInsensitiveImportComplProposal comp = (CtxInsensitiveImportComplProposal)element;
                        return comp.getDisplayString();
                    }
                }, new ListContentProvider()){

                    @Override
                    protected Control createContents(Composite parent) {
                        Control ret = super.createContents(parent);
                        PydevPlugin.setCssId(parent, "py-add-imports-dialog", true);
                        return ret;
                    }

                    public boolean isHelpAvailable() {
                        return false;
                    }

                    protected void updateStatus(IStatus status) {
                        super.updateStatus(status);
                        PydevPlugin.fixSelectionStatusDialogStatusLineColor((Object)this, this.getDialogArea().getBackground());
                    }

                    protected IDialogSettings getDialogBoundsSettings() {
                        IDialogSettings section = dialogSettings.getSection(OrganizeImports.DIALOG_SETTINGS);
                        if (section == null) {
                            section = dialogSettings.addNewSection(OrganizeImports.DIALOG_SETTINGS);
                        }
                        return section;
                    }

                    protected Point getInitialSize() {
                        IDialogSettings settings = this.getDialogBoundsSettings();
                        if (settings != null) {
                            try {
                                int width = settings.getInt("DIALOG_WIDTH");
                                int height = settings.getInt("DIALOG_HEIGHT");
                                if (width > 0 & height > 0) {
                                    return new Point(width, height);
                                }
                            }
                            catch (NumberFormatException numberFormatException) {
                                // empty catch block
                            }
                        }
                        return new Point(300, 300);
                    }
                };
                dialog.setTitle("Choose import");
                dialog.setMessage("Which import should be added?");
                dialog.setInput(props);
                dialog.setInitialSelection(props.get(0));
                int returnCode = dialog.open();
                if (returnCode == 0) {
                    ICompletionProposalExtension2 firstResult = (ICompletionProposalExtension2)dialog.getFirstResult();
                    completionsToApply.add(firstResult);
                    continue;
                }
                if (returnCode != 1) continue;
                keepGoing[0] = false;
            }
            catch (Exception e) {
                try {
                    Log.log((Throwable)e);
                }
                catch (Exception e2) {
                    Log.log((Throwable)e2);
                }
            }
        }
        for (ICompletionProposalExtension2 comp : completionsToApply) {
            int offset = 0;
            comp.apply((ITextViewer)edit.getPySourceViewer(), ' ', 0, offset);
            this.didChange = true;
        }
        return true;
    }

    private ArrayList<MarkerAnnotationAndPosition> getUndefinedVariableMarkers(PyEdit edit) {
        PySourceViewer s = edit.getPySourceViewer();
        ArrayList<MarkerAnnotationAndPosition> undefinedVariablesMarkers = new ArrayList<MarkerAnnotationAndPosition>();
        Iterator<MarkerAnnotationAndPosition> it = s.getMarkerIterator();
        while (it.hasNext()) {
            MarkerAnnotationAndPosition m = it.next();
            IMarker marker = m.markerAnnotation.getMarker();
            try {
                Integer attribute;
                String type = marker.getType();
                if (type == null || !type.equals("com.python.pydev.analysis.pydev_analysis_problemmarker") || (attribute = Integer.valueOf(marker.getAttribute("PYDEV_TYPE", -1))) == null || !attribute.equals(3)) continue;
                undefinedVariablesMarkers.add(m);
            }
            catch (Exception e) {
                Log.log((Throwable)e);
            }
        }
        return undefinedVariablesMarkers;
    }

    @Override
    public void afterPerformArrangeImports(PySelection ps, PyEdit pyEdit) {
        PyParser parser;
        if (!AnalysisPreferences.doAutoImportOnOrganizeImports((IAdaptable)pyEdit) || !this.didChange) {
            return;
        }
        if (pyEdit != null && (parser = pyEdit.getParser()) != null) {
            parser.forceReparse(new Object[]{new Tuple((Object)"AnalysisParserObserver:force", (Object)true)});
        }
    }
}

