/*
 * Decompiled with CFR 0.152.
 */
package com.python.pydev.analysis.search_index;

import com.python.pydev.analysis.search_index.PyModuleMatch;
import java.util.ArrayList;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.search.ui.text.AbstractTextSearchResult;
import org.eclipse.search.ui.text.Match;
import org.python.pydev.core.ModulesKey;
import org.python.pydev.shared_ui.search.ICustomLineElement;

public class PyModuleLineElement
implements ICustomLineElement,
IAdaptable {
    private final IResource fParent;
    private final int fLineNumber;
    private final int fLineStartOffset;
    private final String fLineContents;
    public final ModulesKey modulesKey;

    public PyModuleLineElement(IResource parent, int lineNumber, int lineStartOffset, String lineContents, ModulesKey modulesKey) {
        this.fParent = parent;
        this.fLineNumber = lineNumber;
        this.fLineStartOffset = lineStartOffset;
        this.fLineContents = lineContents;
        this.modulesKey = modulesKey;
    }

    public IProject getProject() {
        return this.fParent.getProject();
    }

    public IResource getParent() {
        return this.fParent;
    }

    public int getLine() {
        return this.fLineNumber;
    }

    public String getContents() {
        return this.fLineContents;
    }

    public int getOffset() {
        return this.fLineStartOffset;
    }

    public boolean contains(int offset) {
        return this.fLineStartOffset <= offset && offset < this.fLineStartOffset + this.fLineContents.length();
    }

    public int getLength() {
        return this.fLineContents.length();
    }

    public PyModuleMatch[] getMatches(AbstractTextSearchResult result) {
        ArrayList<PyModuleMatch> res = new ArrayList<PyModuleMatch>();
        Match[] matches = result.getMatches((Object)this.fParent);
        int i = 0;
        while (i < matches.length) {
            PyModuleMatch curr = (PyModuleMatch)matches[i];
            if (curr.getLineElement() == this) {
                res.add(curr);
            }
            ++i;
        }
        return res.toArray(new PyModuleMatch[res.size()]);
    }

    public int getNumberOfMatches(AbstractTextSearchResult result) {
        int count = 0;
        Match[] matches = result.getMatches((Object)this.fParent);
        int i = 0;
        while (i < matches.length) {
            PyModuleMatch curr = (PyModuleMatch)matches[i];
            if (curr.getLineElement() == this) {
                ++count;
            }
            ++i;
        }
        return count;
    }

    public <T> T getAdapter(Class<T> adapter) {
        return (T)this.fParent.getAdapter(adapter);
    }
}

