/*
 * Decompiled with CFR 0.152.
 */
package com.python.pydev.refactoring.tdd.completions;

import com.python.pydev.analysis.refactoring.tdd.AbstractPyCreateAction;
import com.python.pydev.analysis.refactoring.tdd.TemplateInfo;
import com.python.pydev.refactoring.tdd.completions.AbstractTddRefactorCompletion;
import java.util.List;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.eclipse.swt.graphics.Point;
import org.python.pydev.ast.refactoring.RefactoringInfo;
import org.python.pydev.core.IPyEdit;
import org.python.pydev.core.MisconfigurationException;
import org.python.pydev.core.docutils.PySelection;
import org.python.pydev.core.log.Log;
import org.python.pydev.core.proposals.CompletionProposalFactory;
import org.python.pydev.editor.PyEdit;
import org.python.pydev.editor.codecompletion.PyTemplateProposal;
import org.python.pydev.parser.PyParser;
import org.python.pydev.shared_core.image.IImageHandle;

public final class TddRefactorCompletion
extends AbstractTddRefactorCompletion {
    private PyTemplateProposal executed;
    private int locationStrategy;
    private List<String> parametersAfterCall;
    private AbstractPyCreateAction pyCreateAction;
    private PySelection ps;
    private TemplateInfo templateInfo;

    public TddRefactorCompletion(String replacementString, IImageHandle image, String displayString, IContextInformation contextInformation, String additionalProposalInfo, int priority, IPyEdit edit, int locationStrategy, List<String> parametersAfterCall, AbstractPyCreateAction pyCreateAction, PySelection ps) {
        super(edit, replacementString, 0, 0, 0, image, displayString, contextInformation, additionalProposalInfo, priority);
        this.locationStrategy = locationStrategy;
        this.parametersAfterCall = parametersAfterCall;
        this.pyCreateAction = pyCreateAction;
        this.ps = ps;
    }

    @Override
    public void apply(IDocument document) {
        Log.log((String)"This apply should not be called as it implements ICompletionProposalExtension2.");
    }

    @Override
    public boolean isAutoInsertable() {
        return false;
    }

    @Override
    public Point getSelection(IDocument document) {
        PyTemplateProposal executed2 = this.getAsTemplateProposal();
        if (executed2 != null) {
            return executed2.getSelection(document);
        }
        return null;
    }

    public PyTemplateProposal convertToTemplateProposal(TemplateInfo templateInfo) {
        return (PyTemplateProposal)CompletionProposalFactory.get().createPyTemplateProposal(templateInfo.fTemplate, templateInfo.fContext, templateInfo.fRegion, null, 0);
    }

    public void apply(ITextViewer viewer, char trigger, int stateMask, int offset) {
        PyTemplateProposal executed2;
        PyParser parser;
        if (this.edit != null && (parser = (PyParser)this.edit.getParser()) != null) {
            parser.reparseDocument(new Object[0]);
        }
        if ((executed2 = this.getAsTemplateProposal()) != null) {
            executed2.apply(viewer, trigger, stateMask, 0);
            this.forceReparseInBaseEditorAnd(new PyEdit[0]);
        }
    }

    public PyTemplateProposal getAsTemplateProposal() {
        if (this.executed == null) {
            try {
                TemplateInfo templateInfo = this.getAsTemplateInfo();
                this.executed = this.convertToTemplateProposal(templateInfo);
            }
            catch (MisconfigurationException e) {
                Log.log((Throwable)e);
            }
        }
        return this.executed;
    }

    public TemplateInfo getAsTemplateInfo() throws MisconfigurationException {
        if (this.templateInfo == null) {
            this.pyCreateAction.setActiveEditor(this.edit);
            RefactoringInfo refactoringInfo = new RefactoringInfo(this.edit, this.ps.getTextSelection());
            this.templateInfo = this.pyCreateAction.createProposal(refactoringInfo, this.fReplacementString, this.locationStrategy, this.parametersAfterCall);
        }
        return this.templateInfo;
    }

    public void selected(ITextViewer viewer, boolean smartToggle) {
    }

    public void unselected(ITextViewer viewer) {
    }

    public boolean validate(IDocument document, int offset, DocumentEvent event) {
        return false;
    }
}

