/*
 * Decompiled with CFR 0.152.
 */
package com.python.pydev.ui.hierarchy;

import com.python.pydev.actions.ShowOutlineLabelProvider;
import com.python.pydev.ui.hierarchy.HierarchyLabelProvider;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.eclipse.jface.viewers.DelegatingStyledCellLabelProvider;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.PlatformUI;
import org.python.pydev.ast.item_pointer.ItemPointer;
import org.python.pydev.ast.refactoring.HierarchyNodeModel;
import org.python.pydev.core.IModule;
import org.python.pydev.editor.actions.PyOpenAction;
import org.python.pydev.parser.jython.SimpleNode;
import org.python.pydev.parser.jython.ast.ClassDef;
import org.python.pydev.parser.jython.ast.FunctionDef;
import org.python.pydev.parser.visitors.scope.ASTEntry;
import org.python.pydev.parser.visitors.scope.DefinitionsASTIteratorVisitor;
import org.python.pydev.shared_core.image.IImageHandle;
import org.python.pydev.shared_core.structure.DataAndImageTreeNode;
import org.python.pydev.shared_ui.ImageCache;
import org.python.pydev.shared_ui.SharedUiPlugin;
import org.python.pydev.shared_ui.quick_outline.DataAndImageTreeNodeContentProvider;
import org.python.pydev.shared_ui.tree.LabelProviderWithDecoration;

public class HierarchyViewer {
    private final Object lock = new Object();
    Tree treeMembers;
    TreeViewer treeClassesViewer;
    private SashForm sash;
    private Composite fParent;
    private static IImageHandle parentsImage;
    private static IImageHandle classImage;

    public void setFocus() {
        if (this.treeClassesViewer != null) {
            this.treeClassesViewer.getTree().setFocus();
        }
    }

    public void dispose() {
        if (this.treeClassesViewer != null) {
            this.treeClassesViewer.getTree().dispose();
            this.treeClassesViewer = null;
        }
        if (this.treeMembers != null) {
            this.treeMembers.dispose();
            this.treeMembers = null;
        }
    }

    protected static ILabelProvider createLabelProvider() {
        try {
            return new LabelProviderWithDecoration((DelegatingStyledCellLabelProvider.IStyledLabelProvider)new HierarchyLabelProvider(), PlatformUI.getWorkbench().getDecoratorManager().getLabelDecorator(), null);
        }
        catch (Throwable e) {
            return new ShowOutlineLabelProvider();
        }
    }

    public void createPartControl(Composite parent) {
        this.fParent = parent;
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        layout.verticalSpacing = 2;
        layout.marginWidth = 0;
        layout.marginHeight = 2;
        parent.setLayout((Layout)layout);
        this.sash = new SashForm(parent, 512);
        GridData layoutData = new GridData();
        layoutData.grabExcessHorizontalSpace = true;
        layoutData.grabExcessVerticalSpace = true;
        layoutData.horizontalAlignment = 4;
        layoutData.verticalAlignment = 4;
        this.sash.setLayoutData((Object)layoutData);
        parent = this.sash;
        this.treeClassesViewer = new TreeViewer(parent);
        this.treeClassesViewer.setContentProvider((IContentProvider)new DataAndImageTreeNodeContentProvider());
        this.treeClassesViewer.setLabelProvider((IBaseLabelProvider)HierarchyViewer.createLabelProvider());
        this.treeClassesViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                ISelection selection = event.getSelection();
                HierarchyViewer.this.handleSelection(selection, 2);
            }
        });
        this.treeClassesViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                ISelection selection = event.getSelection();
                HierarchyViewer.this.handleSelection(selection, 1);
            }
        });
        this.treeMembers = new Tree(parent, 2818);
        this.treeMembers.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDoubleClick(MouseEvent e) {
                Object data;
                ItemPointer p;
                TreeItem[] selection = HierarchyViewer.this.treeMembers.getSelection();
                if (selection.length > 0 && (p = (ItemPointer)(data = selection[0].getData())) != null) {
                    new PyOpenAction().run(p);
                }
            }
        });
    }

    public void setHierarchy(HierarchyNodeModel model) {
        DataAndImageTreeNode item;
        if (classImage == null) {
            classImage = SharedUiPlugin.getImageCache().get("icons/new/class_obj.gif");
        }
        DataAndImageTreeNode root = new DataAndImageTreeNode(null, null, null);
        DataAndImageTreeNode base = item = new DataAndImageTreeNode(root, (Object)model, classImage);
        this.recursivelyAdd(model, base, true, new HashSet<HierarchyNodeModel>());
        if (parentsImage == null) {
            parentsImage = SharedUiPlugin.getImageCache().get("icons/class_hi.gif");
        }
        DataAndImageTreeNode parents = new DataAndImageTreeNode(root, (Object)"Parents", parentsImage);
        this.recursivelyAdd(model, parents, false, new HashSet<HierarchyNodeModel>());
        this.treeClassesViewer.setInput((Object)root);
        this.onClick(model, 1);
    }

    private void recursivelyAdd(HierarchyNodeModel model, DataAndImageTreeNode base, boolean addChildren, HashSet<HierarchyNodeModel> memo) {
        List items;
        List list = items = addChildren ? model.children : model.parents;
        if (items != null) {
            for (HierarchyNodeModel modelNode : items) {
                if (memo.contains(modelNode)) {
                    new DataAndImageTreeNode(base, (Object)(modelNode.name + " already added."), classImage);
                    continue;
                }
                memo.add(modelNode);
                DataAndImageTreeNode item = new DataAndImageTreeNode(base, (Object)modelNode, classImage);
                this.recursivelyAdd(modelNode, item, addChildren, memo);
            }
        }
    }

    private void onClick(final HierarchyNodeModel model, int clickCount) {
        if (clickCount == 2) {
            IModule m;
            if (model != null && (m = model.module) != null && model.ast != null) {
                ItemPointer pointer = new ItemPointer((Object)m.getFile(), (SimpleNode)model.ast.name);
                new PyOpenAction().run(pointer);
            }
        } else {
            Runnable r = new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    Object object = HierarchyViewer.this.lock;
                    synchronized (object) {
                        if (HierarchyViewer.this.treeMembers.getItemCount() > 0) {
                            HierarchyViewer.this.treeMembers.removeAll();
                        }
                        if (model == null) {
                            return;
                        }
                        ClassDef ast = model.ast;
                        if (ast != null && HierarchyViewer.this.treeMembers != null) {
                            DefinitionsASTIteratorVisitor visitor = DefinitionsASTIteratorVisitor.create((SimpleNode)ast);
                            Iterator outline = visitor.getOutline();
                            HashMap<SimpleNode, TreeItem> c = new HashMap<SimpleNode, TreeItem>();
                            boolean first = true;
                            while (outline.hasNext()) {
                                ASTEntry entry = (ASTEntry)outline.next();
                                if (first) {
                                    first = false;
                                    continue;
                                }
                                TreeItem item = null;
                                if (entry.node instanceof FunctionDef) {
                                    item = this.createTreeItem(c, entry);
                                    item.setImage(ImageCache.asImage((IImageHandle)SharedUiPlugin.getImageCache().get("icons/new/method_obj.gif")));
                                    if (model.module != null) {
                                        item.setData((Object)new ItemPointer((Object)model.module.getFile(), (SimpleNode)((FunctionDef)entry.node).name));
                                    }
                                } else if (entry.node instanceof ClassDef) {
                                    item = this.createTreeItem(c, entry);
                                    item.setImage(ImageCache.asImage((IImageHandle)SharedUiPlugin.getImageCache().get("icons/new/class_obj.gif")));
                                    if (model.module != null) {
                                        item.setData((Object)new ItemPointer((Object)model.module.getFile(), (SimpleNode)((ClassDef)entry.node).name));
                                    }
                                } else {
                                    item = this.createTreeItem(c, entry);
                                    item.setImage(ImageCache.asImage((IImageHandle)SharedUiPlugin.getImageCache().get("icons/new/attrpub_obj.gif")));
                                    if (model.module != null) {
                                        item.setData((Object)new ItemPointer((Object)model.module.getFile(), entry.node));
                                    }
                                }
                                item.setText(entry.getName());
                                item.setExpanded(true);
                            }
                        }
                    }
                }

                private TreeItem createTreeItem(HashMap<SimpleNode, TreeItem> c, ASTEntry entry) {
                    TreeItem parent = null;
                    ASTEntry par = entry.parent;
                    if (par != null) {
                        parent = c.get(par.node);
                    }
                    TreeItem item = parent == null ? new TreeItem(HierarchyViewer.this.treeMembers, 0) : new TreeItem(parent, 0);
                    c.put(entry.node, item);
                    return item;
                }
            };
            Display.getDefault().asyncExec(r);
        }
    }

    private void handleSelection(ISelection selection, int clickCount) {
        HierarchyNodeModel model = null;
        if (selection instanceof IStructuredSelection) {
            IStructuredSelection iStructuredSelection = (IStructuredSelection)selection;
            Object firstElement = iStructuredSelection.getFirstElement();
            if (firstElement instanceof DataAndImageTreeNode) {
                DataAndImageTreeNode treeNode = (DataAndImageTreeNode)firstElement;
                Object data = treeNode.data;
                if (data instanceof HierarchyNodeModel) {
                    model = (HierarchyNodeModel)data;
                }
            } else if (firstElement instanceof HierarchyNodeModel) {
                model = (HierarchyNodeModel)firstElement;
            }
        }
        this.onClick(model, clickCount);
    }

    public void setNewOrientation(int orientation) {
        if (this.sash != null && !this.sash.isDisposed() && this.fParent != null && !this.fParent.isDisposed()) {
            GridLayout layout = (GridLayout)this.fParent.getLayout();
            if (orientation == 1) {
                this.sash.setOrientation(256);
                layout.numColumns = 2;
            } else {
                this.sash.setOrientation(512);
                layout.numColumns = 1;
            }
            this.fParent.layout();
        }
    }
}

