/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.builder.pyright;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.preference.BooleanFieldEditor;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.jface.preference.FileFieldEditor;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.program.Program;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.python.pydev.plugin.PydevPlugin;
import org.python.pydev.shared_ui.field_editors.ArgsStringFieldEditor;
import org.python.pydev.shared_ui.field_editors.LinkFieldEditor;
import org.python.pydev.shared_ui.field_editors.RadioGroupFieldEditor;
import org.python.pydev.shared_ui.field_editors.ScopedFieldEditorPreferencePage;
import org.python.pydev.shared_ui.field_editors.ScopedPreferencesFieldEditor;

public class PyrightPrefPage
extends ScopedFieldEditorPreferencePage
implements IWorkbenchPreferencePage {
    private Composite parent;
    private RadioGroupFieldEditor searchPyrightLocation;
    private FileFieldEditor fileField;
    private List<FieldEditor> fields = new ArrayList<FieldEditor>(5);
    public static final String[][] SEARCH_PYRIGHT_LOCATION_OPTIONS = new String[][]{{"Search in interpreter", "SEARCH"}, {"Specify Location", "SPECIFY"}};

    public PyrightPrefPage() {
        super(0);
        this.setPreferenceStore(PydevPlugin.getDefault().getPreferenceStore());
        this.setDescription("Pyright");
    }

    public void init(IWorkbench workbench) {
    }

    protected void initialize() {
        super.initialize();
        this.updateSelectFileEnablement(this.parent);
    }

    protected void createFieldEditors() {
        this.parent = this.getFieldEditorParent();
        this.parent.setLayout((Layout)new GridLayout(1, false));
        this.addField((FieldEditor)new BooleanFieldEditor("USE_PYRIGHT", "Use Pyright?", this.parent));
        this.addField((FieldEditor)new BooleanFieldEditor("PYRIGHT_USE_CONSOLE", "Redirect Pyright output to console?", this.parent));
        this.searchPyrightLocation = new RadioGroupFieldEditor("SEARCH_PYRIGHT_LOCATION", "Pyright to use", 2, SEARCH_PYRIGHT_LOCATION_OPTIONS, this.parent);
        Button[] buttonArray = this.searchPyrightLocation.getRadioButtons();
        int n = buttonArray.length;
        int n2 = 0;
        while (n2 < n) {
            Button b = buttonArray[n2];
            b.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    PyrightPrefPage.this.updateSelectFileEnablement(PyrightPrefPage.this.parent);
                }
            });
            ++n2;
        }
        this.addField((FieldEditor)this.searchPyrightLocation);
        this.fileField = new FileFieldEditor("PYRIGHT_FILE_LOCATION", "Location of the pyright executable:", true, this.parent);
        this.addField((FieldEditor)this.fileField);
        ArgsStringFieldEditor stringFieldEditor = new ArgsStringFieldEditor("PYRIGHT_ARGS", "Arguments to pass to the pyright command.", this.parent);
        this.addField((FieldEditor)stringFieldEditor);
        this.addField((FieldEditor)new LinkFieldEditor("PYRIGHT_HELP", "View <a>http://www.pydev.org/manual_adv_pyright.html</a> for help.", this.parent, new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                Program.launch((String)"http://www.pydev.org/manual_adv_pyright.html");
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        }));
        this.addField((FieldEditor)new ScopedPreferencesFieldEditor(this.parent, "org.python.pydev", (ScopedFieldEditorPreferencePage)this));
    }

    protected void addField(FieldEditor editor) {
        super.addField(editor);
        this.fields.add(editor);
    }

    protected void adjustGridLayout() {
        this.parent = this.getFieldEditorParent();
        this.parent.setLayout((Layout)new GridLayout(1, false));
    }

    protected void updateSelectFileEnablement(Composite p) {
        this.fileField.setEnabled("SPECIFY".equals(this.searchPyrightLocation.getRadioValue()), p);
    }
}

