/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.builder.ruff;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.preference.BooleanFieldEditor;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.jface.preference.FileFieldEditor;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.program.Program;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.python.pydev.plugin.PydevPlugin;
import org.python.pydev.shared_ui.field_editors.ArgsStringFieldEditor;
import org.python.pydev.shared_ui.field_editors.LinkFieldEditor;
import org.python.pydev.shared_ui.field_editors.RadioGroupFieldEditor;
import org.python.pydev.shared_ui.field_editors.ScopedFieldEditorPreferencePage;
import org.python.pydev.shared_ui.field_editors.ScopedPreferencesFieldEditor;

public class RuffPrefPage
extends ScopedFieldEditorPreferencePage
implements IWorkbenchPreferencePage {
    private Composite parent;
    private RadioGroupFieldEditor searchRuffLocation;
    private FileFieldEditor fileField;
    private List<FieldEditor> fields = new ArrayList<FieldEditor>(5);
    public static final String[][] SEARCH_RUFF_LOCATION_OPTIONS = new String[][]{{"Search in interpreter", "SEARCH"}, {"Specify Location", "SPECIFY"}};

    public RuffPrefPage() {
        super(0);
        this.setPreferenceStore(PydevPlugin.getDefault().getPreferenceStore());
        this.setDescription("Ruff");
    }

    public void init(IWorkbench workbench) {
    }

    protected void initialize() {
        super.initialize();
        this.updateSelectFileEnablement(this.parent);
    }

    protected void createFieldEditors() {
        this.parent = this.getFieldEditorParent();
        this.parent.setLayout((Layout)new GridLayout(1, false));
        this.addField((FieldEditor)new BooleanFieldEditor("USE_RUFF", "Use Ruff?", this.parent));
        this.addField((FieldEditor)new BooleanFieldEditor("RUFF_USE_CONSOLE", "Redirect Ruff output to console?", this.parent));
        this.searchRuffLocation = new RadioGroupFieldEditor("SEARCH_RUFF_LOCATION", "Ruff to use", 2, SEARCH_RUFF_LOCATION_OPTIONS, this.parent);
        Button[] buttonArray = this.searchRuffLocation.getRadioButtons();
        int n = buttonArray.length;
        int n2 = 0;
        while (n2 < n) {
            Button b = buttonArray[n2];
            b.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    RuffPrefPage.this.updateSelectFileEnablement(RuffPrefPage.this.parent);
                }
            });
            ++n2;
        }
        this.addField((FieldEditor)this.searchRuffLocation);
        this.fileField = new FileFieldEditor("RUFF_FILE_LOCATION", "Location of the ruff executable:", true, this.parent);
        this.addField((FieldEditor)this.fileField);
        ArgsStringFieldEditor stringFieldEditor = new ArgsStringFieldEditor("RUFF_ARGS", "Arguments to pass to the ruff command.", this.parent);
        this.addField((FieldEditor)stringFieldEditor);
        this.addField((FieldEditor)new LinkFieldEditor("RUFF_HELP", "View <a>http://www.pydev.org/manual_adv_ruff.html</a> for help.", this.parent, new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                Program.launch((String)"http://www.pydev.org/manual_adv_ruff.html");
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        }));
        this.addField((FieldEditor)new ScopedPreferencesFieldEditor(this.parent, "org.python.pydev", (ScopedFieldEditorPreferencePage)this));
    }

    protected void addField(FieldEditor editor) {
        super.addField(editor);
        this.fields.add(editor);
    }

    protected void adjustGridLayout() {
        this.parent = this.getFieldEditorParent();
        this.parent.setLayout((Layout)new GridLayout(1, false));
    }

    protected void updateSelectFileEnablement(Composite p) {
        this.fileField.setEnabled("SPECIFY".equals(this.searchRuffLocation.getRadioValue()), p);
    }
}

