/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.editor;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IRegion;
import org.python.pydev.editor.ICodeScannerKeywords;
import org.python.pydev.editor.PyDecoratorRule;
import org.python.pydev.editor.PyWordRule;
import org.python.pydev.shared_core.callbacks.ICallbackListener;
import org.python.pydev.shared_core.partitioner.IRule;
import org.python.pydev.shared_core.partitioner.IToken;
import org.python.pydev.shared_core.partitioner.IWhitespaceDetector;
import org.python.pydev.shared_core.partitioner.IWordDetector;
import org.python.pydev.shared_core.partitioner.RuleBasedScanner;
import org.python.pydev.shared_core.partitioner.Token;
import org.python.pydev.shared_core.partitioner.WhitespaceRule;
import org.python.pydev.shared_core.partitioner.WordRule;
import org.python.pydev.shared_core.string.FastStringBuffer;
import org.python.pydev.shared_core.utils.ArrayUtils;
import org.python.pydev.ui.ColorAndStyleCache;

public class PyCodeScanner
extends RuleBasedScanner {
    public static final String[] DEFAULT_KEYWORDS = new String[]{"and", "as", "assert", "async", "await", "break", "case", "class", "continue", "def", "del", "elif", "else", "except", "exec", "finally", "for", "from", "global", "if", "import", "in", "is", "lambda", "match", "nonlocal", "not", "or", "pass", "print", "raise", "return", "self", "try", "while", "with", "yield", "False", "None", "True"};
    public static String[] CYTHON_KEYWORDS = new String[]{"cimport", "cdef", "ctypedef"};
    private final ColorAndStyleCache colorCache;
    private IToken keywordToken;
    private IToken selfToken;
    private IToken defaultToken;
    private IToken decoratorToken;
    private IToken numberToken;
    private IToken classNameToken;
    private IToken funcNameToken;
    private IToken parensToken;
    private IToken operatorsToken;
    private String[] keywords;
    private ICodeScannerKeywords codeScannerKeywords;

    static {
        CYTHON_KEYWORDS = (String[])ArrayUtils.concatArrays((Object[][])new String[][]{DEFAULT_KEYWORDS, CYTHON_KEYWORDS});
        Arrays.sort(CYTHON_KEYWORDS);
    }

    public PyCodeScanner(ColorAndStyleCache colorCache) {
        this(colorCache, DEFAULT_KEYWORDS);
    }

    public PyCodeScanner(ColorAndStyleCache colorCache, String[] keywords) {
        this.keywords = keywords;
        this.colorCache = colorCache;
        this.setupRules();
    }

    public PyCodeScanner(ColorAndStyleCache colorCache, ICodeScannerKeywords codeScannerKeywords) {
        this.colorCache = colorCache;
        this.codeScannerKeywords = codeScannerKeywords;
        this.keywords = codeScannerKeywords.getKeywords();
        this.setupRules();
        codeScannerKeywords.getOnChangeCallbackWithListeners().registerListener(new ICallbackListener(){

            public Object call(Object obj) {
                PyCodeScanner.this.keywords = PyCodeScanner.this.codeScannerKeywords.getKeywords();
                PyCodeScanner.this.setupRules();
                return null;
            }
        });
    }

    public void updateColors() {
        this.setupRules();
    }

    private void setupRules() {
        WhitespaceRule whitespaceRule;
        this.keywordToken = new Token((Object)this.colorCache.getKeywordTextAttribute());
        this.selfToken = new Token((Object)this.colorCache.getSelfTextAttribute());
        this.defaultToken = new Token((Object)this.colorCache.getCodeTextAttribute());
        this.decoratorToken = new Token((Object)this.colorCache.getDecoratorTextAttribute());
        this.numberToken = new Token((Object)this.colorCache.getNumberTextAttribute());
        this.classNameToken = new Token((Object)this.colorCache.getClassNameTextAttribute());
        this.funcNameToken = new Token((Object)this.colorCache.getFuncNameTextAttribute());
        this.parensToken = new Token((Object)this.colorCache.getParensTextAttribute());
        this.operatorsToken = new Token((Object)this.colorCache.getOperatorsTextAttribute());
        this.setDefaultReturnToken(this.defaultToken);
        ArrayList<Object> rules = new ArrayList<Object>();
        try {
            whitespaceRule = new WhitespaceRule((IWhitespaceDetector)new GreatWhite(), this.defaultToken);
        }
        catch (Throwable e) {
            whitespaceRule = new WhitespaceRule((IWhitespaceDetector)new GreatWhite());
        }
        rules.add(whitespaceRule);
        HashMap<String, IToken> defaults = new HashMap<String, IToken>();
        defaults.put("self", this.selfToken);
        rules.add(new PyDecoratorRule(this.decoratorToken));
        PyWordRule wordRule = new PyWordRule(this.defaultToken, this.classNameToken, this.funcNameToken, this.parensToken, this.operatorsToken);
        String[] stringArray = this.keywords;
        int n = this.keywords.length;
        int n2 = 0;
        while (n2 < n) {
            String keyword = stringArray[n2];
            IToken token = (IToken)defaults.get(keyword);
            if (token == null) {
                token = this.keywordToken;
            }
            wordRule.addWord(keyword, token);
            ++n2;
        }
        rules.add(wordRule);
        rules.add(new WordRule((IWordDetector)new NumberDetector(), this.numberToken));
        this.setRules(rules.toArray(new IRule[0]));
    }

    public void setKeywords(String[] keywords) {
        this.keywords = keywords;
        this.setupRules();
    }

    public String getLineContentsToCursor(int diffOffset) throws BadLocationException {
        int currLine = this.fDocument.getLineOfOffset(this.fOffset);
        IRegion lineInformation = this.fDocument.getLineInformation(currLine);
        int lineOffset = lineInformation.getOffset();
        return this.fDocument.get(lineOffset, this.fOffset - lineOffset + diffOffset);
    }

    private static class GreatWhite
    implements IWhitespaceDetector {
        private GreatWhite() {
        }

        public boolean isWhitespace(char c) {
            return Character.isWhitespace(c);
        }
    }

    public static class NumberDetector
    implements IWordDetector {
        private FastStringBuffer buffer = new FastStringBuffer();
        private boolean isInHexa;

        public boolean isWordStart(char c) {
            this.isInHexa = false;
            this.buffer.clear();
            this.buffer.append(c);
            return Character.isDigit(c);
        }

        public boolean isWordPart(char c) {
            if ((c == 'x' || c == 'X') && this.buffer.length() == 1 && this.buffer.charAt(0) == '0') {
                this.buffer.append(c);
                this.isInHexa = true;
                return true;
            }
            this.buffer.append(c);
            if (this.isInHexa) {
                return Character.isDigit(c) || c == 'a' || c == 'A' || c == 'b' || c == 'B' || c == 'c' || c == 'C' || c == 'd' || c == 'D' || c == 'e' || c == 'E' || c == 'f' || c == 'F';
            }
            return Character.isDigit(c) || c == 'e' || c == '.';
        }
    }
}

