/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.editor;

import org.eclipse.jface.text.BadLocationException;
import org.python.pydev.editor.PyCodeScanner;
import org.python.pydev.shared_core.partitioner.ICharacterScanner;
import org.python.pydev.shared_core.partitioner.IRule;
import org.python.pydev.shared_core.partitioner.IToken;
import org.python.pydev.shared_core.partitioner.Token;

public class PyDecoratorRule
implements IRule {
    private IToken decoratorToken;

    public PyDecoratorRule(IToken decoratorToken) {
        this.decoratorToken = decoratorToken;
    }

    public boolean isWordPart(int c) {
        return c != 10 && c != 13 && c != 40 && c != -1;
    }

    public IToken evaluate(ICharacterScanner scanner) {
        String currLineContents;
        int c = scanner.read();
        if (c != 64) {
            scanner.unread();
            return Token.UNDEFINED;
        }
        PyCodeScanner codeScanner = (PyCodeScanner)scanner;
        try {
            int diffOffset = -1;
            currLineContents = codeScanner.getLineContentsToCursor(diffOffset);
        }
        catch (BadLocationException e) {
            scanner.unread();
            return Token.UNDEFINED;
        }
        if (currLineContents.trim().length() == 0) {
            while (this.isWordPart(c = scanner.read())) {
            }
            scanner.unread();
            return this.decoratorToken;
        }
        scanner.unread();
        return Token.UNDEFINED;
    }
}

