/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.editor;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IPathEditorInput;
import org.eclipse.ui.IURIEditorInput;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.python.pydev.core.concurrency.SingleJobRunningPool;
import org.python.pydev.core.log.Log;
import org.python.pydev.editor.PyEdit;
import org.python.pydev.plugin.PydevPlugin;
import org.python.pydev.plugin.preferences.PyTitlePreferencesPage;
import org.python.pydev.shared_core.callbacks.ICallback0;
import org.python.pydev.shared_core.image.IImageHandle;
import org.python.pydev.shared_core.string.StringUtils;
import org.python.pydev.shared_core.structure.Tuple;
import org.python.pydev.shared_ui.ImageCache;
import org.python.pydev.shared_ui.utils.RunInUiThread;

final class PyEditTitle
implements IPropertyChangeListener {
    private static PyEditTitle singleton;
    private static Object lock;
    private SingleJobRunningPool jobPool = new SingleJobRunningPool();

    static {
        lock = new Object();
    }

    private PyEditTitle() {
        IPreferenceStore preferenceStore = PydevPlugin.getDefault().getPreferenceStore();
        preferenceStore.addPropertyChangeListener((IPropertyChangeListener)this);
    }

    public void propertyChange(PropertyChangeEvent event) {
        String property = event.getProperty();
        if (PyTitlePreferencesPage.isTitlePreferencesProperty(property)) {
            Job job = new Job("Invalidate title"){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                protected IStatus run(IProgressMonitor monitor) {
                    try {
                        List<IEditorReference> currentEditorReferences;
                        do {
                            currentEditorReferences = PyEditTitle.this.getCurrentEditorReferences();
                            1 var3_3 = this;
                            synchronized (var3_3) {
                                try {
                                    Thread.sleep(200L);
                                }
                                catch (InterruptedException interruptedException) {
                                    // empty catch block
                                }
                            }
                        } while (PydevPlugin.isAlive() && currentEditorReferences == null);
                        if (currentEditorReferences != null) {
                            final List<IEditorReference> refs = currentEditorReferences;
                            RunInUiThread.sync((Runnable)new Runnable(){

                                @Override
                                public void run() {
                                    for (IEditorReference iEditorReference : refs) {
                                        IEditorPart editor = iEditorReference.getEditor(true);
                                        if (!(editor instanceof PyEdit)) continue;
                                        try {
                                            PyEditTitle.invalidateTitle((PyEdit)editor, iEditorReference.getEditorInput());
                                        }
                                        catch (PartInitException partInitException) {
                                            // empty catch block
                                        }
                                    }
                                }
                            });
                        }
                    }
                    finally {
                        PyEditTitle.this.jobPool.removeJob((Job)this);
                    }
                    return Status.OK_STATUS;
                }
            };
            job.setPriority(20);
            this.jobPool.addJob(job);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void invalidateTitle(PyEdit pyEdit, IEditorInput input) {
        Object object = lock;
        synchronized (object) {
            boolean createdSingleton = false;
            if (singleton == null) {
                singleton = new PyEditTitle();
                createdSingleton = true;
            }
            singleton.invalidateTitleInput(pyEdit, input);
            if (createdSingleton) {
                singleton.restoreAllPydevEditorsWithDifferentIcon();
            }
        }
    }

    private void restoreAllPydevEditorsWithDifferentIcon() {
        if (!PyTitlePreferencesPage.useCustomInitIcon()) {
            return;
        }
        Job job = new Job("Invalidate images"){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Handled impossible loop by duplicating code
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            protected IStatus run(IProgressMonitor monitor) {
                try {
                    block11: {
                        block10: {
                            if (!true) break block10;
                            if (!PydevPlugin.isAlive()) return Status.OK_STATUS;
                            if (PyEditTitle.this.doRestoreAllPydevEditorsWithDifferentIcons()) break block11;
                        }
                        do {
                            2 var2_2 = this;
                            synchronized (var2_2) {
                                try {
                                    Thread.sleep(200L);
                                }
                                catch (InterruptedException interruptedException) {
                                    // empty catch block
                                }
                            }
                            if (!PydevPlugin.isAlive()) return Status.OK_STATUS;
                        } while (!PyEditTitle.this.doRestoreAllPydevEditorsWithDifferentIcons());
                    }
                    return Status.OK_STATUS;
                }
                finally {
                    PyEditTitle.this.jobPool.removeJob((Job)this);
                }
            }
        };
        job.setPriority(20);
        this.jobPool.addJob(job);
    }

    private boolean doRestoreAllPydevEditorsWithDifferentIcons() {
        if (!PyTitlePreferencesPage.useCustomInitIcon()) {
            return true;
        }
        final List<IEditorReference> editorReferences = this.getCurrentEditorReferences();
        if (editorReferences == null) {
            return false;
        }
        RunInUiThread.async((Runnable)new Runnable(){

            @Override
            public void run() {
                for (IEditorReference iEditorReference : editorReferences) {
                    try {
                        String lastSegment;
                        IPath pathFromInput;
                        if (iEditorReference == null || (pathFromInput = PyEditTitle.this.getPathFromInput(iEditorReference.getEditorInput())) == null || (lastSegment = pathFromInput.lastSegment()) == null || !lastSegment.startsWith("__init__.") && !PyTitlePreferencesPage.isDjangoModuleToDecorate(lastSegment)) continue;
                        iEditorReference.getEditor(true);
                    }
                    catch (PartInitException partInitException) {
                        // empty catch block
                    }
                }
            }
        });
        return true;
    }

    private void invalidateTitleInput(final PyEdit pyEdit, final IEditorInput input) {
        if (input == null) {
            return;
        }
        final IPath pathFromInput = this.getPathFromInput(input);
        if (pathFromInput == null || pathFromInput.segmentCount() == 0) {
            return;
        }
        final String lastSegment = pathFromInput.lastSegment();
        if (lastSegment == null) {
            return;
        }
        final String initHandling = PyTitlePreferencesPage.getInitHandling();
        final String djangoModulesHandling = PyTitlePreferencesPage.getDjangoModulesHandling();
        String computedEditorTitle = (String)this.getPartNameInLevel((int)1, (IPath)pathFromInput, (String)initHandling, (String)djangoModulesHandling, (IEditorInput)input).o1;
        pyEdit.setEditorTitle(computedEditorTitle);
        this.updateImage(pyEdit, null, pathFromInput);
        if (!PyTitlePreferencesPage.getEditorNamesUnique()) {
            return;
        }
        Job job = new Job("Invalidate title"){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Handled impossible loop by duplicating code
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            protected IStatus run(IProgressMonitor monitor) {
                try {
                    block11: {
                        block10: {
                            if (!true) break block10;
                            if (!PydevPlugin.isAlive()) return Status.OK_STATUS;
                            if (PyEditTitle.this.initializeTitle(pyEdit, input, pathFromInput, lastSegment, initHandling, djangoModulesHandling)) break block11;
                        }
                        do {
                            4 var2_2 = this;
                            synchronized (var2_2) {
                                try {
                                    Thread.sleep(200L);
                                }
                                catch (InterruptedException interruptedException) {
                                    // empty catch block
                                }
                            }
                            if (!PydevPlugin.isAlive()) return Status.OK_STATUS;
                        } while (!PyEditTitle.this.initializeTitle(pyEdit, input, pathFromInput, lastSegment, initHandling, djangoModulesHandling));
                    }
                    return Status.OK_STATUS;
                }
                finally {
                    PyEditTitle.this.jobPool.removeJob((Job)this);
                }
            }
        };
        job.setPriority(20);
        this.jobPool.addJob(job);
    }

    private void updateImage(PyEdit pyEdit, IEditorReference iEditorReference, IPath path) {
        String lastSegment = path.lastSegment();
        if (lastSegment != null) {
            if (lastSegment.startsWith("__init__.")) {
                Image initIcon = ImageCache.asImage((IImageHandle)PyTitlePreferencesPage.getInitIcon());
                if (initIcon != null) {
                    if (pyEdit != null) {
                        pyEdit.setEditorImage(initIcon);
                    } else {
                        this.setEditorReferenceImage(iEditorReference, initIcon);
                    }
                }
            } else if (PyTitlePreferencesPage.isDjangoModuleToDecorate(lastSegment)) {
                try {
                    IEditorInput editorInput = pyEdit != null ? pyEdit.getEditorInput() : iEditorReference.getEditorInput();
                    if (this.isDjangoHandledModule(PyTitlePreferencesPage.getDjangoModulesHandling(), editorInput, lastSegment)) {
                        Image image = ImageCache.asImage((IImageHandle)PyTitlePreferencesPage.getDjangoModuleIcon(lastSegment));
                        if (pyEdit != null) {
                            pyEdit.setEditorImage(image);
                        } else {
                            this.setEditorReferenceImage(iEditorReference, image);
                        }
                    }
                }
                catch (PartInitException partInitException) {
                    // empty catch block
                }
            }
        }
    }

    private boolean initializeTitle(PyEdit pyEdit, IEditorInput input, IPath pathFromInput, String lastSegment, String initHandling, String djangoModulesHandling) {
        List<IEditorReference> editorReferences = this.getCurrentEditorReferences();
        if (editorReferences == null) {
            return false;
        }
        Map<IPath, List<IEditorReference>> partsAndPaths = this.removeEditorsNotMatchingCurrentName(lastSegment, editorReferences);
        if (partsAndPaths.size() > 1) {
            ArrayList<IPath> keys = new ArrayList<IPath>(partsAndPaths.keySet());
            int level = 0;
            ArrayList<String> names = new ArrayList<String>();
            HashMap<String, Integer> allNames = new HashMap<String, Integer>();
            do {
                names.clear();
                allNames.clear();
                ++level;
                int i = 0;
                while (i < keys.size()) {
                    block14: {
                        IPath path = keys.get(i);
                        List<IEditorReference> refs = partsAndPaths.get(path);
                        if (refs == null || refs.size() == 0) {
                            Log.log((String)("Unexpected condition. Key path without related editors: " + String.valueOf(path)));
                            keys.remove(i);
                            --i;
                        } else {
                            IEditorInput editorInput;
                            try {
                                editorInput = refs.get(0).getEditorInput();
                            }
                            catch (PartInitException e) {
                                break block14;
                            }
                            Tuple<String, Boolean> nameAndReachedMax = this.getPartNameInLevel(level, path, initHandling, djangoModulesHandling, editorInput);
                            if (((Boolean)nameAndReachedMax.o2).booleanValue()) {
                                this.setEditorReferenceTitle(refs, (String)nameAndReachedMax.o1);
                                keys.remove(i);
                                --i;
                            } else {
                                names.add((String)nameAndReachedMax.o1);
                                Integer count = (Integer)allNames.get(nameAndReachedMax.o1);
                                if (count == null) {
                                    allNames.put((String)nameAndReachedMax.o1, 1);
                                } else {
                                    allNames.put((String)nameAndReachedMax.o1, count + 1);
                                }
                            }
                        }
                    }
                    ++i;
                }
                i = 0;
                while (i < keys.size()) {
                    String finalName = (String)names.get(i);
                    Integer count = (Integer)allNames.get(finalName);
                    if (count == 1) {
                        IPath path = keys.get(i);
                        List<IEditorReference> refs = partsAndPaths.get(path);
                        this.setEditorReferenceTitle(refs, finalName);
                        keys.remove(i);
                        names.remove(i);
                        allNames.remove(finalName);
                        --i;
                    }
                    ++i;
                }
            } while (allNames.size() > 0);
        }
        return true;
    }

    private Map<IPath, List<IEditorReference>> removeEditorsNotMatchingCurrentName(String currentName, List<IEditorReference> editorReferences) {
        HashMap<IPath, List<IEditorReference>> ret = new HashMap<IPath, List<IEditorReference>>();
        for (IEditorReference iEditorReference : editorReferences) {
            try {
                String lastSegment;
                IEditorInput otherInput = iEditorReference.getEditorInput();
                IPath pathFromOtherInput = this.getPathFromInput(otherInput);
                if (pathFromOtherInput == null || (lastSegment = pathFromOtherInput.lastSegment()) == null || !currentName.equals(lastSegment)) continue;
                ArrayList<IEditorReference> list = (ArrayList<IEditorReference>)ret.get(pathFromOtherInput);
                if (list == null) {
                    list = new ArrayList<IEditorReference>();
                    ret.put(pathFromOtherInput, list);
                }
                list.add(iEditorReference);
            }
            catch (Throwable e) {
                Log.log((Throwable)e);
            }
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<IEditorReference> getCurrentEditorReferences() {
        final ArrayList editorReferencesFound = new ArrayList();
        RunInUiThread.async((Runnable)new Runnable(){

            @Override
            public void run() {
                IEditorReference[] found = null;
                try {
                    IWorkbenchWindow workbenchWindow = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
                    if (workbenchWindow == null) {
                        return;
                    }
                    IWorkbenchPage activePage = workbenchWindow.getActivePage();
                    if (activePage == null) {
                        return;
                    }
                    found = activePage.getEditorReferences();
                }
                finally {
                    editorReferencesFound.add(found);
                }
            }
        });
        while (editorReferencesFound.size() == 0) {
            PyEditTitle pyEditTitle = this;
            synchronized (pyEditTitle) {
                try {
                    this.wait(10L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
        IEditorReference[] editorReferences = (IEditorReference[])editorReferencesFound.get(0);
        if (editorReferences == null) {
            return null;
        }
        ArrayList<IEditorReference> ret = new ArrayList<IEditorReference>();
        IEditorReference[] iEditorReferenceArray = editorReferences;
        int n = editorReferences.length;
        int n2 = 0;
        while (n2 < n) {
            IEditorReference iEditorReference = iEditorReferenceArray[n2];
            if ("org.python.pydev.editor.PythonEditor".equals(iEditorReference.getId())) {
                ret.add(iEditorReference);
            }
            ++n2;
        }
        return ret;
    }

    private void setEditorReferenceImage(final IEditorReference iEditorReference, final Image image) {
        RunInUiThread.async((Runnable)new Runnable(){

            @Override
            public void run() {
                try {
                    IEditorPart editor = iEditorReference.getEditor(true);
                    if (editor instanceof PyEdit) {
                        ((PyEdit)editor).setEditorImage(image);
                    }
                }
                catch (Throwable e) {
                    Log.log((Throwable)e);
                }
            }
        });
    }

    private void setEditorReferenceTitle(final List<IEditorReference> refs, final String title) {
        if (refs == null) {
            return;
        }
        int size = refs.size();
        if (size == 1) {
            for (final IEditorReference ref : refs) {
                if (title.equals(ref.getTitle())) {
                    return;
                }
                RunInUiThread.async((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        try {
                            IEditorPart editor = ref.getEditor(true);
                            if (editor instanceof PyEdit) {
                                ((PyEdit)editor).setEditorTitle(title);
                            }
                        }
                        catch (Throwable e) {
                            Log.log((Throwable)e);
                        }
                    }
                });
            }
        } else if (size > 1) {
            RunInUiThread.async((Runnable)new Runnable(){

                @Override
                public void run() {
                    try {
                        String key = "PyEditTitleEditorNumberSet";
                        final HashSet<Integer> used = new HashSet<Integer>();
                        ArrayList<PyEdit> toSet = new ArrayList<PyEdit>();
                        for (IEditorReference ref : refs) {
                            PyEdit editor = (PyEdit)ref.getEditor(true);
                            Integer curr = (Integer)editor.cache.get("PyEditTitleEditorNumberSet");
                            if (curr != null) {
                                used.add(curr);
                                editor.setEditorTitle(title + " #" + (curr + 1));
                                continue;
                            }
                            toSet.add(editor);
                        }
                        ICallback0<Integer> next = new ICallback0<Integer>(){
                            private int last = 0;

                            public Integer call() {
                                while (this.last < Integer.MAX_VALUE) {
                                    if (!used.contains(this.last)) {
                                        used.add(this.last);
                                        return this.last;
                                    }
                                    ++this.last;
                                }
                                throw new AssertionError((Object)"Should not get here");
                            }
                        };
                        for (PyEdit editor : toSet) {
                            Integer i = (Integer)next.call();
                            editor.setEditorTitle(title + " #" + (i + 1));
                        }
                    }
                    catch (Throwable e) {
                        Log.log((Throwable)e);
                    }
                }
            });
        }
    }

    private Tuple<String, Boolean> getPartNameInLevel(int level, IPath path, String initHandling, String djangoModulesHandling, IEditorInput input) {
        int i;
        String name = input.getName();
        String[] segments = path.segments();
        if (segments.length == 0) {
            return new Tuple((Object)"", (Object)true);
        }
        if (segments.length == 1) {
            return new Tuple((Object)segments[1], (Object)true);
        }
        boolean handled = this.isDjangoHandledModule(djangoModulesHandling, input, name);
        if (handled && djangoModulesHandling == "TITLE_EDITOR_DJANGO_MODULES_SHOW_PARENT_AND_DECORATE") {
            dest = new String[segments.length - 1];
            System.arraycopy(segments, 0, dest, 0, dest.length);
            segments = dest;
        } else if (initHandling != "TITLE_EDITOR_INIT_HANDLING_IN_TITLE" && name.startsWith("__init__.")) {
            dest = new String[segments.length - 1];
            System.arraycopy(segments, 0, dest, 0, dest.length);
            segments = dest;
            if (dest.length > 0) {
                name = dest[dest.length - 1];
            }
        }
        int startAt = segments.length - level;
        if (startAt < 0) {
            startAt = 0;
        }
        int endAt = segments.length - 1;
        String modulePart = StringUtils.join((String)".", (String[])segments, (int)startAt, (int)endAt);
        if (!PyTitlePreferencesPage.getTitleShowExtension() && (i = name.lastIndexOf(46)) != -1) {
            name = name.substring(0, i);
        }
        if (modulePart.length() > 0) {
            return new Tuple((Object)(name + " (" + modulePart + ")"), (Object)(startAt == 0 ? 1 : 0));
        }
        return new Tuple((Object)name, (Object)(startAt == 0 ? 1 : 0));
    }

    private boolean isDjangoHandledModule(String djangoModulesHandling, IEditorInput input, String lastSegment) {
        boolean handled = false;
        if ((djangoModulesHandling == "TITLE_EDITOR_DJANGO_MODULES_SHOW_PARENT_AND_DECORATE" || djangoModulesHandling == "TITLE_EDITOR_DJANGO_MODULES_DECORATE") && input instanceof IFileEditorInput) {
            IFileEditorInput iFileEditorInput = (IFileEditorInput)input;
            IFile file = iFileEditorInput.getFile();
            IProject project = file.getProject();
            try {
                if (project.hasNature("org.python.pydev.django.djangoNature") && PyTitlePreferencesPage.isDjangoModuleToDecorate(lastSegment)) {
                    handled = true;
                }
            }
            catch (CoreException e) {
                Log.log((Throwable)e);
            }
        }
        return handled;
    }

    private IPath getPathFromInput(IEditorInput otherInput) {
        IPath path = null;
        if (otherInput instanceof IPathEditorInput) {
            IPathEditorInput iPathEditorInput = (IPathEditorInput)otherInput;
            try {
                path = iPathEditorInput.getPath();
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        if (path == null && otherInput instanceof IFileEditorInput) {
            IFileEditorInput iFileEditorInput = (IFileEditorInput)otherInput;
            path = iFileEditorInput.getFile().getFullPath();
        }
        if (path == null) {
            try {
                if (otherInput instanceof IURIEditorInput) {
                    IURIEditorInput iuriEditorInput = (IURIEditorInput)otherInput;
                    path = Path.fromOSString((String)new File(iuriEditorInput.getURI()).toString());
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return path;
    }
}

