/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.editor;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.eclipse.jface.resource.JFaceColors;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.TextPresentation;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.internal.SWTEventListener;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.TypedListener;
import org.python.pydev.ast.item_pointer.ItemPointer;
import org.python.pydev.editor.PyLineBreakReader;
import org.python.pydev.editor.actions.PyOpenAction;
import org.python.pydev.shared_core.string.FastStringBuffer;
import org.python.pydev.shared_ui.tooltips.presenter.AbstractInformationPresenter;

public class PyInformationPresenter
extends AbstractInformationPresenter {
    private ControlListener resizeCallback;
    private TypedListener resizeListener = new TypedListener((SWTEventListener)new ControlListener(){

        public void controlMoved(ControlEvent e) {
            if (PyInformationPresenter.this.resizeCallback != null) {
                PyInformationPresenter.this.resizeCallback.controlMoved(e);
            }
        }

        public void controlResized(ControlEvent e) {
            if (PyInformationPresenter.this.resizeCallback != null) {
                PyInformationPresenter.this.resizeCallback.controlResized(e);
            }
        }
    });

    public Reader createReader(String hoverInfo, TextPresentation presentation) {
        String str = hoverInfo;
        str = this.correctLineDelimiters(str);
        ArrayList<PyStyleRange> lst = new ArrayList<PyStyleRange>();
        str = this.handlePydevTags(lst, str);
        Collections.sort(lst, new Comparator<PyStyleRange>(){

            @Override
            public int compare(PyStyleRange o1, PyStyleRange o2) {
                return Integer.compare(o1.start, o2.start);
            }
        });
        for (PyStyleRange pyStyleRange : lst) {
            presentation.addStyleRange((StyleRange)pyStyleRange);
        }
        return new StringReader(str);
    }

    private String handlePydevTags(List<PyStyleRange> lst, String str) {
        FastStringBuffer buf = new FastStringBuffer(str.length());
        String newString = this.handleLinks(lst, str, buf.clear(), "pydev_hint_bold", false);
        newString = this.handleLinks(lst, newString, buf.clear(), "pydev_link", true);
        return newString;
    }

    private String handleLinks(List<PyStyleRange> lst, String str, FastStringBuffer buf, String tag, boolean addLinkUnderline) {
        int startTagLen;
        int end;
        int start;
        int lastIndex = 0;
        String startTag = "<" + tag;
        String endTag = "</" + tag + ">";
        int endTagLen = endTag.length();
        while ((start = str.indexOf(startTag, lastIndex)) != -1 && (end = str.indexOf(endTag, start + (startTagLen = str.indexOf(">", start) - start + 1))) != -1 && end != start) {
            int initialIndex = lastIndex;
            lastIndex = end + endTagLen;
            buf.append(str.substring(initialIndex, start));
            int startRange = buf.length();
            buf.append(str.substring(start + startTagLen, end));
            int endRange = buf.length();
            PyStyleRange styleRange = new PyStyleRange(startRange, endRange - startRange, JFaceColors.getHyperlinkText((Display)Display.getDefault()), null, 1);
            styleRange.tagReplaced = str.substring(start, start + startTagLen);
            if (addLinkUnderline) {
                styleRange.underline = true;
                try {
                    styleRange.underlineStyle = 4;
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            lst.add(styleRange);
        }
        buf.append(str.substring(lastIndex, str.length()));
        String newString = buf.toString();
        return newString;
    }

    private void append(FastStringBuffer buffer, String string) {
        buffer.append(string);
    }

    public String updatePresentation(Drawable drawable, String hoverInfo, TextPresentation presentation, int maxWidth, int maxHeight) {
        Control control;
        if (drawable instanceof StyledText) {
            final StyledText styledText = (StyledText)drawable;
            styledText.addMouseListener((MouseListener)new MouseAdapter(){

                public void mouseDown(MouseEvent e) {
                    String tagReplaced;
                    int offset = styledText.getOffsetAtPoint(new Point(e.x, e.y));
                    if (offset == -1) {
                        return;
                    }
                    StyleRange r = styledText.getStyleRangeAtOffset(offset);
                    if (r instanceof PyStyleRange && (tagReplaced = ((PyStyleRange)r).tagReplaced) != null) {
                        String start = "<pydev_link pointer=\"";
                        String end = "\">";
                        if (tagReplaced.startsWith(start) && tagReplaced.endsWith(end)) {
                            String pointer = tagReplaced.substring(start.length(), tagReplaced.length() - end.length());
                            new PyOpenAction().run(ItemPointer.fromPortableString((String)pointer));
                        }
                    }
                }
            });
        }
        if (drawable instanceof Control && !Arrays.asList((control = (Control)drawable).getListeners(11)).contains(this.resizeListener)) {
            control.addListener(11, (Listener)this.resizeListener);
            control.addListener(10, (Listener)this.resizeListener);
        }
        if (hoverInfo == null) {
            return null;
        }
        GC gc = new GC(drawable);
        try {
            FastStringBuffer buffer = new FastStringBuffer();
            int maxNumberOfLines = Math.round((float)maxHeight / (float)gc.getFontMetrics().getHeight());
            PyLineBreakReader reader = new PyLineBreakReader(this.createReader(hoverInfo, presentation));
            String line = reader.readLine();
            boolean firstLineProcessed = false;
            while (line != null) {
                if (maxNumberOfLines <= 0) break;
                if (firstLineProcessed) {
                    this.append(buffer, LINE_DELIM);
                }
                this.append(buffer, line);
                firstLineProcessed = true;
                line = reader.readLine();
                --maxNumberOfLines;
            }
            if (line != null) {
                this.append(buffer, LINE_DELIM);
            }
            String string = this.trim(buffer, presentation);
            return string;
        }
        catch (IOException e) {
            return null;
        }
        finally {
            gc.dispose();
        }
    }

    private String trim(FastStringBuffer buffer, TextPresentation presentation) {
        int length = buffer.length();
        int end = length - 1;
        while (end >= 0 && Character.isWhitespace(buffer.charAt(end))) {
            --end;
        }
        if (end == -1) {
            return "";
        }
        if (end < length - 1) {
            buffer.delete(end + 1, length);
        } else {
            end = length;
        }
        int start = 0;
        while (start < end && (buffer.charAt(start) == '\n' || buffer.charAt(start) == '\r')) {
            ++start;
        }
        buffer.delete(0, start);
        presentation.setResultWindow((IRegion)new Region(start, buffer.length()));
        return buffer.toString();
    }

    public void addResizeCallback(ControlListener listener) {
        this.resizeCallback = listener;
    }

    public static class PyStyleRange
    extends StyleRange {
        public String tagReplaced;

        public PyStyleRange() {
        }

        public PyStyleRange(int start, int length, Color foreground, Color background) {
            super(start, length, foreground, background);
        }

        public PyStyleRange(int start, int length, Color foreground, Color background, int fontStyle) {
            super(start, length, foreground, background, fontStyle);
        }

        public boolean similarTo(StyleRange style) {
            if (!super.similarTo(style)) {
                return false;
            }
            if (style instanceof PyStyleRange) {
                String otherTagReplaced = ((PyStyleRange)style).tagReplaced;
                if (this.tagReplaced == null) {
                    return otherTagReplaced == null;
                }
                return this.tagReplaced.equals(otherTagReplaced);
            }
            return true;
        }
    }
}

