/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.editor;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.Assert;
import org.python.pydev.shared_core.partitioner.ICharacterScanner;
import org.python.pydev.shared_core.partitioner.IRule;
import org.python.pydev.shared_core.partitioner.IToken;
import org.python.pydev.shared_core.partitioner.Token;
import org.python.pydev.shared_core.string.FastStringBuffer;

public class PyWordRule
implements IRule {
    protected static final int UNDEFINED = -1;
    protected IToken fDefaultToken;
    protected int fColumn = -1;
    protected Map<String, IToken> fWords = new HashMap<String, IToken>();
    private FastStringBuffer fBuffer = new FastStringBuffer();
    private IToken classNameToken;
    private IToken funcNameToken;
    private IToken parensToken;
    private IToken operatorsToken;
    private String lastFound = "";
    private int lastChar = 0;

    public PyWordRule(IToken defaultToken, IToken classNameToken, IToken funcNameToken, IToken parensToken, IToken operatorsToken) {
        Assert.isNotNull((Object)defaultToken);
        this.fDefaultToken = defaultToken;
        this.classNameToken = classNameToken;
        this.funcNameToken = funcNameToken;
        this.parensToken = parensToken;
        this.operatorsToken = operatorsToken;
    }

    public void addWord(String word, IToken token) {
        Assert.isNotNull((Object)word);
        Assert.isNotNull((Object)token);
        this.fWords.put(word, token);
    }

    public void setColumnConstraint(int column) {
        if (column < 0) {
            column = -1;
        }
        this.fColumn = column;
    }

    public IToken evaluate(ICharacterScanner scanner) {
        int c;
        int currLastChar = this.lastChar;
        this.lastChar = c = scanner.read();
        IToken found = null;
        switch (c) {
            case 40: 
            case 41: 
            case 91: 
            case 93: 
            case 123: 
            case 125: {
                found = this.parensToken;
                break;
            }
            case 33: 
            case 37: 
            case 38: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 47: 
            case 60: 
            case 61: 
            case 62: 
            case 64: 
            case 94: 
            case 124: 
            case 126: {
                found = this.operatorsToken;
            }
        }
        if (found != null) {
            this.lastFound = "";
            return found;
        }
        if (Character.isJavaIdentifierStart(c) && (this.fColumn == -1 || this.fColumn == scanner.getColumn() - 1)) {
            boolean isSoftKeyword;
            this.fBuffer.clear();
            do {
                this.fBuffer.append((char)c);
            } while ((c = scanner.read()) != -1 && Character.isJavaIdentifierPart(c));
            scanner.unread();
            String str = this.fBuffer.toString();
            IToken token = this.fWords.get(str);
            boolean bl = isSoftKeyword = str.equals("match") || str.equals("case");
            if (isSoftKeyword) {
                if (currLastChar == 46) {
                    token = null;
                } else {
                    int nextNonWhitespaceChar = this.lookAheadNextNonWhitespaceChar(scanner);
                    if (nextNonWhitespaceChar == 61) {
                        token = null;
                    }
                }
            }
            if (token != null) {
                this.lastFound = str;
                return token;
            }
            if (this.fDefaultToken.isUndefined()) {
                this.unreadBuffer(scanner);
            }
            if (this.lastFound.equals("def")) {
                this.lastFound = str;
                return this.funcNameToken;
            }
            if (this.lastFound.equals("class")) {
                this.lastFound = str;
                return this.classNameToken;
            }
            return this.fDefaultToken;
        }
        scanner.unread();
        return Token.UNDEFINED;
    }

    private int lookAheadNextNonWhitespaceChar(ICharacterScanner scanner) {
        int c;
        int readChars = 0;
        do {
            c = scanner.read();
            ++readChars;
        } while (Character.isWhitespace(c) && c != -1);
        int i = 0;
        while (i < readChars) {
            scanner.unread();
            ++i;
        }
        return c;
    }

    protected void unreadBuffer(ICharacterScanner scanner) {
        int lenLess1;
        int i = lenLess1 = this.fBuffer.length() - 1;
        while (i >= 0) {
            scanner.unread();
            --i;
        }
    }
}

