/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.editor.actions;

import java.io.File;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.DocumentRewriteSession;
import org.eclipse.jface.text.DocumentRewriteSessionType;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentExtension4;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.ui.texteditor.ITextEditor;
import org.python.pydev.ast.formatter.PyFormatter;
import org.python.pydev.core.ExtensionHelper;
import org.python.pydev.core.IPyFormatStdProvider;
import org.python.pydev.core.docutils.PySelection;
import org.python.pydev.core.docutils.SyntaxErrorException;
import org.python.pydev.core.formatter.FormatStd;
import org.python.pydev.core.formatter.PyFormatterPreferences;
import org.python.pydev.editor.PyEdit;
import org.python.pydev.editor.PySelectionFromEditor;
import org.python.pydev.editor.actions.PyAction;
import org.python.pydev.editor.actions.SelectionKeeper;
import org.python.pydev.parser.prettyprinterv2.IFormatter;
import org.python.pydev.shared_core.io.FileUtils;
import org.python.pydev.shared_core.string.TextSelectionUtils;

public class PyFormatAction
extends PyAction
implements IFormatter {
    public void run(IAction action) {
        try {
            if (!this.canModifyEditor()) {
                return;
            }
            PyEdit pyEdit = this.getPyEdit();
            PySelection ps = PySelectionFromEditor.createPySelectionFromEditor((ITextEditor)pyEdit);
            try {
                int[] regionsToFormat = null;
                if (ps.getSelLength() > 0) {
                    int startLineIndex = ps.getStartLineIndex();
                    int endLineIndex = ps.getEndLineIndex();
                    regionsToFormat = new int[endLineIndex - startLineIndex + 1];
                    int i = startLineIndex;
                    int j = 0;
                    while (i <= endLineIndex) {
                        regionsToFormat[j] = i++;
                        ++j;
                    }
                } else if (pyEdit.hasSyntaxError(ps.getDoc())) {
                    return;
                }
                this.applyFormatAction((IPyFormatStdProvider)pyEdit, ps, regionsToFormat, true, pyEdit.getSelectionProvider());
            }
            catch (SyntaxErrorException e) {
                pyEdit.getStatusLineManager().setErrorMessage(e.getMessage());
            }
        }
        catch (Exception e) {
            PyFormatAction.beep((Exception)e);
        }
    }

    public void applyFormatAction(IPyFormatStdProvider pyEdit, PySelection ps, int[] regionsToFormat, boolean throwSyntaxError, ISelectionProvider selectionProvider) throws BadLocationException, SyntaxErrorException {
        IFormatter participant = this.getFormatter();
        IDocument doc = ps.getDoc();
        SelectionKeeper selectionKeeper = new SelectionKeeper((TextSelectionUtils)ps);
        DocumentRewriteSession session = null;
        try {
            if (regionsToFormat == null || regionsToFormat.length == 0) {
                if (doc instanceof IDocumentExtension4) {
                    IDocumentExtension4 ext = (IDocumentExtension4)doc;
                    session = ext.startRewriteSession(DocumentRewriteSessionType.STRICTLY_SEQUENTIAL);
                }
                participant.formatAll(doc, pyEdit, null, true, throwSyntaxError);
            } else {
                if (doc instanceof IDocumentExtension4) {
                    IDocumentExtension4 ext = (IDocumentExtension4)doc;
                    session = ext.startRewriteSession(DocumentRewriteSessionType.SEQUENTIAL);
                }
                participant.formatSelection(doc, regionsToFormat, pyEdit, ps);
            }
        }
        catch (Throwable throwable) {
            if (session != null) {
                ((IDocumentExtension4)doc).stopRewriteSession(session);
            }
            throw throwable;
        }
        if (session != null) {
            ((IDocumentExtension4)doc).stopRewriteSession(session);
        }
        if (selectionProvider != null) {
            selectionKeeper.restoreSelection(selectionProvider, doc);
        }
    }

    public IFormatter getFormatter() {
        IFormatter participant = (IFormatter)ExtensionHelper.getParticipant((String)"org.python.pydev.pydev_formatter", (boolean)false);
        if (participant == null) {
            participant = this;
        }
        return participant;
    }

    public void formatSelection(IDocument doc, int[] regionsForSave, IPyFormatStdProvider edit, PySelection ps) {
        FormatStd formatStd = PyFormatterPreferences.getFormatStd((IAdaptable)edit);
        PyFormatter.formatSelection((IDocument)doc, (int[])regionsForSave, (IPyFormatStdProvider)edit, (PySelection)ps, (FormatStd)formatStd);
    }

    public void formatAll(IDocument doc, IPyFormatStdProvider edit, IFile f, boolean isOpenedFile, boolean throwSyntaxError) throws SyntaxErrorException {
        File editorFile;
        FormatStd formatStd = (FormatStd)(edit != null ? edit.getFormatStd() : PyFormatterPreferences.getFormatStd((IAdaptable)f));
        String filepath = null;
        if (edit != null && (editorFile = edit.getEditorFile()) != null) {
            filepath = FileUtils.getFileAbsolutePath((File)editorFile);
        }
        if (filepath == null && f != null) {
            IPath path = f.getLocation().makeAbsolute();
            filepath = path.toOSString();
        }
        PyFormatter.formatAll((String)filepath, (IDocument)doc, (IPyFormatStdProvider)edit, (boolean)isOpenedFile, (FormatStd)formatStd, (boolean)throwSyntaxError, (boolean)true);
    }
}

