/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.editor.actions;

import java.io.File;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.DocumentRewriteSession;
import org.eclipse.jface.text.IDocument;
import org.eclipse.ui.texteditor.ITextEditor;
import org.python.pydev.ast.sort_imports.SortImports;
import org.python.pydev.core.ExtensionHelper;
import org.python.pydev.core.IPyFormatStdProvider;
import org.python.pydev.core.IPythonNature;
import org.python.pydev.core.MisconfigurationException;
import org.python.pydev.core.PythonNatureWithoutProjectException;
import org.python.pydev.core.autoedit.DefaultIndentPrefs;
import org.python.pydev.core.docutils.PySelection;
import org.python.pydev.core.docutils.SyntaxErrorException;
import org.python.pydev.core.imports.ImportPreferences;
import org.python.pydev.core.log.Log;
import org.python.pydev.editor.PyEdit;
import org.python.pydev.editor.PySelectionFromEditor;
import org.python.pydev.editor.actions.IOrganizeImports;
import org.python.pydev.editor.actions.OrganizeImportsFixesUnused;
import org.python.pydev.editor.actions.PyAction;
import org.python.pydev.parser.prettyprinterv2.IFormatter;
import org.python.pydev.plugin.PyDevUiPrefs;
import org.python.pydev.shared_core.SharedCorePlugin;
import org.python.pydev.shared_core.string.TextSelectionUtils;

public class PyOrganizeImports
extends PyAction
implements IFormatter {
    private final boolean automatic;

    public PyOrganizeImports() {
        this.automatic = false;
    }

    public PyOrganizeImports(boolean automatic) {
        this.automatic = automatic;
    }

    public void run(IAction action) {
        block7: {
            try {
                if (!this.canModifyEditor()) {
                    return;
                }
                PyEdit pyEdit = this.getPyEdit();
                PySelection ps = PySelectionFromEditor.createPySelectionFromEditor((ITextEditor)pyEdit);
                IDocument doc = ps.getDoc();
                if (ps.getStartLineIndex() == ps.getEndLineIndex()) {
                    this.organizeImports(pyEdit, doc, null, ps);
                    break block7;
                }
                DocumentRewriteSession session = TextSelectionUtils.startWrite((IDocument)doc);
                try {
                    ps.performSimpleSort(doc, ps.getStartLineIndex(), ps.getEndLineIndex());
                }
                finally {
                    TextSelectionUtils.endWrite((IDocument)doc, (DocumentRewriteSession)session);
                }
            }
            catch (Exception e) {
                Log.log((Throwable)e);
                PyOrganizeImports.beep((Exception)e);
            }
        }
    }

    private void organizeImports(PyEdit edit, IDocument doc, IFile f, PySelection ps) throws MisconfigurationException, PythonNatureWithoutProjectException {
        String fileContents;
        String endLineDelim = ps.getEndLineDelim();
        List participants = null;
        if (f == null && !this.automatic) {
            participants = ExtensionHelper.getParticipants((String)"org.python.pydev.pydev_organize_imports");
            for (IOrganizeImports organizeImports : participants) {
                if (organizeImports.beforePerformArrangeImports(ps, edit, f)) continue;
                return;
            }
        }
        if ((fileContents = doc.get()).contains("isort:skip_file") || fileContents.length() == 0) {
            return;
        }
        PyEdit projectAdaptable = edit != null ? edit : f;
        String indentStr = edit != null ? edit.getIndentPrefs().getIndentationString() : DefaultIndentPrefs.get((IAdaptable)f).getIndentationString();
        DocumentRewriteSession session = null;
        session = TextSelectionUtils.startWrite((IDocument)doc);
        try {
            IPath location;
            File targetFile;
            boolean removeUnusedImports = false;
            if (!this.automatic && (removeUnusedImports = ImportPreferences.getDeleteUnusedImports((IAdaptable)projectAdaptable))) {
                new OrganizeImportsFixesUnused().beforePerformArrangeImports(ps, edit, f);
            }
            IPythonNature pythonNature = null;
            if (edit != null) {
                pythonNature = edit.getPythonNature();
            }
            File file = targetFile = edit != null ? edit.getEditorFile() : null;
            if (targetFile == null && f != null && (location = f.getLocation()) != null) {
                targetFile = location.toFile();
            }
            SortImports sortImports = new SortImports();
            int maxCols = PyOrganizeImports.getMaxCols(ImportPreferences.getMultilineImports((IAdaptable)edit));
            sortImports.sortImports(pythonNature, (IAdaptable)projectAdaptable, targetFile, fileContents, doc, removeUnusedImports, endLineDelim, indentStr, this.automatic, (IPyFormatStdProvider)edit, maxCols);
            if (participants != null) {
                for (IOrganizeImports organizeImports : participants) {
                    organizeImports.afterPerformArrangeImports(ps, edit);
                }
            }
        }
        finally {
            TextSelectionUtils.endWrite((IDocument)doc, (DocumentRewriteSession)session);
        }
    }

    private static int getMaxCols(boolean multilineImports) {
        int maxCols;
        if (multilineImports) {
            if (SharedCorePlugin.inTestMode()) {
                maxCols = 80;
            } else {
                IPreferenceStore chainedPrefStore = PyDevUiPrefs.getChainedPrefStore();
                maxCols = chainedPrefStore.getInt("printMarginColumn");
            }
        } else {
            maxCols = Integer.MAX_VALUE;
        }
        return maxCols;
    }

    public void formatAll(IDocument doc, IPyFormatStdProvider edit, IFile f, boolean isOpenedFile, boolean throwSyntaxError) throws SyntaxErrorException {
        try {
            this.organizeImports((PyEdit)edit, doc, f, new PySelection(doc));
        }
        catch (MisconfigurationException | PythonNatureWithoutProjectException e) {
            Log.log((Throwable)e);
        }
    }

    public void formatSelection(IDocument doc, int[] regionsToFormat, IPyFormatStdProvider edit, PySelection ps) {
        throw new UnsupportedOperationException();
    }
}

