/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.editor.actions.refactoring;

import java.io.File;
import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.action.IAction;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.WorkspaceModifyOperation;
import org.eclipse.ui.progress.UIJob;
import org.python.pydev.ast.refactoring.AbstractPyRefactoring;
import org.python.pydev.ast.refactoring.IPyRefactoring;
import org.python.pydev.ast.refactoring.RefactoringRequest;
import org.python.pydev.core.IPyEdit;
import org.python.pydev.core.IPythonNature;
import org.python.pydev.core.MisconfigurationException;
import org.python.pydev.core.docutils.PySelection;
import org.python.pydev.core.log.Log;
import org.python.pydev.editor.PyEdit;
import org.python.pydev.editor.PySelectionFromEditor;
import org.python.pydev.editor.actions.PyAction;
import org.python.pydev.ui.dialogs.PyDialogHelpers;

public abstract class PyRefactorAction
extends PyAction {
    protected IWorkbenchWindow workbenchWindow;
    protected volatile RefactoringRequest request;
    protected PySelection ps;

    public RefactoringRequest getRefactoringRequest() throws MisconfigurationException {
        return this.getRefactoringRequest(null);
    }

    public RefactoringRequest getRefactoringRequest(IProgressMonitor monitor) throws MisconfigurationException {
        if (this.request == null) {
            PyEdit pyEdit = this.getPyEdit();
            this.request = PyRefactorAction.createRefactoringRequest(monitor, pyEdit, this.ps);
        }
        this.request.pushMonitor(monitor);
        return this.request;
    }

    public static RefactoringRequest createRefactoringRequest(IProgressMonitor monitor, PyEdit pyEdit, PySelection ps) throws MisconfigurationException {
        File file = pyEdit.getEditorFile();
        IPythonNature nature = pyEdit.getPythonNature();
        RefactoringRequest req = new RefactoringRequest(file, ps, monitor, nature, (IPyEdit)pyEdit);
        return req;
    }

    protected boolean areRefactorPreconditionsOK(RefactoringRequest request, IPyRefactoring pyRefactoring) {
        boolean editorsSaved;
        this.workbenchWindow = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        IEditorPart[] dirtyEditors = this.workbenchWindow.getActivePage().getDirtyEditors();
        boolean saveEditors = false;
        if (dirtyEditors.length > 0 && !(saveEditors = PyDialogHelpers.openQuestionWithIgnoreToggle("Save All?", "All the editors must be saved to make this operation.\nIs it ok to save them?", "REFACTOR_PRECONDITION_TOGGLE"))) {
            return false;
        }
        return !saveEditors || (editorsSaved = this.workbenchWindow.getActivePage().saveAllEditors(false));
    }

    public void run(final IAction action) {
        RefactoringRequest req;
        this.request = null;
        this.ps = PySelectionFromEditor.createPySelectionFromEditor(this.getTextEditor());
        try {
            req = this.getRefactoringRequest();
        }
        catch (MisconfigurationException e2) {
            Log.log((Throwable)e2);
            return;
        }
        IPyRefactoring pyRefactoring = AbstractPyRefactoring.getPyRefactoring();
        if (!this.areRefactorPreconditionsOK(req, pyRefactoring)) {
            return;
        }
        UIJob job = new UIJob("Performing: " + ((Object)((Object)this)).getClass().getName()){

            public IStatus runInUIThread(IProgressMonitor monitor) {
                try {
                    Operation o = new Operation(action);
                    o.execute(monitor);
                }
                catch (Exception e) {
                    Log.log((Throwable)e);
                }
                return Status.OK_STATUS;
            }
        };
        job.setSystem(true);
        job.schedule();
    }

    protected Shell getPyEditShell() {
        return this.getPyEdit().getSite().getShell();
    }

    protected abstract String perform(IAction var1, IProgressMonitor var2) throws Exception;

    private final class Operation
    extends WorkspaceModifyOperation {
        private final IAction action;

        public Operation(IAction action) {
            this.action = action;
        }

        protected void execute(IProgressMonitor monitor) throws CoreException, InvocationTargetException, InterruptedException {
            try {
                monitor.beginTask("Refactor", -1);
                PyRefactorAction.this.perform(this.action, monitor);
                monitor.done();
            }
            catch (Exception e) {
                Log.log((Throwable)e);
            }
        }
    }
}

