/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.editor.codecompletion;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.lang.reflect.Method;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jdt.core.CompletionProposal;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.ui.JavadocContentAccess;
import org.eclipse.jdt.ui.text.java.CompletionProposalLabelProvider;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.Image;
import org.python.pydev.ast.codecompletion.revisited.modules.CompiledToken;
import org.python.pydev.core.log.Log;
import org.python.pydev.shared_core.image.IImageHandle;
import org.python.pydev.shared_core.string.FastStringBuffer;
import org.python.pydev.shared_core.string.StringUtils;
import org.python.pydev.shared_core.utils.Reflection;

public class JavaElementToken
extends CompiledToken {
    public IJavaElement javaElement;
    private int completionProposalKind;
    private int completionProposalFlags;
    private int completionProposalAdditionalFlags;
    private char[] completionProposalSignature;
    private IImageHandle image;
    static boolean HAS_ADDITIONAL_FLAGS = true;

    static {
        try {
            Method m = Reflection.findMethod(CompletionProposal.class, (String)"getAdditionalFlags", (Object[])new Object[0]);
            if (m == null) {
                HAS_ADDITIONAL_FLAGS = false;
            }
        }
        catch (Throwable e) {
            HAS_ADDITIONAL_FLAGS = false;
        }
    }

    protected JavaElementToken(String rep, String doc, String args, String parentPackage, int type, IJavaElement javaElement, int completionProposalKind, int completionProposalFlags, int completionProposalAdditionalFlags, char[] completionProposalSignature) {
        super(rep, doc, args, parentPackage, type, null);
        this.javaElement = javaElement;
        this.completionProposalKind = completionProposalKind;
        this.completionProposalFlags = completionProposalFlags;
        this.completionProposalAdditionalFlags = completionProposalAdditionalFlags;
        this.completionProposalSignature = completionProposalSignature;
    }

    public JavaElementToken(String rep, String doc, String args, String parentPackage, int type, IJavaElement javaElement, CompletionProposal completionProposal) {
        super(rep, doc, args, parentPackage, type, null);
        this.javaElement = javaElement;
        this.completionProposalKind = completionProposal.getKind();
        this.completionProposalFlags = completionProposal.getFlags();
        if (HAS_ADDITIONAL_FLAGS) {
            this.completionProposalAdditionalFlags = completionProposal.getAdditionalFlags();
        }
        this.completionProposalSignature = completionProposal.getSignature();
    }

    public JavaElementToken(String rep, String doc, String args, String parentPackage, int type, IJavaElement javaElement, IImageHandle image) {
        super(rep, doc, args, parentPackage, type, null);
        this.javaElement = javaElement;
        this.image = image;
    }

    public IImageHandle getImage() {
        if (this.image != null) {
            return this.image;
        }
        CompletionProposalLabelProvider provider = new CompletionProposalLabelProvider();
        CompletionProposal generatedProposal = CompletionProposal.create((int)this.completionProposalKind, (int)0);
        generatedProposal.setFlags(this.completionProposalFlags);
        if (HAS_ADDITIONAL_FLAGS) {
            generatedProposal.setAdditionalFlags(this.completionProposalAdditionalFlags);
        }
        generatedProposal.setDeclarationSignature(this.completionProposalSignature);
        generatedProposal.setSignature(this.completionProposalSignature);
        ImageDescriptor descriptor = provider.createImageDescriptor(generatedProposal);
        final Image computed = descriptor.createImage();
        return new IImageHandle(){

            public Object getImageData() {
                return computed.getImageData();
            }

            public Object getImage() {
                return computed;
            }
        };
    }

    public String getDocStr() {
        if (this.javaElement instanceof IMember) {
            IMember member = (IMember)this.javaElement;
            try {
                return StringUtils.extractTextFromHTML((String)this.extractJavadoc(member, (IProgressMonitor)new NullProgressMonitor()));
            }
            catch (JavaModelException javaModelException) {
            }
            catch (Exception e) {
                Log.log((String)("Error getting completion for " + String.valueOf(member)), (Throwable)e);
            }
        }
        return null;
    }

    private String extractJavadoc(IMember member, IProgressMonitor monitor) throws JavaModelException, IOException {
        Reader reader;
        if (member != null && (reader = this.getContentReader(member, monitor)) != null) {
            return JavaElementToken.getString(reader);
        }
        return null;
    }

    private Reader getContentReader(IMember member, IProgressMonitor monitor) throws JavaModelException {
        String s;
        Reader contentReader = JavadocContentAccess.getContentReader((IMember)member, (boolean)true);
        if (contentReader != null) {
            return contentReader;
        }
        if (member.getOpenable().getBuffer() == null && (s = member.getAttachedJavadoc(monitor)) != null) {
            return new StringReader(s);
        }
        return null;
    }

    private static String getString(Reader reader) {
        FastStringBuffer buf = new FastStringBuffer();
        char[] buffer = new char[1024];
        try {
            int count;
            while ((count = reader.read(buffer)) != -1) {
                buf.append(buffer, 0, count);
            }
        }
        catch (IOException e) {
            return null;
        }
        return buf.toString();
    }
}

