/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.editor.codecompletion;

import java.io.IOException;
import java.util.ArrayList;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.contentassist.ContentAssistEvent;
import org.eclipse.jface.text.contentassist.ICompletionListener;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.eclipse.jface.text.contentassist.IContextInformationValidator;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.python.pydev.ast.codecompletion.CompletionRequest;
import org.python.pydev.ast.codecompletion.IPyCodeCompletion;
import org.python.pydev.ast.codecompletion.PyCodeCompletion;
import org.python.pydev.ast.codecompletion.PyCodeCompletionPreferences;
import org.python.pydev.ast.codecompletion.PyCodeCompletionUtils;
import org.python.pydev.ast.interpreter_managers.ChooseInterpreterManager;
import org.python.pydev.core.IInterpreterManager;
import org.python.pydev.core.IPySyntaxHighlightingAndCodeCompletionEditor;
import org.python.pydev.core.IPythonNature;
import org.python.pydev.core.MisconfigurationException;
import org.python.pydev.core.PythonNatureWithoutProjectException;
import org.python.pydev.core.TokensOrProposalsList;
import org.python.pydev.core.docutils.PySelection;
import org.python.pydev.core.log.Log;
import org.python.pydev.editor.codecompletion.CompletionError;
import org.python.pydev.editor.codecompletion.ConvertCompletionProposals;
import org.python.pydev.editor.codecompletion.IPyTemplateCompletionProcessor;
import org.python.pydev.editor.codecompletion.PyContentAssistant;
import org.python.pydev.editor.codecompletion.PyContextInformationValidator;
import org.python.pydev.editor.codecompletion.PyTemplateCompletionProcessor;
import org.python.pydev.plugin.PyDevUiPrefs;
import org.python.pydev.plugin.nature.SystemPythonNature;
import org.python.pydev.shared_core.code_completion.ICompletionProposalHandle;
import org.python.pydev.shared_core.string.StringUtils;
import org.python.pydev.shared_ui.content_assist.AbstractCompletionProcessorWithCycling;
import org.python.pydev.shared_ui.content_assist.DefaultContentAssist;

public class PythonCompletionProcessor
extends AbstractCompletionProcessorWithCycling {
    private IPyTemplateCompletionProcessor templatesCompletion = new PyTemplateCompletionProcessor();
    private IPyCodeCompletion codeCompletion;
    private IPySyntaxHighlightingAndCodeCompletionEditor edit;
    private String error;
    private static volatile char[] activationChars = null;
    private PyContextInformationValidator contextInformationValidator;
    private static volatile boolean listenerToClearAutoActivationAlreadySetup = false;

    public PythonCompletionProcessor(IPySyntaxHighlightingAndCodeCompletionEditor edit, PyContentAssistant pyContentAssistant) {
        super((DefaultContentAssist)pyContentAssistant);
        this.edit = edit;
        this.contentAssistant = pyContentAssistant;
        this.codeCompletion = this.getCodeCompletionEngine();
        this.contextInformationValidator = new PyContextInformationValidator();
        pyContentAssistant.addCompletionListener(new ICompletionListener(){

            public void assistSessionEnded(ContentAssistEvent event) {
            }

            public void assistSessionStarted(ContentAssistEvent event) {
                PythonCompletionProcessor.this.startCycle();
            }

            public void selectionChanged(ICompletionProposal proposal, boolean smartToggle) {
            }
        });
    }

    protected IPyCodeCompletion getCodeCompletionEngine() {
        return new PyCodeCompletion();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ICompletionProposal[] computeCompletionProposals(ITextViewer viewer, int documentOffset) {
        ICompletionProposalHandle[] proposals;
        this.updateStatus();
        try {
            IDocument doc = viewer.getDocument();
            TokensOrProposalsList pythonAndTemplateProposals = new TokensOrProposalsList();
            IPythonNature nature = this.edit.getPythonNature();
            if (nature == null) {
                IInterpreterManager manager = ChooseInterpreterManager.chooseInterpreterManager();
                if (manager == null) {
                    CompletionError completionError = new CompletionError(new RuntimeException("No interpreter configured."));
                    this.error = completionError.getErrorMessage();
                    return new ICompletionProposal[]{completionError};
                }
                nature = new SystemPythonNature(manager);
            }
            if (nature == null || !nature.startRequests()) {
                return new ICompletionProposal[0];
            }
            try {
                CompletionRequest request = new CompletionRequest(this.edit.getEditorFile(), nature, doc, documentOffset, this.codeCompletion, PyCodeCompletionPreferences.getUseSubstringMatchInCodeCompletion());
                if (PyCodeCompletionPreferences.useCodeCompletion() && this.whatToShow == 1) {
                    try {
                        pythonAndTemplateProposals.addAll(this.getPythonProposals(documentOffset, doc, request));
                    }
                    catch (Throwable e) {
                        Log.log((Throwable)e);
                        CompletionError completionError = new CompletionError(e);
                        this.error = completionError.getErrorMessage();
                        ICompletionProposal[] iCompletionProposalArray = new ICompletionProposal[]{completionError};
                        nature.endRequests();
                        return iCompletionProposalArray;
                    }
                }
                String[] strs = PySelection.getActivationTokenAndQualifier((IDocument)doc, (int)documentOffset, (boolean)false);
                String activationToken = strs[0];
                String qualifier = strs[1];
                if (request.showTemplates && (activationToken == null || activationToken.trim().length() == 0)) {
                    TokensOrProposalsList templateProposals = this.getTemplateProposals(viewer, documentOffset, activationToken, qualifier);
                    pythonAndTemplateProposals.addAll(templateProposals);
                }
                proposals = PyCodeCompletionUtils.onlyValid((TokensOrProposalsList)pythonAndTemplateProposals, (String)request.qualifier, (boolean)request.isInCalltip, (boolean)request.useSubstringMatchInCodeCompletion, (IProject)nature.getProject());
            }
            finally {
                nature.endRequests();
            }
        }
        catch (Exception e) {
            Log.log((Throwable)e);
            CompletionError completionError = new CompletionError(e);
            this.error = completionError.getErrorMessage();
            return new ICompletionProposal[]{completionError};
        }
        this.doCycle();
        return ConvertCompletionProposals.convertHandlesToProposals(proposals);
    }

    private TokensOrProposalsList getPythonProposals(int documentOffset, IDocument doc, CompletionRequest request) throws CoreException, BadLocationException, IOException, MisconfigurationException, PythonNatureWithoutProjectException {
        String importsTipperStr = request.codeCompletion.getImportsTipperStr((CompletionRequest)request).importsTipperStr;
        if (importsTipperStr.length() != 0 || request.isInCalltip) {
            request.showTemplates = false;
        }
        TokensOrProposalsList allProposals = request.codeCompletion.getCodeCompletionProposals(request);
        return allProposals;
    }

    private TokensOrProposalsList getTemplateProposals(ITextViewer viewer, int documentOffset, String activationToken, String qualifier) {
        ArrayList<ICompletionProposalHandle> propList = new ArrayList<ICompletionProposalHandle>();
        if (this.templatesCompletion != null) {
            this.templatesCompletion.addTemplateProposals(viewer, documentOffset, propList);
        }
        return new TokensOrProposalsList(propList);
    }

    public IContextInformation[] computeContextInformation(ITextViewer viewer, int documentOffset) {
        if (viewer.getDocument() != this.contextInformationValidator.doc) {
            return null;
        }
        if (this.contextInformationValidator.returnedFalseOnce && this.contextInformationValidator.isContextInformationValid(documentOffset)) {
            return new IContextInformation[]{this.contextInformationValidator.fInformation};
        }
        return null;
    }

    public char[] getCompletionProposalAutoActivationCharacters() {
        return PythonCompletionProcessor.getStaticCompletionProposalAutoActivationCharacters();
    }

    public static char[] getStaticCompletionProposalAutoActivationCharacters() {
        if (!listenerToClearAutoActivationAlreadySetup) {
            IPreferenceStore preferenceStore = PyDevUiPrefs.getPreferenceStore();
            preferenceStore.addPropertyChangeListener(new IPropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent event) {
                    activationChars = null;
                }
            });
            listenerToClearAutoActivationAlreadySetup = true;
        }
        if (activationChars == null) {
            if (!PyCodeCompletionPreferences.useAutocomplete()) {
                activationChars = new char[0];
            } else {
                char[] c = new char[]{};
                if (PyCodeCompletionPreferences.isToAutocompleteOnDot()) {
                    c = StringUtils.addChar((char[])c, (char)'.');
                }
                if (PyCodeCompletionPreferences.isToAutocompleteOnPar()) {
                    c = StringUtils.addChar((char[])c, (char)'(');
                }
                activationChars = c;
            }
        }
        return activationChars;
    }

    public char[] getContextInformationAutoActivationCharacters() {
        return null;
    }

    public String getErrorMessage() {
        String ret = this.error;
        this.error = null;
        return ret;
    }

    public IContextInformationValidator getContextInformationValidator() {
        return this.contextInformationValidator;
    }
}

