/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.editor.codecompletion;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.TextPresentation;
import org.eclipse.jface.text.contentassist.ContentAssistEvent;
import org.eclipse.jface.text.contentassist.ICompletionListener;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.contentassist.ICompletionProposalSorter;
import org.eclipse.jface.text.contentassist.IContentAssistProcessor;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.eclipse.jface.text.contentassist.IContextInformationPresenter;
import org.eclipse.jface.text.contentassist.IContextInformationValidator;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.python.pydev.ast.codecompletion.ProposalsComparator;
import org.python.pydev.ast.codecompletion.PyCodeCompletionPreferences;
import org.python.pydev.ast.simpleassist.ISimpleAssistParticipant;
import org.python.pydev.core.ExtensionHelper;
import org.python.pydev.core.IPySyntaxHighlightingAndCodeCompletionEditor;
import org.python.pydev.core.IPythonNature;
import org.python.pydev.core.docutils.PySelection;
import org.python.pydev.core.log.Log;
import org.python.pydev.editor.codecompletion.CompletionError;
import org.python.pydev.editor.codecompletion.PyContentAssistant;
import org.python.pydev.editor.codecompletion.PythonCompletionProcessor;
import org.python.pydev.plugin.PyDevUiPrefs;
import org.python.pydev.shared_core.code_completion.ICompletionProposalHandle;

public class SimpleAssistProcessor
implements IContentAssistProcessor {
    public static final char[] ALL_ASCII_CHARS = new char[]{'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', 'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', '_'};
    private static final int SHOW_SIMPLE = 1;
    private static final int SHOW_DEFAULT = 2;
    private int whatToShow = 1;
    private IPySyntaxHighlightingAndCodeCompletionEditor edit;
    private PythonCompletionProcessor defaultPythonProcessor;
    private PyContentAssistant assistant;
    private List<ISimpleAssistParticipant> participants;
    private boolean lastCompletionAutoActivated;
    private static volatile boolean useAutocompleteOnAllAsciiCharsCache;
    private static volatile char[] autoActivationCharsCache;
    private String lastError = null;
    private KeepProposalsComparatorSynched keepSynched;
    private final ProposalsComparator sorter = new ProposalsComparator("", null);
    private static volatile boolean listenerToClearAutoActivationAlreadySetup;

    static {
        listenerToClearAutoActivationAlreadySetup = false;
    }

    public void startCycle() {
        this.whatToShow = 1;
    }

    public void doCycle() {
        if (this.whatToShow == 1) {
            this.whatToShow = 2;
        }
    }

    public void updateStatus() {
        if (this.whatToShow == 1) {
            this.assistant.setIterationStatusMessage("Press %s for default completions.");
        }
    }

    public SimpleAssistProcessor(IPySyntaxHighlightingAndCodeCompletionEditor edit, PythonCompletionProcessor defaultPythonProcessor, final PyContentAssistant assistant) {
        this.edit = edit;
        this.defaultPythonProcessor = defaultPythonProcessor;
        this.assistant = assistant;
        this.assistant.setSorter(new ICompletionProposalSorter(){

            public int compare(ICompletionProposal p1, ICompletionProposal p2) {
                return SimpleAssistProcessor.this.sorter.compare((ICompletionProposalHandle)p1, (ICompletionProposalHandle)p2);
            }
        });
        this.participants = ExtensionHelper.getParticipants((String)"org.python.pydev.pydev_simpleassist");
        assistant.addCompletionListener(new ICompletionListener(){

            public void assistSessionEnded(ContentAssistEvent event) {
                if (SimpleAssistProcessor.this.keepSynched != null) {
                    SimpleAssistProcessor.this.keepSynched.dispose();
                    SimpleAssistProcessor.this.keepSynched = null;
                }
            }

            public void assistSessionStarted(ContentAssistEvent event) {
                SimpleAssistProcessor.this.startCycle();
                SimpleAssistProcessor.this.lastCompletionAutoActivated = assistant.getLastCompletionAutoActivated();
                if (!SimpleAssistProcessor.this.lastCompletionAutoActivated) {
                    SimpleAssistProcessor.this.doCycle();
                }
            }

            public void selectionChanged(ICompletionProposal proposal, boolean smartToggle) {
            }
        });
    }

    public ICompletionProposal[] computeCompletionProposals(ITextViewer viewer, int offset) {
        try {
            IDocument doc = viewer.getDocument();
            String[] strs = PySelection.getActivationTokenAndQualifier((IDocument)doc, (int)offset, (boolean)false);
            String activationToken = strs[0];
            String qualifier = strs[1];
            IPythonNature pythonNature = this.edit.getPythonNature();
            this.sorter.setQualifier(qualifier);
            this.sorter.setCompareContext(new ProposalsComparator.CompareContext(pythonNature));
            if (this.keepSynched != null) {
                this.keepSynched.dispose();
                this.keepSynched = null;
            }
            if (viewer.getTextWidget() != null) {
                this.keepSynched = new KeepProposalsComparatorSynched(viewer, doc, offset, this.sorter);
            }
            if (this.showDefault()) {
                ICompletionProposal[] ret = this.defaultPythonProcessor.computeCompletionProposals(viewer, offset);
                return ret;
            }
            this.updateStatus();
            PySelection ps = this.edit.createPySelection();
            if (ps == null) {
                ps = new PySelection(doc, offset);
            }
            ArrayList results = new ArrayList();
            for (ISimpleAssistParticipant participant : this.participants) {
                results.addAll(participant.computeCompletionProposals(activationToken, qualifier, ps, this.edit, offset));
            }
            this.doCycle();
            if (results.size() == 0) {
                if (!this.lastCompletionAutoActivated || this.defaultAutoActivated(viewer, offset) || useAutocompleteOnAllAsciiCharsCache) {
                    return this.defaultPythonProcessor.computeCompletionProposals(viewer, offset);
                }
                return new ICompletionProposal[0];
            }
            Collections.sort(results, this.sorter);
            return results.toArray(new ICompletionProposal[0]);
        }
        catch (Exception e) {
            Log.log((Throwable)e);
            CompletionError completionError = new CompletionError(e);
            this.lastError = completionError.getErrorMessage();
            return new ICompletionProposal[]{completionError};
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean defaultAutoActivated(ITextViewer viewer, int offset) {
        try {
            char docChar = viewer.getDocument().getChar(offset - 1);
            char[] cArray = this.defaultPythonProcessor.getCompletionProposalAutoActivationCharacters();
            int n = cArray.length;
            int n2 = 0;
            while (true) {
                if (n2 >= n) {
                    return false;
                }
                char c = cArray[n2];
                if (c == docChar) {
                    return true;
                }
                ++n2;
            }
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
        return false;
    }

    private boolean showDefault() {
        return this.whatToShow == 2;
    }

    public IContextInformation[] computeContextInformation(ITextViewer viewer, int offset) {
        if (this.showDefault()) {
            return this.defaultPythonProcessor.computeContextInformation(viewer, offset);
        }
        return null;
    }

    public char[] getCompletionProposalAutoActivationCharacters() {
        return SimpleAssistProcessor.getStaticAutoActivationCharacters();
    }

    public static synchronized char[] getStaticAutoActivationCharacters() {
        if (!listenerToClearAutoActivationAlreadySetup) {
            PyDevUiPrefs.getPreferenceStore().addPropertyChangeListener(new IPropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent event) {
                    autoActivationCharsCache = null;
                }
            });
            listenerToClearAutoActivationAlreadySetup = true;
        }
        if (autoActivationCharsCache == null) {
            char[] defaultAutoActivationCharacters = PythonCompletionProcessor.getStaticCompletionProposalAutoActivationCharacters();
            useAutocompleteOnAllAsciiCharsCache = PyCodeCompletionPreferences.useAutocompleteOnAllAsciiChars() && PyCodeCompletionPreferences.useAutocomplete();
            char[] c2 = new char[ALL_ASCII_CHARS.length + defaultAutoActivationCharacters.length];
            System.arraycopy(ALL_ASCII_CHARS, 0, c2, 0, ALL_ASCII_CHARS.length);
            System.arraycopy(defaultAutoActivationCharacters, 0, c2, ALL_ASCII_CHARS.length, defaultAutoActivationCharacters.length);
            autoActivationCharsCache = c2;
        }
        return autoActivationCharsCache;
    }

    public char[] getContextInformationAutoActivationCharacters() {
        return null;
    }

    public String getErrorMessage() {
        String ret = this.lastError;
        if (ret == null && this.showDefault()) {
            ret = this.defaultPythonProcessor.getErrorMessage();
        }
        this.lastError = null;
        return ret;
    }

    public IContextInformationValidator getContextInformationValidator() {
        IContextInformationValidator defaultContextInformationValidator = this.defaultPythonProcessor.getContextInformationValidator();
        return new ContextInformationDelegator(defaultContextInformationValidator);
    }

    private class ContextInformationDelegator
    implements IContextInformationValidator,
    IContextInformationPresenter {
        private final IContextInformationValidator defaultContextInformationValidator;

        private ContextInformationDelegator(IContextInformationValidator defaultContextInformationValidator) {
            Assert.isTrue((boolean)(defaultContextInformationValidator instanceof IContextInformationPresenter));
            this.defaultContextInformationValidator = defaultContextInformationValidator;
        }

        public void install(IContextInformation info, ITextViewer viewer, int offset) {
            this.defaultContextInformationValidator.install(info, viewer, offset);
        }

        public boolean isContextInformationValid(int offset) {
            if (SimpleAssistProcessor.this.showDefault()) {
                return this.defaultContextInformationValidator.isContextInformationValid(offset);
            }
            return true;
        }

        public boolean updatePresentation(int offset, TextPresentation presentation) {
            return ((IContextInformationPresenter)this.defaultContextInformationValidator).updatePresentation(offset, presentation);
        }
    }

    private static class KeepProposalsComparatorSynched
    implements Listener {
        private ITextViewer viewer;
        private ProposalsComparator sorter;

        public KeepProposalsComparatorSynched(ITextViewer viewer, IDocument doc, int offset, ProposalsComparator sorter) {
            this.viewer = viewer;
            this.sorter = sorter;
            viewer.getTextWidget().addListener(24, (Listener)this);
            viewer.getTextWidget().addListener(2, (Listener)this);
        }

        public void dispose() {
            if (this.viewer != null) {
                this.viewer.getTextWidget().removeListener(24, (Listener)this);
                this.viewer.getTextWidget().removeListener(2, (Listener)this);
                this.viewer = null;
                this.sorter = null;
            }
        }

        public void handleEvent(Event event) {
            this.updateQualifier();
        }

        private void updateQualifier() {
            IDocument doc = this.viewer.getDocument();
            String[] strs = PySelection.getActivationTokenAndQualifier((IDocument)doc, (int)this.viewer.getSelectedRange().x, (boolean)false);
            String qualifier = strs[1];
            this.sorter.setQualifier(qualifier);
        }
    }
}

