/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.editor.codecompletion.proposals;

import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.contentassist.BoldStylerProvider;
import org.eclipse.jface.text.contentassist.ICompletionProposalExtension7;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.eclipse.jface.viewers.StyledString;
import org.python.pydev.ast.codecompletion.PyCodeCompletionPreferences;
import org.python.pydev.ast.codecompletion.PyCodeCompletionUtils;
import org.python.pydev.core.docutils.PySelection;
import org.python.pydev.editor.codecompletion.proposals.AbstractCompletionProposalExtension;
import org.python.pydev.shared_core.code_completion.IPyCompletionProposal;
import org.python.pydev.shared_core.image.IImageHandle;
import org.python.pydev.shared_core.string.StringUtils;

public abstract class AbstractPyCompletionProposalExtension2
extends AbstractCompletionProposalExtension
implements ICompletionProposalExtension7 {
    protected static final char[] VAR_TRIGGER = new char[]{'.'};

    public AbstractPyCompletionProposalExtension2(String replacementString, int replacementOffset, int replacementLength, int cursorPosition, int priority, IPyCompletionProposal.ICompareContext compareContext) {
        super(replacementString, replacementOffset, replacementLength, cursorPosition, priority, compareContext);
    }

    public AbstractPyCompletionProposalExtension2(String replacementString, int replacementOffset, int replacementLength, int cursorPosition, IImageHandle image, String displayString, IContextInformation contextInformation, String additionalProposalInfo, int priority, int onApplyAction, String args, IPyCompletionProposal.ICompareContext compareContext) {
        super(replacementString, replacementOffset, replacementLength, cursorPosition, image, displayString, contextInformation, additionalProposalInfo, priority, onApplyAction, args, compareContext);
    }

    @Override
    protected boolean getApplyCompletionOnDot() {
        return PyCodeCompletionPreferences.applyCompletionOnDot();
    }

    public StyledString getStyledDisplayString(IDocument document, int offset, BoldStylerProvider boldStylerProvider) {
        String[] strs = PySelection.getActivationTokenAndQualifier((IDocument)document, (int)offset, (boolean)false);
        if (strs[1].length() == 0 && (strs[0].length() == 0 || strs[0].endsWith("."))) {
            StyledString styledString = new StyledString(this.getDisplayString());
            return styledString;
        }
        String qualifier = strs[1];
        boolean useSubstringMatchInCodeCompletion = PyCodeCompletionPreferences.getUseSubstringMatchInCodeCompletion();
        String original = this.getDisplayString();
        int index = original.indexOf(" - ");
        String strBeforeQualifier = index != -1 ? original.substring(0, index) : original;
        StyledString styledString = new StyledString();
        if (useSubstringMatchInCodeCompletion) {
            int i = strBeforeQualifier.toLowerCase().indexOf(qualifier.toLowerCase());
            if (i < 0) {
                styledString.append(strBeforeQualifier);
            } else {
                styledString.append(strBeforeQualifier.substring(0, i));
                styledString.append(strBeforeQualifier.substring(i, i + qualifier.length()), boldStylerProvider.getBoldStyler());
                styledString.append(strBeforeQualifier.substring(i + qualifier.length(), strBeforeQualifier.length()));
            }
        } else {
            styledString.append(strBeforeQualifier);
        }
        if (styledString.length() < original.length()) {
            styledString.append(original.substring(styledString.length()), StyledString.QUALIFIER_STYLER);
        }
        return styledString;
    }

    @Override
    public boolean validate(IDocument document, int offset, DocumentEvent event) {
        String[] strs = PySelection.getActivationTokenAndQualifier((IDocument)document, (int)offset, (boolean)false);
        if (strs[1].length() == 0 && (strs[0].length() == 0 || strs[0].endsWith("."))) {
            return false;
        }
        String qualifier = strs[1];
        boolean useSubstringMatchInCodeCompletion = PyCodeCompletionPreferences.getUseSubstringMatchInCodeCompletion();
        String displayString = this.getDisplayString();
        boolean ret = PyCodeCompletionUtils.acceptName((boolean)useSubstringMatchInCodeCompletion, (String)displayString, (String)qualifier);
        return ret;
    }

    public char[] getTriggerCharacters() {
        char[] chars = VAR_TRIGGER;
        if (PyCodeCompletionPreferences.applyCompletionOnLParen()) {
            chars = StringUtils.addChar((char[])chars, (char)'(');
        }
        if (PyCodeCompletionPreferences.applyCompletionOnRParen()) {
            chars = StringUtils.addChar((char[])chars, (char)')');
        }
        return chars;
    }
}

