/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.editor.codecompletion.proposals;

import com.python.pydev.analysis.refactoring.quick_fixes.AddTokenAndImportStatement;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.contentassist.ICompletionProposalExtension;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.text.edits.ReplaceEdit;
import org.python.pydev.ast.codecompletion.IPyCompletionProposal2;
import org.python.pydev.ast.codecompletion.PriorityLRU;
import org.python.pydev.ast.codecompletion.PyCodeCompletionPreferences;
import org.python.pydev.core.IPyEdit;
import org.python.pydev.core.IPySourceViewer;
import org.python.pydev.core.autoedit.DefaultIndentPrefs;
import org.python.pydev.core.imports.ImportPreferences;
import org.python.pydev.core.log.Log;
import org.python.pydev.editor.codecompletion.proposals.AbstractPyCompletionProposalExtension2;
import org.python.pydev.editor.codecompletion.proposals.AnalysisImages;
import org.python.pydev.plugin.PyDevUiPrefs;
import org.python.pydev.shared_core.SharedCorePlugin;
import org.python.pydev.shared_core.code_completion.ICompletionProposalHandle;
import org.python.pydev.shared_core.code_completion.IPyCompletionProposal;
import org.python.pydev.shared_core.image.IImageHandle;
import org.python.pydev.shared_ui.ImageCache;

public class CtxInsensitiveImportComplProposal
extends AbstractPyCompletionProposalExtension2
implements ICompletionProposalExtension,
IPyCompletionProposal2 {
    public static boolean addApplyTipOnAdditionalInfo = true;
    public String realImportRep;
    public String indentString;
    private int importLen = 0;
    private int newForcedOffset = -1;
    private boolean appliedWithTrigger = false;
    private boolean addLocalImport = false;
    public Boolean addLocalImportsOnTopOfFunc = null;
    private int infoTypeForImage;
    private static final String MSG = "Enter: apply completion.\n  + Ctrl: replace current word (no Pop-up focus).\n  + Shift: do local import (requires Pop-up focus).\n";

    public int getInfoTypeForImage() {
        return this.infoTypeForImage;
    }

    public boolean getAddLocalImportsOnTopOfMethod() {
        if (SharedCorePlugin.inTestMode()) {
            if (this.addLocalImportsOnTopOfFunc != null) {
                return this.addLocalImportsOnTopOfFunc;
            }
            return true;
        }
        return PyCodeCompletionPreferences.getPutLocalImportsOnTopOfMethod();
    }

    public CtxInsensitiveImportComplProposal(String replacementString, int replacementOffset, int replacementLength, int cursorPosition, int infoTypeForImage, String displayString, IContextInformation contextInformation, String additionalProposalInfo, int priority, String realImportRep, IPyCompletionProposal.ICompareContext compareContext) {
        super(replacementString, replacementOffset, replacementLength, cursorPosition, null, displayString, contextInformation, additionalProposalInfo, priority, 1, "", compareContext);
        this.infoTypeForImage = infoTypeForImage;
        this.realImportRep = realImportRep;
        Integer lruPriority = PriorityLRU.getPriority((String)realImportRep);
        if (lruPriority != null) {
            this.priority = lruPriority;
        }
    }

    @Override
    public Image getImage() {
        if (this.fImage == null) {
            this.fImage = AnalysisImages.getImageForAutoImportTypeInfo(this.infoTypeForImage);
        }
        return ImageCache.asImage((IImageHandle)this.fImage);
    }

    public void setAddLocalImport(boolean b) {
        this.addLocalImport = b;
    }

    public boolean getMakeLocalWhenShiftApplied() {
        return true;
    }

    @Override
    public String getAdditionalProposalInfo() {
        String original = super.getAdditionalProposalInfo();
        if (addApplyTipOnAdditionalInfo && this.getMakeLocalWhenShiftApplied()) {
            if (original == null || original.length() == 0) {
                return MSG;
            }
            return original + "\n\nEnter: apply completion.\n  + Ctrl: replace current word (no Pop-up focus).\n  + Shift: do local import (requires Pop-up focus).\n";
        }
        return original;
    }

    public void apply(ITextViewer viewer, char trigger, int stateMask, int offset) {
        IPyEdit projectAdaptable;
        IDocument document = viewer.getDocument();
        if (viewer instanceof IPySourceViewer) {
            IPySourceViewer pySourceViewer = (IPySourceViewer)viewer;
            IPyEdit pyEdit = pySourceViewer.getEdit();
            this.indentString = pyEdit.getIndentPrefs().getIndentationString();
            projectAdaptable = pyEdit;
        } else {
            this.indentString = new DefaultIndentPrefs(null).getIndentationString();
            projectAdaptable = null;
        }
        if ((stateMask & 0x20000) != 0) {
            this.setAddLocalImport(true);
        }
        this.apply(document, trigger, stateMask, offset, (IAdaptable)projectAdaptable);
    }

    public void apply(IDocument document, char trigger, int stateMask, int offset) {
        this.apply(document, trigger, stateMask, offset, null);
    }

    protected void apply(IDocument document, char trigger, int stateMask, int offset, IAdaptable projectAdaptable) {
        int maxCols;
        PriorityLRU.appliedCompletion((String)this.realImportRep);
        if (this.indentString == null) {
            throw new RuntimeException("Indent string not set (not called with a PyEdit as viewer?)");
        }
        if (!this.triggerCharAppliesCurrentCompletion(trigger, document, offset)) {
            this.newForcedOffset = offset + 1;
            return;
        }
        if (SharedCorePlugin.inTestMode()) {
            maxCols = 80;
        } else {
            IPreferenceStore chainedPrefStore = PyDevUiPrefs.getChainedPrefStore();
            maxCols = chainedPrefStore.getInt("printMarginColumn");
        }
        AddTokenAndImportStatement.ComputedInfo computedInfo = new AddTokenAndImportStatement.ComputedInfo(this.realImportRep, this.fReplacementOffset, this.fLen, this.indentString, this.fReplacementString, this.appliedWithTrigger, this.importLen, document);
        new AddTokenAndImportStatement(document, trigger, offset, this.addLocalImport, this.getAddLocalImportsOnTopOfMethod(), ImportPreferences.getGroupImports((IAdaptable)projectAdaptable), maxCols).createTextEdit(computedInfo);
        this.fReplacementString = computedInfo.fReplacementString;
        this.appliedWithTrigger = computedInfo.appliedWithTrigger;
        this.importLen = computedInfo.importLen;
        for (ReplaceEdit edit : computedInfo.replaceEdit) {
            try {
                edit.apply(document);
            }
            catch (Exception e) {
                Log.log((Throwable)e);
            }
        }
    }

    @Override
    public Point getSelection(IDocument document) {
        if (this.newForcedOffset >= 0) {
            return new Point(this.newForcedOffset, 0);
        }
        int pos = this.fReplacementOffset + this.fReplacementString.length() + this.importLen;
        if (this.appliedWithTrigger) {
            ++pos;
        }
        return new Point(pos, 0);
    }

    public final String getInternalDisplayStringRepresentation() {
        return this.fReplacementString;
    }

    @Override
    public int getOverrideBehavior(ICompletionProposalHandle curr) {
        if (curr instanceof CtxInsensitiveImportComplProposal) {
            if (curr.getDisplayString().equals(this.getDisplayString())) {
                return 2;
            }
            return 1;
        }
        return 2;
    }
}

