/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.editor.codecompletion.proposals;

import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.eclipse.swt.graphics.Point;
import org.python.pydev.core.docutils.PySelection;
import org.python.pydev.core.interactive_console.IScriptConsoleViewer;
import org.python.pydev.core.log.Log;
import org.python.pydev.editor.codecompletion.proposals.CtxInsensitiveImportComplProposal;
import org.python.pydev.shared_core.code_completion.IPyCompletionProposal;

public class PyConsoleCompletion
extends CtxInsensitiveImportComplProposal {
    private int commandLineOffset;
    private int deltaInLine;
    private int diff;

    public PyConsoleCompletion(String replacementString, int replacementOffset, int replacementLength, int cursorPosition, int infoTypeForImage, String displayString, IContextInformation contextInformation, String additionalProposalInfo, int priority, String realImportRep, IScriptConsoleViewer viewer, IPyCompletionProposal.ICompareContext compareContext) {
        super(replacementString, replacementOffset, replacementLength, cursorPosition, infoTypeForImage, displayString, contextInformation, additionalProposalInfo, priority, realImportRep, compareContext);
        this.commandLineOffset = viewer.getCommandLineOffset();
    }

    @Override
    public boolean getMakeLocalWhenShiftApplied() {
        return false;
    }

    @Override
    public void apply(IDocument document, char trigger, int stateMask, int offset, IAdaptable projectAdaptable) {
        if (!this.triggerCharAppliesCurrentCompletion(trigger, document, offset)) {
            return;
        }
        try {
            this.diff = offset - (this.fReplacementOffset + this.fReplacementLength);
            this.deltaInLine = document.getLength() - (this.fReplacementOffset + this.fReplacementLength);
            String currentLineContents = document.get(this.commandLineOffset, document.getLength() - this.commandLineOffset);
            StringBuffer buf = new StringBuffer(currentLineContents);
            int startReplace = currentLineContents.length() - this.deltaInLine - this.fReplacementLength;
            int endReplace = currentLineContents.length() - this.deltaInLine + this.diff;
            String newCurrentLineString = buf.replace(startReplace, endReplace, this.fReplacementString).toString();
            document.replace(this.commandLineOffset, document.getLength() - this.commandLineOffset, "");
            boolean addImport = this.realImportRep.length() > 0;
            String delimiter = PySelection.getDelimiter((IDocument)document);
            if (addImport) {
                document.replace(this.commandLineOffset, 0, this.realImportRep + delimiter + newCurrentLineString);
            } else {
                document.replace(document.getLength(), 0, newCurrentLineString);
            }
        }
        catch (BadLocationException x) {
            Log.log((Throwable)x);
        }
    }

    @Override
    public Point getSelection(IDocument document) {
        return new Point(document.getLength() - this.deltaInLine + this.diff, 0);
    }
}

