/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.editor.codecompletion.revisited.javaintegration;

import java.io.File;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jface.text.IDocument;
import org.python.pydev.core.ICompletionState;
import org.python.pydev.core.IInterpreterInfo;
import org.python.pydev.core.IInterpreterManager;
import org.python.pydev.core.IModule;
import org.python.pydev.core.IModuleRequestState;
import org.python.pydev.core.IModulesManager;
import org.python.pydev.core.IProjectModulesManager;
import org.python.pydev.core.IPythonNature;
import org.python.pydev.core.ISystemModulesManager;
import org.python.pydev.core.ModulesKey;
import org.python.pydev.editor.codecompletion.revisited.javaintegration.JavaModuleInProject;
import org.python.pydev.editor.codecompletion.revisited.javaintegration.ModulesKeyForJava;
import org.python.pydev.shared_core.callbacks.ICallback0;
import org.python.pydev.shared_core.string.FastStringBuffer;
import org.python.pydev.shared_core.string.FullRepIterable;
import org.python.pydev.shared_core.string.StringUtils;
import org.python.pydev.shared_core.structure.Tuple;

public class JavaProjectModulesManager
implements IModulesManager,
IProjectModulesManager {
    private static final String[] EMPTY_STRINTG_ARRAY = new String[0];
    private static final boolean DEBUG_GET_MODULE = false;
    private static final boolean DEBUG_GET_DIRECT_MODULES = false;
    private IJavaProject javaProject;

    public JavaProjectModulesManager(IJavaProject javaProject) {
        this.javaProject = javaProject;
    }

    public IModulesManager[] getManagersInvolved(boolean checkSystemManager) {
        return new IModulesManager[]{this};
    }

    public SortedMap<ModulesKey, ModulesKey> getAllDirectModulesStartingWith(final String moduleToGetTokensFrom) {
        final TreeMap<ModulesKey, ModulesKey> ret = new TreeMap<ModulesKey, ModulesKey>();
        this.filterJavaPackages(new IFilter(){

            @Override
            public boolean accept(String elementName, IPackageFragmentRoot packageRoot, IJavaElement javaElement) {
                if (elementName.startsWith(moduleToGetTokensFrom) && elementName.length() > 0) {
                    ModulesKeyForJava key = new ModulesKeyForJava(elementName, packageRoot, javaElement);
                    ret.put(key, key);
                    return true;
                }
                return elementName.length() == 0;
            }
        });
        return ret;
    }

    public Set<String> getAllModuleNames(boolean addDependencies, final String partStartingWithLowerCase) {
        if (addDependencies) {
            throw new RuntimeException("At this point, it should never be called with dependencies (because it's a java project already -- it manages that internally already)");
        }
        final HashSet<String> ret = new HashSet<String>();
        this.filterJavaPackages(new IFilter(){

            @Override
            public boolean accept(String elementName, IPackageFragmentRoot packageRoot, IJavaElement javaElement) {
                for (String mod : StringUtils.dotSplit((String)elementName)) {
                    if (!mod.toLowerCase().startsWith(partStartingWithLowerCase)) continue;
                    ret.add(elementName);
                }
                return true;
            }
        });
        return ret;
    }

    private void filterJavaPackages(IFilter filter) {
        try {
            IClasspathEntry[] rawClasspath = this.javaProject.getRawClasspath();
            FastStringBuffer buffer = new FastStringBuffer();
            IClasspathEntry[] iClasspathEntryArray = rawClasspath;
            int n = rawClasspath.length;
            int n2 = 0;
            while (n2 < n) {
                IClasspathEntry entry = iClasspathEntryArray[n2];
                int entryKind = entry.getEntryKind();
                IClasspathEntry resolvedClasspathEntry = JavaCore.getResolvedClasspathEntry((IClasspathEntry)entry);
                if (entryKind != 5) {
                    IPackageFragmentRoot[] roots;
                    IPackageFragmentRoot[] iPackageFragmentRootArray = roots = this.javaProject.findPackageFragmentRoots(resolvedClasspathEntry);
                    int n3 = roots.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        IJavaElement[] children;
                        IPackageFragmentRoot root = iPackageFragmentRootArray[n4];
                        IJavaElement[] iJavaElementArray = children = root.getChildren();
                        int n5 = children.length;
                        int n6 = 0;
                        while (n6 < n5) {
                            IJavaElement child = iJavaElementArray[n6];
                            IPackageFragment childPackage = (IPackageFragment)child;
                            String elementName = childPackage.getElementName();
                            if (filter.accept(elementName, root, (IJavaElement)childPackage)) {
                                buffer.clear();
                                buffer.append(elementName);
                                int packageNameLen = buffer.length();
                                if (packageNameLen > 0) {
                                    buffer.append('.');
                                    ++packageNameLen;
                                }
                                IJavaElement[] iJavaElementArray2 = childPackage.getChildren();
                                int n7 = iJavaElementArray2.length;
                                int n8 = 0;
                                while (n8 < n7) {
                                    IJavaElement class_ = iJavaElementArray2[n8];
                                    buffer.append(FullRepIterable.getFirstPart((String)class_.getElementName()));
                                    filter.accept(buffer.toString(), root, class_);
                                    buffer.setCount(packageNameLen);
                                    ++n8;
                                }
                            }
                            ++n6;
                        }
                        ++n4;
                    }
                }
                ++n2;
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public String[] getBuiltins() {
        return EMPTY_STRINTG_ARRAY;
    }

    public List<String> getCompletePythonPath(IInterpreterInfo interpreter, IInterpreterManager manager) {
        return new ArrayList<String>();
    }

    public IModule getModule(String name, IPythonNature nature, boolean dontSearchInit, IModuleRequestState moduleRequest) {
        return this.getModuleInDirectManager(name, nature, dontSearchInit, moduleRequest);
    }

    public IModule getModule(String name, IPythonNature nature, boolean checkSystemManager, boolean dontSearchInit, IModuleRequestState moduleRequest) {
        return this.getModuleInDirectManager(name, nature, dontSearchInit, moduleRequest);
    }

    public IPythonNature getNature() {
        return null;
    }

    public boolean hasModule(ModulesKey key) {
        return false;
    }

    public ModulesKey[] getOnlyDirectModules() {
        return new ModulesKey[0];
    }

    public Object getPythonPathHelper() {
        return null;
    }

    public void setPythonPathHelper(Object helper) {
    }

    public IModule getRelativeModule(String name, IPythonNature nature, IModuleRequestState moduleRequest) {
        return this.getModuleInDirectManager(name, nature, true, moduleRequest);
    }

    public int getSize(boolean addDependenciesSize) {
        return 0;
    }

    public ISystemModulesManager getSystemModulesManager() {
        return null;
    }

    public Tuple<IModule, IModulesManager> getModuleAndRelatedModulesManager(String name, IPythonNature nature, boolean checkSystemManager, boolean dontSearchInit, IModuleRequestState moduleRequest) {
        IModule module = this.getModule(name, nature, checkSystemManager, dontSearchInit, moduleRequest);
        if (module != null) {
            return new Tuple((Object)module, (Object)this);
        }
        return null;
    }

    public IModule getModuleInDirectManager(String name, IPythonNature nature, boolean dontSearchInit, IModuleRequestState moduleRequest) {
        block5: {
            block6: {
                if (name.startsWith(".")) {
                    return null;
                }
                try {
                    IPackageFragmentRoot packageFragmentRoot;
                    IClasspathEntry rawClasspathEntry;
                    IType javaElement = this.javaProject.findType(name);
                    if (javaElement == null) {
                        javaElement = this.javaProject.findElement((IPath)new Path(name.replace('.', '/')));
                    }
                    if (javaElement == null) break block5;
                    IJavaElement ancestor = javaElement.getAncestor(3);
                    if (!(ancestor instanceof IPackageFragmentRoot) || (rawClasspathEntry = (packageFragmentRoot = (IPackageFragmentRoot)ancestor).getRawClasspathEntry()).getEntryKind() != 5) break block6;
                    return null;
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
            return new JavaModuleInProject(name, this.javaProject);
        }
        return null;
    }

    public String resolveModuleInDirectManager(IFile file) {
        return null;
    }

    public String resolveModuleInDirectManager(String full) {
        return null;
    }

    public boolean isInPythonPath(IResource member, IProject container) {
        throw new RuntimeException("Not implemented");
    }

    public String resolveModule(IResource member, IProject container) {
        throw new RuntimeException("Not implemented");
    }

    public String resolveModule(String full) {
        throw new RuntimeException("Not implemented");
    }

    public String resolveModule(String full, boolean checkSystemManager) {
        throw new RuntimeException("Not implemented");
    }

    public void setPythonNature(IPythonNature nature) {
        throw new RuntimeException("Not implemented");
    }

    public boolean startCompletionCache() {
        throw new RuntimeException("Not implemented");
    }

    public void endCompletionCache() {
        throw new RuntimeException("Not implemented");
    }

    public void endProcessing() {
        throw new RuntimeException("Not implemented");
    }

    public SortedMap<ModulesKey, ModulesKey> getAllModulesStartingWith(String moduleToGetTokensFrom) {
        throw new RuntimeException("Not implemented");
    }

    public IModule addModule(ModulesKey key) {
        throw new RuntimeException("Not implemented");
    }

    public void changePythonPath(String pythonpath, IProject project, IProgressMonitor monitor) {
        throw new RuntimeException("Not implemented");
    }

    public void removeModules(Collection<ModulesKey> toRem) {
        throw new RuntimeException("Not implemented");
    }

    public void processDelete(ModulesKey key) {
        throw new RuntimeException("Not implemented");
    }

    public void processInsert(ModulesKey key) {
        throw new RuntimeException("Not implemented");
    }

    public void processUpdate(ModulesKey data) {
        throw new RuntimeException("Not implemented");
    }

    public void rebuildModule(File f, ICallback0<IDocument> doc, IProject project, IProgressMonitor monitor, IPythonNature nature) {
        throw new RuntimeException("Not implemented");
    }

    public void removeModule(File file, IProject project, IProgressMonitor monitor) {
        throw new RuntimeException("Not implemented");
    }

    public void setProject(IProject project, IPythonNature nature, boolean restoreDeltas) {
        throw new RuntimeException("Not implemented");
    }

    public int pushTemporaryModule(String moduleName, IModule module) {
        throw new RuntimeException("Not implemented");
    }

    public void popTemporaryModule(String moduleName, int handle) {
        throw new RuntimeException("Not implemented");
    }

    public void saveToFile(File workspaceMetadataFile) {
        throw new RuntimeException("Not implemented");
    }

    public AutoCloseable withNoGenerateDeltas() {
        throw new RuntimeException("not implemented");
    }

    public Object getCompiledModuleCreationLock(String name) {
        throw new RuntimeException("not implemented");
    }

    public Tuple<List<ModulesKey>, List<ModulesKey>> diffModules(AbstractMap<ModulesKey, ModulesKey> keysFound) {
        throw new RuntimeException("not implemented");
    }

    public IModule getPyiStubModule(IModule module, ICompletionState completionState) {
        return null;
    }

    public static interface IFilter {
        public boolean accept(String var1, IPackageFragmentRoot var2, IJavaElement var3);
    }
}

