/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.editor.codefolding;

import org.eclipse.core.resources.IMarker;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.text.Position;
import org.eclipse.ui.texteditor.SimpleMarkerAnnotation;
import org.python.pydev.core.IMarkerInfoForAnalysis;
import org.python.pydev.core.log.Log;

public class MarkerAnnotationAndPosition {
    public final SimpleMarkerAnnotation markerAnnotation;
    public final Position position;

    public IMarkerInfoForAnalysis asMarkerInfoForAnalysis() {
        return new IMarkerInfoForAnalysis(){

            public Object getPyLintMessageIdAttribute() {
                return this.getAttribute("pylint_message_id");
            }

            private Object getAttribute(String attr) {
                Object attribute;
                IMarker marker = MarkerAnnotationAndPosition.this.markerAnnotation.getMarker();
                try {
                    attribute = marker.getAttribute(attr);
                }
                catch (Exception e) {
                    Log.log((Throwable)e);
                    return null;
                }
                return attribute;
            }

            public Integer getPyDevAnalisysType() {
                Integer id;
                IMarker marker = MarkerAnnotationAndPosition.this.markerAnnotation.getMarker();
                try {
                    id = (Integer)marker.getAttribute("PYDEV_TYPE");
                }
                catch (Exception e) {
                    Log.log((Throwable)e);
                    return null;
                }
                return id;
            }

            public Object getFlake8MessageId() {
                return this.getAttribute("flake8_message_id");
            }

            public Object getMessage() {
                return this.getAttribute("message");
            }

            public boolean hasPosition() {
                return MarkerAnnotationAndPosition.this.position != null;
            }

            public int getOffset() {
                return MarkerAnnotationAndPosition.this.position.offset;
            }

            public int getLength() {
                return MarkerAnnotationAndPosition.this.position.length;
            }

            public void delete() {
                IMarker marker = MarkerAnnotationAndPosition.this.markerAnnotation.getMarker();
                if (marker != null) {
                    try {
                        marker.delete();
                    }
                    catch (CoreException e) {
                        Log.log((Throwable)e);
                    }
                }
            }
        };
    }

    public MarkerAnnotationAndPosition(SimpleMarkerAnnotation markerAnnotation, Position position) {
        this.markerAnnotation = markerAnnotation;
        this.position = position;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.markerAnnotation == null ? 0 : this.markerAnnotation.getText().hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof MarkerAnnotationAndPosition)) {
            return false;
        }
        MarkerAnnotationAndPosition other = (MarkerAnnotationAndPosition)obj;
        if (this.markerAnnotation == null) {
            return other.markerAnnotation == null;
        }
        if (other.markerAnnotation == null) {
            return false;
        }
        String text = this.markerAnnotation.getText();
        String otherText = other.markerAnnotation.getText();
        if (text == null ? otherText != null : !text.equals(otherText)) {
            return false;
        }
        return this.markerAnnotation.getType().equals(other.markerAnnotation.getType());
    }
}

