/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.editor.codefolding;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.python.pydev.plugin.PydevPlugin;
import org.python.pydev.plugin.preferences.OverlayPreferenceStore;

public class PyDevCodeFoldingPrefPage
extends PreferencePage
implements IWorkbenchPreferencePage {
    public static final String USE_CODE_FOLDING = "USE_CODE_FOLDING";
    public static final boolean DEFAULT_USE_CODE_FOLDING = true;
    public static final boolean DEFAULT_FOLD_IF = false;
    public static final String FOLD_IF = "FOLD_IF";
    public static final boolean DEFAULT_FOLD_WHILE = false;
    public static final String FOLD_WHILE = "FOLD_WHILE";
    public static final boolean DEFAULT_FOLD_IMPORTS = true;
    public static final String FOLD_IMPORTS = "FOLD_IMPORTS";
    public static final boolean DEFAULT_FOLD_COMMENTS = true;
    public static final String FOLD_COMMENTS = "FOLD_COMMENTS";
    public static final boolean DEFAULT_FOLD_STRINGS = true;
    public static final String FOLD_STRINGS = "FOLD_STRINGS";
    public static final boolean DEFAULT_FOLD_CLASSDEF = true;
    public static final String FOLD_CLASSDEF = "FOLD_CLASSDEF";
    public static final boolean DEFAULT_FOLD_FUNCTIONDEF = true;
    public static final String FOLD_FUNCTIONDEF = "FOLD_FUNCTIONDEF";
    public static final boolean DEFAULT_FOLD_FOR = false;
    public static final String FOLD_FOR = "FOLD_FOR";
    public static final boolean DEFAULT_FOLD_TRY = false;
    public static final String FOLD_TRY = "FOLD_TRY";
    public static final boolean DEFAULT_FOLD_WITH = false;
    public static final String FOLD_WITH = "FOLD_WITH";
    public static final String INITIALLY_FOLD_COMMENTS = "INITIALLY_COLLAPSE_COMMENTS";
    public static final boolean DEFAULT_INITIALLY_FOLD_COMMENTS = false;
    public static final String INITIALLY_FOLD_IF = "INITIALLY_FOLD_IF";
    public static final boolean DEFAULT_INITIALLY_FOLD_IF = false;
    public static final String INITIALLY_FOLD_WHILE = "INITIALLY_FOLD_WHILE";
    public static final boolean DEFAULT_INITIALLY_FOLD_WHILE = false;
    public static final String INITIALLY_FOLD_CLASSDEF = "INITIALLY_FOLD_CLASSDEF";
    public static final boolean DEFAULT_INITIALLY_FOLD_CLASSDEF = false;
    public static final String INITIALLY_FOLD_FUNCTIONDEF = "INITIALLY_FOLD_FUNCTIONDEF";
    public static final boolean DEFAULT_INITIALLY_FOLD_FUNCTIONDEF = false;
    public static final String INITIALLY_FOLD_STRINGS = "INITIALLY_FOLD_STRINGS";
    public static final boolean DEFAULT_INITIALLY_FOLD_STRINGS = false;
    public static final String INITIALLY_FOLD_WITH = "INITIALLY_FOLD_WITH";
    public static final boolean DEFAULT_INITIALLY_FOLD_WITH = false;
    public static final String INITIALLY_FOLD_TRY = "INITIALLY_FOLD_TRY";
    public static final boolean DEFAULT_INITIALLY_FOLD_TRY = false;
    public static final String INITIALLY_FOLD_IMPORTS = "INITIALLY_FOLD_IMPORTS";
    public static final boolean DEFAULT_INITIALLY_FOLD_IMPORTS = false;
    public static final String INITIALLY_FOLD_FOR = "INITIALLY_FOLD_FOR";
    public static final boolean DEFAULT_INITIALLY_FOLD_FOR = false;
    public static final String FOLD_REGION = "FOLD_REGION";
    public static final boolean DEFAULT_FOLD_REGION = false;
    public static final String INITIALLY_FOLD_REGION = "INITIALLY_FOLD_REGION";
    public static final boolean DEFAULT_INITIALLY_FOLD_REGION = false;
    protected OverlayPreferenceStore fOverlayStore;
    protected Map<Button, String> fCheckBoxes = new HashMap<Button, String>();
    protected SelectionListener fCheckBoxListener = new SelectionListener(){

        public void widgetDefaultSelected(SelectionEvent e) {
        }

        public void widgetSelected(SelectionEvent e) {
            Button button = (Button)e.widget;
            PyDevCodeFoldingPrefPage.this.fOverlayStore.setValue(PyDevCodeFoldingPrefPage.this.fCheckBoxes.get(button), button.getSelection());
        }
    };
    protected List<SelectionListener> fMasterSlaveListeners = new ArrayList<SelectionListener>();

    public PyDevCodeFoldingPrefPage() {
        this.setPreferenceStore(PydevPlugin.getDefault().getPreferenceStore());
        this.setDescription("PyDev Code Folding Options");
        this.fOverlayStore = this.createOverlayStore();
    }

    public void init(IWorkbench workbench) {
    }

    protected Control createContents(Composite parent) {
        this.fOverlayStore.load();
        this.fOverlayStore.start();
        Control control = this.createPreferencePage(parent);
        this.initializeFields();
        return control;
    }

    protected Control createPreferencePage(Composite parent) {
        Composite top = new Composite(parent, 16384);
        top.setLayoutData((Object)new GridData(768));
        top.setLayout((Layout)new GridLayout());
        Button master = this.addCheckBox(top, "Use Code Folding?  -  Will apply to new editors", USE_CODE_FOLDING, 0);
        Label listLabel = new Label(top, 0);
        listLabel.setText("\nSelect the elements you would like PyDev \nto fold on.\n\nWill be applied when the document is saved");
        Button slaveFoldImports = this.addCheckBox(top, "Fold Imports?", FOLD_IMPORTS, 0);
        Button slaveInitialCollapseFoldImports = this.addCheckBox(top, "Initially Fold Imports?", INITIALLY_FOLD_IMPORTS, 0);
        this.createDependency(new Button[]{master, slaveFoldImports}, (Control)slaveInitialCollapseFoldImports, USE_CODE_FOLDING, FOLD_IMPORTS);
        Button slaveFoldClassdef = this.addCheckBox(top, "Fold Class Definitions?", FOLD_CLASSDEF, 0);
        Button slaveInitialCollapseFoldClassdef = this.addCheckBox(top, "Initially Fold Class Definitions?", INITIALLY_FOLD_CLASSDEF, 0);
        this.createDependency(new Button[]{master, slaveFoldClassdef}, (Control)slaveInitialCollapseFoldClassdef, USE_CODE_FOLDING, FOLD_CLASSDEF);
        Button slaveFoldFunctiondef = this.addCheckBox(top, "Fold Function Definitions?", FOLD_FUNCTIONDEF, 0);
        Button slaveInitialCollapseFoldFunctiondef = this.addCheckBox(top, "Initially Fold Function Definitions?", INITIALLY_FOLD_FUNCTIONDEF, 0);
        this.createDependency(new Button[]{master, slaveFoldFunctiondef}, (Control)slaveInitialCollapseFoldFunctiondef, USE_CODE_FOLDING, FOLD_FUNCTIONDEF);
        Button slaveFoldComments = this.addCheckBox(top, "Fold Comments?", FOLD_COMMENTS, 0);
        Button slaveInitialCollapseFoldComments = this.addCheckBox(top, "Initially Fold Comments?", INITIALLY_FOLD_COMMENTS, 0);
        this.createDependency(new Button[]{master, slaveFoldComments}, (Control)slaveInitialCollapseFoldComments, USE_CODE_FOLDING, FOLD_COMMENTS);
        Button slaveFoldStrings = this.addCheckBox(top, "Fold Strings?", FOLD_STRINGS, 0);
        Button slaveInitialCollapseFoldStrings = this.addCheckBox(top, "Initially Fold Strings?", INITIALLY_FOLD_STRINGS, 0);
        this.createDependency(new Button[]{master, slaveFoldStrings}, (Control)slaveInitialCollapseFoldStrings, USE_CODE_FOLDING, FOLD_STRINGS);
        Button slaveFoldIf = this.addCheckBox(top, "Fold If statements?", FOLD_IF, 0);
        Button slaveInitialCollapseFoldIf = this.addCheckBox(top, "Initially Fold If statements?", INITIALLY_FOLD_IF, 0);
        this.createDependency(new Button[]{master, slaveFoldIf}, (Control)slaveInitialCollapseFoldIf, USE_CODE_FOLDING, FOLD_IF);
        Button slaveFoldWhile = this.addCheckBox(top, "Fold While statements?", FOLD_WHILE, 0);
        Button slaveInitialCollapseFoldWhile = this.addCheckBox(top, "Initially Fold While statements?", INITIALLY_FOLD_WHILE, 0);
        this.createDependency(new Button[]{master, slaveFoldWhile}, (Control)slaveInitialCollapseFoldWhile, USE_CODE_FOLDING, FOLD_WHILE);
        Button slaveFoldWith = this.addCheckBox(top, "Fold With statements?", FOLD_WITH, 0);
        Button slaveInitialCollapseFoldWith = this.addCheckBox(top, "Initially Fold With statements?", INITIALLY_FOLD_WITH, 0);
        this.createDependency(new Button[]{master, slaveFoldWith}, (Control)slaveInitialCollapseFoldWith, USE_CODE_FOLDING, FOLD_WITH);
        Button slaveFoldTry = this.addCheckBox(top, "Fold Try statements?", FOLD_TRY, 0);
        Button slaveInitialCollapseFoldTry = this.addCheckBox(top, "Initially Fold Try statements?", INITIALLY_FOLD_TRY, 0);
        this.createDependency(new Button[]{master, slaveFoldTry}, (Control)slaveInitialCollapseFoldTry, USE_CODE_FOLDING, FOLD_TRY);
        Button slaveFoldFor = this.addCheckBox(top, "Fold For statements?", FOLD_FOR, 0);
        Button slaveInitialCollapseFoldFor = this.addCheckBox(top, "Initially Fold For statements?", INITIALLY_FOLD_FOR, 0);
        this.createDependency(new Button[]{master, slaveFoldFor}, (Control)slaveInitialCollapseFoldFor, USE_CODE_FOLDING, FOLD_FOR);
        Button slaveFoldRegion = this.addCheckBox(top, "Fold #region/#endregion?", FOLD_REGION, 0);
        Button slaveInitialCollapseFoldRegion = this.addCheckBox(top, "Initially Fold For #region/#endregion?", INITIALLY_FOLD_REGION, 0);
        this.createDependency(new Button[]{master, slaveFoldRegion}, (Control)slaveInitialCollapseFoldRegion, USE_CODE_FOLDING, FOLD_REGION);
        return top;
    }

    public boolean performOk() {
        this.fOverlayStore.propagate();
        PydevPlugin.getDefault().savePluginPreferences();
        return true;
    }

    protected void performDefaults() {
        this.fOverlayStore.loadDefaults();
        this.initializeFields();
        super.performDefaults();
    }

    protected void initializeFields() {
        for (Button b : this.fCheckBoxes.keySet()) {
            String key = this.fCheckBoxes.get(b);
            b.setSelection(this.fOverlayStore.getBoolean(key));
        }
        for (SelectionListener listener : this.fMasterSlaveListeners) {
            listener.widgetSelected(null);
        }
    }

    protected Button addCheckBox(Composite parent, String label, String key, int indentation) {
        Button checkBox = new Button(parent, 32);
        checkBox.setText(label);
        GridData gd = new GridData(32);
        gd.horizontalIndent = indentation;
        gd.horizontalSpan = 2;
        checkBox.setLayoutData((Object)gd);
        checkBox.addSelectionListener(this.fCheckBoxListener);
        this.fCheckBoxes.put(checkBox, key);
        return checkBox;
    }

    protected void createDependency(final Button[] masterControls, final Control slave, String ... masterKeys) {
        PyDevCodeFoldingPrefPage.indent(slave, 20 * masterKeys.length);
        boolean masterState = true;
        String[] stringArray = masterKeys;
        int n = masterKeys.length;
        int n2 = 0;
        while (n2 < n) {
            String string = stringArray[n2];
            masterState &= this.fOverlayStore.getBoolean(string);
            ++n2;
        }
        slave.setEnabled(masterState);
        SelectionListener listener = new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                boolean enabled = true;
                Button[] buttonArray = masterControls;
                int n = masterControls.length;
                int n2 = 0;
                while (n2 < n) {
                    Button master = buttonArray[n2];
                    enabled &= master.getSelection();
                    ++n2;
                }
                slave.setEnabled(enabled);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        };
        Button[] buttonArray = masterControls;
        int n3 = masterControls.length;
        n = 0;
        while (n < n3) {
            Button master = buttonArray[n];
            master.addSelectionListener(listener);
            ++n;
        }
        this.fMasterSlaveListeners.add(listener);
    }

    protected static void indent(Control control, int horizontalIndent) {
        GridData gridData = new GridData();
        gridData.horizontalIndent = horizontalIndent;
        control.setLayoutData((Object)gridData);
    }

    protected OverlayPreferenceStore createOverlayStore() {
        ArrayList<OverlayPreferenceStore.OverlayKey> overlayKeys = new ArrayList<OverlayPreferenceStore.OverlayKey>();
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, USE_CODE_FOLDING));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, FOLD_IMPORTS));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, INITIALLY_FOLD_IMPORTS));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, FOLD_CLASSDEF));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, INITIALLY_FOLD_CLASSDEF));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, FOLD_FUNCTIONDEF));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, INITIALLY_FOLD_FUNCTIONDEF));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, FOLD_COMMENTS));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, INITIALLY_FOLD_COMMENTS));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, FOLD_STRINGS));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, INITIALLY_FOLD_STRINGS));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, FOLD_IF));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, INITIALLY_FOLD_IF));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, FOLD_WHILE));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, INITIALLY_FOLD_WHILE));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, FOLD_WITH));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, INITIALLY_FOLD_WITH));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, FOLD_TRY));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, INITIALLY_FOLD_TRY));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, FOLD_FOR));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, INITIALLY_FOLD_FOR));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, FOLD_REGION));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, INITIALLY_FOLD_REGION));
        OverlayPreferenceStore.OverlayKey[] keys = new OverlayPreferenceStore.OverlayKey[overlayKeys.size()];
        overlayKeys.toArray(keys);
        return new OverlayPreferenceStore(this.getPreferenceStore(), keys);
    }
}

