/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.editor.codefolding;

import org.eclipse.jface.text.DefaultInformationControl;
import org.eclipse.jface.text.IInformationControl;
import org.eclipse.jface.text.IInformationControlCreator;
import org.eclipse.jface.text.source.ICharacterPairMatcher;
import org.eclipse.jface.text.source.IOverviewRuler;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.IVerticalRuler;
import org.eclipse.jface.text.source.projection.ProjectionSupport;
import org.eclipse.jface.text.source.projection.ProjectionViewer;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.texteditor.IEditorStatusLine;
import org.eclipse.ui.texteditor.SourceViewerDecorationSupport;
import org.python.pydev.core.log.Log;
import org.python.pydev.core.preferences.PydevPrefs;
import org.python.pydev.editor.codefolding.PySourceViewer;
import org.python.pydev.editor.codefolding.PythonPairCharacterMatcher;
import org.python.pydev.shared_core.parsing.IParserObserver;
import org.python.pydev.shared_ui.editor.BaseEditor;

public abstract class PyEditProjection
extends BaseEditor
implements IParserObserver {
    private ProjectionSupport fProjectionSupport;
    public static final int PROP_FOLDING_CHANGED = -999;
    protected static final char[] BRACKETS = new char[]{'{', '}', '(', ')', '[', ']'};
    protected PythonPairCharacterMatcher fBracketMatcher = new PythonPairCharacterMatcher(BRACKETS);

    protected ISourceViewer createSourceViewer(Composite parent, IVerticalRuler ruler, int styles) {
        IOverviewRuler overviewRuler = this.getOverviewRuler();
        PySourceViewer viewer = new PySourceViewer(parent, ruler, overviewRuler, this.isOverviewRulerVisible(), styles, this);
        this.getSourceViewerDecorationSupport((ISourceViewer)viewer);
        return viewer;
    }

    public PySourceViewer getPySourceViewer() {
        return (PySourceViewer)this.getSourceViewer();
    }

    protected void configureSourceViewerDecorationSupport(SourceViewerDecorationSupport support) {
        super.configureSourceViewerDecorationSupport(support);
        support.setCharacterPairMatcher((ICharacterPairMatcher)this.fBracketMatcher);
        support.setMatchingCharacterPainterPreferenceKeys("USE_MATCHING_BRACKETS", "EDITOR_MATCHING_BRACKETS_COLOR");
    }

    public void createPartControl(Composite parent) {
        super.createPartControl(parent);
        try {
            ProjectionViewer projectionViewer = (ProjectionViewer)this.getSourceViewer();
            this.fProjectionSupport = new ProjectionSupport(projectionViewer, this.getAnnotationAccess(), this.getSharedColors());
            this.fProjectionSupport.addSummarizableAnnotationType("org.eclipse.ui.workbench.texteditor.error");
            this.fProjectionSupport.addSummarizableAnnotationType("org.eclipse.ui.workbench.texteditor.warning");
            this.fProjectionSupport.setHoverControlCreator(new IInformationControlCreator(){

                public IInformationControl createInformationControl(Shell shell) {
                    return new DefaultInformationControl(shell);
                }
            });
            this.fProjectionSupport.install();
            if (PyEditProjection.isFoldingEnabled()) {
                projectionViewer.doOperation(19);
            }
        }
        catch (Exception e) {
            Log.log((Throwable)e);
        }
    }

    public static boolean isFoldingEnabled() {
        return PydevPrefs.getEclipsePreferences().getBoolean("USE_CODE_FOLDING", true);
    }

    public Object getAdapter(Class required) {
        Object adapter;
        if (this.fProjectionSupport != null && (adapter = this.fProjectionSupport.getAdapter(this.getSourceViewer(), required)) != null) {
            return adapter;
        }
        return super.getAdapter(required);
    }

    public void setStatusLineErrorMessage(String msg) {
        IEditorStatusLine statusLine = (IEditorStatusLine)this.getAdapter(IEditorStatusLine.class);
        if (statusLine != null) {
            statusLine.setMessage(true, msg, null);
        }
    }
}

