/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.editor.correctionassist;

import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.contentassist.ICompletionProposalExtension2;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.eclipse.jface.text.link.LinkedModeModel;
import org.eclipse.jface.text.link.LinkedModeUI;
import org.eclipse.jface.text.link.LinkedPosition;
import org.eclipse.jface.text.link.LinkedPositionGroup;
import org.eclipse.jface.text.link.ProposalPosition;
import org.eclipse.swt.graphics.Point;
import org.eclipse.ui.texteditor.link.EditorLinkedModeUI;
import org.python.pydev.core.interactive_console.IScriptConsoleViewer;
import org.python.pydev.core.log.Log;
import org.python.pydev.editor.codecompletion.proposals.PyCompletionProposal;
import org.python.pydev.shared_core.SharedCorePlugin;
import org.python.pydev.shared_core.image.IImageHandle;
import org.python.pydev.shared_core.string.FastStringBuffer;
import org.python.pydev.shared_ui.utils.RunInUiThread;

public class AssistAssignCompletionProposal
extends PyCompletionProposal
implements ICompletionProposalExtension2 {
    public AssistAssignCompletionProposal(String replacementString, int replacementOffset, int replacementLength, int cursorPosition, IImageHandle image, String displayString, IContextInformation contextInformation, String additionalProposalInfo, int priority) {
        super(AssistAssignCompletionProposal.fixReplacementString(replacementString), replacementOffset, replacementLength, cursorPosition, image, displayString, contextInformation, additionalProposalInfo, priority, null);
    }

    private static String fixReplacementString(String replacementString) {
        return new FastStringBuffer(replacementString, 0).replaceFirst("${", "").replaceFirst("}", "").toString();
    }

    public void apply(ITextViewer viewer, char trigger, int stateMask, int offset) {
        if (SharedCorePlugin.inTestMode()) {
            return;
        }
        try {
            int lineDelimiterLen;
            IDocument document = viewer.getDocument();
            int lineOfOffset = document.getLineOfOffset(this.fReplacementOffset);
            this.apply(document);
            int lineOffset = document.getLineOffset(lineOfOffset);
            int lineLength = document.getLineLength(lineOfOffset);
            String lineDelimiter = document.getLineDelimiter(lineOfOffset);
            int n = lineDelimiterLen = lineDelimiter != null ? lineDelimiter.length() : 0;
            if (!(viewer instanceof IScriptConsoleViewer)) {
                LinkedModeModel model = new LinkedModeModel();
                LinkedPositionGroup group = new LinkedPositionGroup();
                ProposalPosition proposalPosition = new ProposalPosition(document, this.fReplacementOffset, this.fReplacementString.length() - 3, 0, new ICompletionProposal[0]);
                group.addPosition((LinkedPosition)proposalPosition);
                model.addGroup(group);
                model.forceInstall();
                EditorLinkedModeUI ui = new EditorLinkedModeUI(model, viewer);
                ui.setExitPosition(viewer, lineOffset + lineLength - lineDelimiterLen, 0, Integer.MAX_VALUE);
                Runnable r = new Runnable((LinkedModeUI)ui){
                    private final /* synthetic */ LinkedModeUI val$ui;
                    {
                        this.val$ui = linkedModeUI;
                    }

                    @Override
                    public void run() {
                        this.val$ui.enter();
                    }
                };
                RunInUiThread.async((Runnable)r);
            }
        }
        catch (BadLocationException e) {
            Log.log((Throwable)e);
        }
    }

    @Override
    public void apply(IDocument document) {
        try {
            document.replace(this.fReplacementOffset, this.fReplacementLength, this.fReplacementString);
        }
        catch (Throwable x) {
            Log.log((Throwable)x);
        }
    }

    @Override
    public Point getSelection(IDocument document) {
        return new Point(this.fReplacementOffset, this.fReplacementString.length() - 3);
    }

    public void selected(ITextViewer viewer, boolean smartToggle) {
    }

    public void unselected(ITextViewer viewer) {
    }

    public boolean validate(IDocument document, int offset, DocumentEvent event) {
        return false;
    }
}

