/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.editor.correctionassist;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.quickassist.IQuickAssistInvocationContext;
import org.eclipse.jface.text.quickassist.IQuickAssistProcessor;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.ui.internal.texteditor.spelling.NoCompletionsProposal;
import org.eclipse.ui.texteditor.spelling.SpellingAnnotation;
import org.eclipse.ui.texteditor.spelling.SpellingCorrectionProcessor;
import org.eclipse.ui.texteditor.spelling.SpellingProblem;
import org.python.pydev.ast.assist_assign.AssistAssign;
import org.python.pydev.ast.codecompletion.ProposalsComparator;
import org.python.pydev.ast.surround_with.AssistSurroundWith;
import org.python.pydev.core.ExtensionHelper;
import org.python.pydev.core.IAssistProps;
import org.python.pydev.core.IPyEdit;
import org.python.pydev.core.IPySyntaxHighlightingAndCodeCompletionEditor;
import org.python.pydev.core.IPythonNature;
import org.python.pydev.core.MisconfigurationException;
import org.python.pydev.core.assist_fstring.AssistFString;
import org.python.pydev.core.docstrings.AssistDocString;
import org.python.pydev.core.docutils.PySelection;
import org.python.pydev.core.log.Log;
import org.python.pydev.editor.PyEdit;
import org.python.pydev.editor.correctionassist.heuristics.AssistImport;
import org.python.pydev.editor.correctionassist.heuristics.AssistImportToLocal;
import org.python.pydev.editor.correctionassist.heuristics.AssistPercentToFormat;
import org.python.pydev.shared_core.code_completion.IPyCompletionProposal;
import org.python.pydev.shared_core.image.IImageCache;
import org.python.pydev.shared_core.string.TextSelectionUtils;
import org.python.pydev.shared_ui.SharedUiPlugin;

public class PythonCorrectionProcessor
implements IQuickAssistProcessor {
    private IPySyntaxHighlightingAndCodeCompletionEditor edit;
    private static Map<String, IAssistProps> additionalAssists = new HashMap<String, IAssistProps>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean hasAdditionalAssist(String id) {
        Map<String, IAssistProps> map = additionalAssists;
        synchronized (map) {
            return additionalAssists.containsKey(id);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addAdditionalAssist(String id, IAssistProps assist) {
        Map<String, IAssistProps> map = additionalAssists;
        synchronized (map) {
            additionalAssists.put(id, assist);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeAdditionalAssist(String id) {
        Map<String, IAssistProps> map = additionalAssists;
        synchronized (map) {
            additionalAssists.remove(id);
        }
    }

    public PythonCorrectionProcessor(IPySyntaxHighlightingAndCodeCompletionEditor edit) {
        this.edit = edit;
    }

    public boolean canAssist(IQuickAssistInvocationContext invocationContext) {
        return true;
    }

    public boolean canFix(Annotation annotation) {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public ICompletionProposal[] computeQuickAssistProposals(IQuickAssistInvocationContext invocationContext) {
        int offset = invocationContext.getOffset();
        PySelection base = this.edit.createPySelection();
        if (!(this.edit instanceof PyEdit) || base == null) {
            return new ICompletionProposal[0];
        }
        PyEdit editor = (PyEdit)this.edit;
        ArrayList results = new ArrayList();
        String sel = TextSelectionUtils.getLineWithoutComments((TextSelectionUtils)base);
        ArrayList<Object> assists = new ArrayList<Object>();
        Map<String, IAssistProps> map = additionalAssists;
        synchronized (map) {
            for (IAssistProps prop : additionalAssists.values()) {
                assists.add(prop);
            }
        }
        assists.add(new AssistSurroundWith());
        assists.add(new AssistImport());
        assists.add(new AssistDocString());
        assists.add(new AssistAssign());
        assists.add((Object)new AssistPercentToFormat());
        assists.add(new AssistImportToLocal());
        assists.add(new AssistFString());
        assists.addAll(ExtensionHelper.getParticipants((String)"org.python.pydev.pydev_ctrl_1"));
        IImageCache imageCache = SharedUiPlugin.getImageCache();
        File editorFile = this.edit.getEditorFile();
        IPythonNature pythonNature = null;
        try {
            pythonNature = this.edit.getPythonNature();
        }
        catch (MisconfigurationException misconfigurationException) {
            Log.log((Throwable)misconfigurationException);
        }
        for (IAssistProps iAssistProps : assists) {
            PySelection ps = new PySelection(base);
            try {
                if (!iAssistProps.isValid(ps, sel, (IPyEdit)editor, offset)) continue;
                try {
                    results.addAll(iAssistProps.getProps(ps, imageCache, editorFile, pythonNature, (IPyEdit)editor, offset));
                }
                catch (Exception e) {
                    Log.log((Throwable)e);
                }
            }
            catch (Exception e) {
                Log.log((Throwable)e);
            }
        }
        Collections.sort(results, new ProposalsComparator("", (IPyCompletionProposal.ICompareContext)new ProposalsComparator.CompareContext(pythonNature)));
        try {
            void var11_16;
            Object var11_14 = null;
            IAnnotationModel annotationModel = editor.getPySourceViewer().getAnnotationModel();
            Iterator it = annotationModel.getAnnotationIterator();
            while (it.hasNext()) {
                Annotation annotation = (Annotation)it.next();
                if (!(annotation instanceof SpellingAnnotation)) continue;
                SpellingAnnotation spellingAnnotation = (SpellingAnnotation)annotation;
                SpellingProblem spellingProblem = spellingAnnotation.getSpellingProblem();
                int problemOffset = spellingProblem.getOffset();
                int problemLen = spellingProblem.getLength();
                if (problemOffset > offset || problemOffset + problemLen < offset) continue;
                SpellingCorrectionProcessor spellingCorrectionProcessor = new SpellingCorrectionProcessor();
                ICompletionProposal[] iCompletionProposalArray = spellingCorrectionProcessor.computeQuickAssistProposals(invocationContext);
                break;
            }
            if (var11_16 == null || ((void)var11_16).length == 1 && var11_16[0] instanceof NoCompletionsProposal) {
                return results.toArray(new ICompletionProposal[results.size()]);
            }
            ICompletionProposal[] ret = results.toArray(new ICompletionProposal[results.size() + ((void)var11_16).length]);
            System.arraycopy(var11_16, 0, ret, results.size(), ((void)var11_16).length);
            return ret;
        }
        catch (Throwable throwable) {
            if (throwable instanceof ClassNotFoundException || throwable instanceof LinkageError || throwable instanceof NoSuchMethodException || throwable instanceof NoSuchMethodError || throwable instanceof NoClassDefFoundError) {
                return results.toArray(new ICompletionProposal[results.size()]);
            }
            throw new RuntimeException(throwable);
        }
    }

    public String getErrorMessage() {
        return null;
    }
}

