/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.editor.correctionassist.heuristics;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.text.BadLocationException;
import org.python.pydev.core.IAssistProps;
import org.python.pydev.core.IPyEdit;
import org.python.pydev.core.IPythonNature;
import org.python.pydev.core.docutils.PySelection;
import org.python.pydev.core.imports.ImportPreferences;
import org.python.pydev.core.proposals.CompletionProposalFactory;
import org.python.pydev.shared_core.code_completion.ICompletionProposalHandle;
import org.python.pydev.shared_core.image.IImageCache;
import org.python.pydev.shared_core.string.TextSelectionUtils;

public class AssistImport
implements IAssistProps {
    public List<ICompletionProposalHandle> getProps(PySelection ps, IImageCache imageCache, File f, IPythonNature nature, IPyEdit edit, int offset) throws BadLocationException {
        ArrayList<ICompletionProposalHandle> l = new ArrayList<ICompletionProposalHandle>();
        String sel = TextSelectionUtils.getLineWithoutComments((TextSelectionUtils)ps);
        int i = sel.indexOf("import");
        if (ps.getStartLineIndex() != ps.getEndLineIndex()) {
            return l;
        }
        String delimiter = ps.getEndLineDelim();
        boolean isFuture = PySelection.isFutureImportLine((String)sel.trim());
        int lineToMoveImport = ps.getLineAvailableForImport(isFuture);
        try {
            int lineToMoveOffset = ps.getDoc().getLineOffset(lineToMoveImport);
            if (i >= 0 && Character.isWhitespace(sel.charAt(0))) {
                l.add(CompletionProposalFactory.get().createFixCompletionProposal(sel.trim() + delimiter, lineToMoveOffset, 0, ps.getStartLine().getOffset(), imageCache.get("icons/correction_move.gif"), "Move import to global scope", null, null, ps.getStartLineIndex() + 1));
            }
        }
        catch (BadLocationException lineToMoveOffset) {
            // empty catch block
        }
        if (i >= 0) {
            String cursorLineContents = ps.getCursorLineContents();
            String importEngine = ImportPreferences.getImportEngine((IAdaptable)edit);
            String messageToIgnore = "@NoMove";
            String caption = messageToIgnore.substring(1);
            if ("IMPORT_ENGINE_ISORT".equals(importEngine)) {
                messageToIgnore = "isort:skip";
                caption = "isort:skip";
            }
            if (!cursorLineContents.contains(messageToIgnore)) {
                ICompletionProposalHandle proposal = CompletionProposalFactory.get().createIgnoreCompletionProposalInSameLine(messageToIgnore, ps.getEndLineOffset(), 0, offset, imageCache.get("icons/annotation_obj.gif"), caption, null, null, 10, edit, cursorLineContents, ps, null);
                l.add(proposal);
            }
        }
        return l;
    }

    public boolean isValid(PySelection ps, String sel, IPyEdit edit, int offset) {
        return sel.indexOf("import ") != -1;
    }
}

