/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.editor.correctionassist.heuristics;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.ListIterator;
import java.util.Map;
import java.util.regex.MatchResult;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.runtime.Assert;
import org.python.pydev.core.docutils.PyStringUtils;
import org.python.pydev.shared_core.string.StringUtils;

public final class PercentToBraceConverter {
    private int argIndex;
    private String initialSourceString;
    private String matchedFormatString;
    private String head;
    private String tail;
    private boolean skipFormatCallReplacement;
    private int length;
    private static final boolean DEBUG = false;
    private static final Pattern FMTSTR_PATTERN = Pattern.compile("((?:r|u|ru|ur)?([\"']{1}|['\"]{3})(?!\\2).+?(?:\\2))(\\s*?%\\s*)(.+)$", 4);

    public PercentToBraceConverter(String formatStringToConvert) {
        if (formatStringToConvert == null) {
            throw new IllegalArgumentException("formatStringToConvert can't be null!");
        }
        this.initialSourceString = formatStringToConvert;
        this.matchedFormatString = "";
        this.head = "";
        this.tail = "";
        this.length = 0;
        this.argIndex = 0;
    }

    public String convert() {
        if (this.initialSourceString.isEmpty()) {
            return this.initialSourceString;
        }
        String input = this.initialSourceString;
        String[] lines = input.split("\\r?\\n");
        ArrayList<String> results = new ArrayList<String>();
        String sep = System.getProperty("line.separator");
        String[] stringArray = lines;
        int n = lines.length;
        int n2 = 0;
        while (n2 < n) {
            String line = stringArray[n2];
            String result = "";
            this.initialSourceString = line;
            Matcher formatStringMatcher = FMTSTR_PATTERN.matcher(line);
            Matcher tokenMatcher = PercentConversion.getTokenPattern().matcher(new String(line));
            boolean isFormatString = false;
            if (formatStringMatcher.find()) {
                if (4 == formatStringMatcher.groupCount()) {
                    String replaced;
                    isFormatString = true;
                    this.matchedFormatString = formatStringMatcher.group(0);
                    this.storeHeadAndTail();
                    if (!this.skipFormatCallReplacement && !this.matchedFormatString.equals(replaced = this.replaceInterpolantTokenWithFormatCall(formatStringMatcher))) {
                        this.updateStrings(replaced);
                    }
                } else {
                    isFormatString = false;
                }
            }
            if (isFormatString) {
                ArrayList<PercentConversion> conversions = new ArrayList<PercentConversion>();
                PercentConversion conv = null;
                while (tokenMatcher.find()) {
                    if (tokenMatcher.groupCount() < 1) continue;
                    conv = new PercentConversion(this, tokenMatcher.toMatchResult());
                    conversions.add(conv);
                }
                ListIterator li = conversions.listIterator(conversions.size());
                String converted = null;
                while (li.hasPrevious()) {
                    conv = (PercentConversion)li.previous();
                    int[] span = conv.getSpan();
                    converted = conv.toBrace();
                    result = this.insertIntoResult(converted, span);
                    this.updateStrings(result);
                }
                Assert.isTrue((this.argIndex <= 0 ? 1 : 0) != 0, (String)("W: argIndex shouldn't be greater than zero when all tokens are consumed, but is " + this.argIndex));
            } else {
                result = this.initialSourceString;
            }
            results.add(result);
            ++n2;
        }
        String convertedString = null;
        if (1 == results.size()) {
            convertedString = (String)results.get(0);
        } else if (results.size() > 1) {
            convertedString = StringUtils.join((String)sep, (Object[])results.toArray());
        } else {
            Assert.isTrue((boolean)false, (String)"E: there must always be one result even if the source string is not a valid percent format string.");
        }
        return convertedString;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof PercentToBraceConverter)) {
            return false;
        }
        PercentToBraceConverter other = (PercentToBraceConverter)obj;
        if (!this.initialSourceString.equals(other.initialSourceString)) {
            return false;
        }
        return this.skipFormatCallReplacement == other.skipFormatCallReplacement;
    }

    public int getLength() {
        return this.length;
    }

    public int hashCode() {
        return 1 + this.initialSourceString.hashCode() << (this.skipFormatCallReplacement ? 1 : 0);
    }

    public boolean isSkippingFormatCallReplacement() {
        return this.skipFormatCallReplacement;
    }

    public void setSkipFormatCallReplacement(boolean skipFormatCallReplacement) {
        this.skipFormatCallReplacement = skipFormatCallReplacement;
    }

    public static boolean isValidPercentFormatString(String aString, boolean splitLines) {
        boolean result = false;
        Matcher matcher = null;
        if (splitLines) {
            String[] lines;
            String[] stringArray = lines = aString.split("\\r?\\n");
            int n = lines.length;
            int n2 = 0;
            while (n2 < n) {
                String line = stringArray[n2];
                matcher = PercentToBraceConverter.getFormatStringPattern().matcher(line);
                if (matcher.find()) {
                    result = true;
                    break;
                }
                ++n2;
            }
        } else {
            matcher = PercentToBraceConverter.getFormatStringPattern().matcher(aString);
            if (matcher.find()) {
                result = true;
            }
        }
        return result;
    }

    public String toString() {
        String description = MessageFormat.format("<{0}@0x{1} | source={2} match={3} argIndex={4} head={5} tail={6}>", this.getClass().getSimpleName(), Integer.toHexString(this.hashCode()), this.initialSourceString, this.matchedFormatString, this.argIndex, this.head, this.tail);
        return description;
    }

    private static Pattern getFormatStringPattern() {
        return FMTSTR_PATTERN;
    }

    private static Map<String, String> extractFormatStringGroups(MatchResult matchResult) {
        Assert.isLegal((4 == matchResult.groupCount() ? 1 : 0) != 0, (String)"E: Match result from FMTSTR_PATTERN is malformed. Group count must be 4.");
        HashMap<String, String> result = new HashMap<String, String>(4);
        String fmtString = matchResult.group(1);
        String strChar = matchResult.group(2);
        String interpToken = matchResult.group(3);
        String interpValues = matchResult.group(4);
        result.put("FormatString", fmtString);
        result.put("StringCharacter", strChar);
        result.put("InterpolantToken", interpToken);
        result.put("InterpolationValues", interpValues);
        return result;
    }

    private String insertIntoResult(String convertedToken, int[] span) {
        String result = null;
        Object formatStringMatch = this.matchedFormatString;
        if (!this.head.isEmpty() && ((String)formatStringMatch).indexOf(this.head) == -1) {
            formatStringMatch = this.head + (String)formatStringMatch;
        }
        if (!this.tail.isEmpty() && ((String)formatStringMatch).lastIndexOf(this.tail) == -1) {
            formatStringMatch = (String)formatStringMatch + this.tail;
        }
        int from = span[1];
        int to = span[0];
        int len = ((String)formatStringMatch).length();
        String beginning = ((String)formatStringMatch).substring(0, to);
        String end = ((String)formatStringMatch).substring(from, len);
        if (Pattern.matches("\\{[0-9]{1,}.*?\\}", convertedToken)) {
            --this.argIndex;
        }
        result = beginning + convertedToken + end;
        this.length = result.length();
        return result;
    }

    private String nextIndex() {
        String result = String.format("%d", this.argIndex);
        ++this.argIndex;
        return result;
    }

    private String replaceInterpolantTokenWithFormatCall(Matcher formatStringMatcher) {
        String result = this.initialSourceString;
        Map<String, String> groups = PercentToBraceConverter.extractFormatStringGroups(formatStringMatcher.toMatchResult());
        String fmtStr = groups.get("FormatString");
        String interpToken = groups.get("InterpolantToken");
        String interpValues = groups.get("InterpolationValues");
        if (fmtStr != null && interpToken != null && interpValues != null) {
            String s = "(";
            String e = ")";
            if ('(' == interpValues.charAt(0)) {
                s = "";
                e = "";
            }
            if (!this.tail.isEmpty()) {
                int index = interpValues.indexOf(this.tail);
                if (index > 0) {
                    result = String.format("%s%s%s%s%s", fmtStr, ".format", s, interpValues.substring(0, index), e);
                }
            } else {
                result = String.format("%s%s%s%s%s", fmtStr, ".format", s, interpValues, e);
            }
        }
        return result;
    }

    private void storeHeadAndTail() {
        String initial = this.initialSourceString;
        String matched = this.matchedFormatString;
        if (!initial.equals(matched)) {
            int to = initial.indexOf(matched);
            int from = matched.length();
            int initlen = initial.length();
            this.head = initial.substring(0, to);
            this.tail = initial.substring(from + to, initlen);
            if (this.tail.isEmpty()) {
                String valuesPart = PyStringUtils.findSubstring((String)matched, (char)'%', (boolean)true);
                int lastBracePos = StringUtils.lastIndexOf((String)valuesPart, (String)"\\)");
                int lastDoubleQuotePos = StringUtils.lastIndexOf((String)valuesPart, (String)"\\\"");
                int lastSingleQuotePos = StringUtils.lastIndexOf((String)valuesPart, (String)"'");
                int hashPos = PyStringUtils.indexOf((String)valuesPart, (char)'#', (boolean)true);
                int lastAlnumPos = StringUtils.lastIndexOf((String)valuesPart, (String)"[a-zA-Z0-9_]");
                if (hashPos == -1) {
                    hashPos = from;
                }
                int[] positions = new int[]{hashPos, lastBracePos, lastDoubleQuotePos, lastSingleQuotePos, lastAlnumPos};
                int min = lastBracePos;
                int max = 0;
                int i = 0;
                while (i < positions.length) {
                    int cur = positions[i];
                    if (cur != -1 && cur < hashPos) {
                        if (cur < min) {
                            min = cur;
                        }
                        if (cur > max) {
                            max = cur;
                        }
                    }
                    ++i;
                }
                this.tail = valuesPart.substring(max + 1);
            }
        } else {
            this.head = "";
            this.tail = "";
        }
    }

    private void updateStrings(String newResult) throws IllegalArgumentException {
        String processedNewResult;
        Assert.isNotNull((Object)newResult, (String)"E: newResult can't be null!");
        this.initialSourceString = processedNewResult = new String(newResult);
        this.matchedFormatString = processedNewResult;
        this.length = processedNewResult.length();
    }

    private static final class PercentConversion {
        private static final Pattern TOKEN_PATTERN = Pattern.compile("(?<!%)%(?:\\(([^\\)]+)\\))?([#+ -]{1,})?((?:\\*|(?:[0-9][0-9]*?)))?(?:\\.((?:\\*|(?:[0-9][0-9]*?)))?)?([hlL])?(?<!\\s)([diouxXeEfFgGcrs%])");
        private final int[] span;
        private final String source;
        private final String key;
        private final String width;
        private final String precision;
        private final String flags;
        private final String conversion;

        public PercentConversion(PercentToBraceConverter aConverter, MatchResult aMatch) throws IllegalArgumentException, IllegalStateException {
            if (aConverter == null) {
                throw new IllegalArgumentException("Converter can't be null!");
            }
            if (aMatch == null) {
                throw new IllegalArgumentException("Match can't be null!");
            }
            this.source = aMatch.group(0);
            this.span = new int[]{aMatch.start(), aMatch.end()};
            Map<String, String> groups = PercentConversion.extractTokenGroups(aMatch);
            String spec = groups.get("Key");
            this.key = spec == null ? ("%%".equals(this.source) ? "" : aConverter.nextIndex()) : spec;
            spec = groups.get("Width");
            this.width = spec != null && "*".equals(spec) ? String.format("{%s}", aConverter.nextIndex()) : spec;
            spec = groups.get("Precision");
            this.precision = spec != null && "*".equals(spec) ? String.format("{%s}", aConverter.nextIndex()) : spec;
            this.flags = groups.get("Flags");
            this.conversion = groups.get("Conversion");
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof PercentConversion)) {
                return false;
            }
            PercentConversion other = (PercentConversion)obj;
            if (this.span[0] != other.span[0] || this.span[1] != other.span[1]) {
                return false;
            }
            return this.source.equals(other.source);
        }

        public int hashCode() {
            return this.span[0] + this.span[1] + this.source.hashCode();
        }

        public String toString() {
            String description = MessageFormat.format("<{0}@0x{1} | source={2} span=[{3}:{4}]>", this.getClass().getSimpleName(), Integer.toHexString(this.hashCode()), this.source, this.span[0], this.span[1]);
            return description;
        }

        public String toBrace() {
            Object result = null;
            String conversion = this.conversion;
            String key = "";
            String flags = "";
            if ("%".equals(conversion)) {
                return this.source;
            }
            boolean isNumber = Pattern.compile("\\d+").matcher(this.key).matches();
            key = isNumber ? this.key : String.format("[%s]", this.key);
            if (this.flags != null) {
                flags = this.flags;
            }
            String align = "";
            align = this.width == null ? "" : (flags.indexOf(45) > -1 ? "<" : (flags.indexOf(48) > -1 && "diouxXbB".indexOf(conversion) > -1 ? "=" : ">"));
            String sign = "";
            String fill = "";
            String alt = "";
            if (flags != null && flags.length() > 0) {
                if (flags.indexOf(43) > -1) {
                    sign = "+";
                } else if (flags.indexOf(32) > -1) {
                    sign = " ";
                }
                if (flags.indexOf(48) > -1 && flags.indexOf(45) == -1 && "crs".indexOf(conversion) == -1) {
                    fill = "0";
                }
                if (flags.indexOf(35) > -1 && "diuxXbB".indexOf(conversion) > -1) {
                    alt = "#";
                }
            }
            Object transform = "";
            if ("iu".indexOf(conversion) > -1) {
                conversion = "d";
            } else if ("rs".indexOf(conversion) > -1) {
                transform = "!" + conversion;
                conversion = "";
            }
            String prefix = String.format("%s%s", key, transform);
            Object suffix = String.format("%s%s%s%s", fill, align, sign, alt);
            if (this.width != null) {
                suffix = (String)suffix + this.width;
            }
            if (this.precision != null) {
                suffix = (String)suffix + "." + this.precision;
            }
            suffix = (String)suffix + conversion;
            result = prefix;
            if (!((String)suffix).isEmpty()) {
                result = (String)result + ":" + (String)suffix;
            }
            result = String.format("{%s}", result);
            return result;
        }

        private String getSource() {
            return this.source;
        }

        private int[] getSpan() {
            return this.span;
        }

        private static Map<String, String> extractTokenGroups(MatchResult matchResult) {
            Assert.isLegal((6 == matchResult.groupCount() ? 1 : 0) != 0, (String)"E: match result from TOKEN_PATTERN is malformed. Group count must be 6.");
            HashMap<String, String> result = new HashMap<String, String>(6);
            String key = matchResult.group(1);
            String flags = matchResult.group(2);
            String width = matchResult.group(3);
            String precision = matchResult.group(4);
            String length = matchResult.group(5);
            String conversion = matchResult.group(6);
            result.put("Key", key);
            result.put("Flags", flags);
            result.put("Width", width);
            result.put("Precision", precision);
            result.put("Length", length);
            result.put("Conversion", conversion);
            return result;
        }

        private static Pattern getTokenPattern() {
            return TOKEN_PATTERN;
        }
    }
}

