/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.editor.preferences;

import org.eclipse.jface.preference.BooleanFieldEditor;
import org.eclipse.jface.preference.ColorFieldEditor;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.jface.preference.FieldEditorPreferencePage;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.IntegerFieldEditor;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.python.pydev.plugin.PydevPlugin;

public class PydevVerticalIndentGuidePreferencesPage
extends FieldEditorPreferencePage
implements IWorkbenchPreferencePage {
    private ColorFieldEditor selectionColorFieldEditor;
    private BooleanFieldEditor useEditorForegroundAsColorFieldEditor;
    private BooleanFieldEditor showVerticalindentGuideFieldEditor;
    private IntegerFieldEditor transparencyFieldEditor;

    public PydevVerticalIndentGuidePreferencesPage() {
        super(1);
        this.setDescription("Vertical Indent Guide");
        this.setPreferenceStore(PydevPlugin.getDefault().getPreferenceStore());
    }

    public void init(IWorkbench workbench) {
    }

    protected void createFieldEditors() {
        Composite p = this.getFieldEditorParent();
        this.showVerticalindentGuideFieldEditor = new BooleanFieldEditor("USE_VERTICAL_INDENT_GUIDE", "Show vertical indent guide?", p);
        this.addField((FieldEditor)this.showVerticalindentGuideFieldEditor);
        this.useEditorForegroundAsColorFieldEditor = new BooleanFieldEditor("USE_VERTICAL_INDENT_COLOR_EDITOR_FOREGROUND", "Use the editor foreground as the color?", p);
        this.addField((FieldEditor)this.useEditorForegroundAsColorFieldEditor);
        this.selectionColorFieldEditor = new ColorFieldEditor("VERTICAL_INDENT_COLOR", "Vertical indent guide color.", p);
        this.addField((FieldEditor)this.selectionColorFieldEditor);
        this.transparencyFieldEditor = new IntegerFieldEditor("VERTICAL_INDENT_TRANSPARENCY", "Vertical indent guide transparency\n(0 = transparent, 255 = opaque).", p);
        this.transparencyFieldEditor.setValidRange(0, 255);
        this.addField((FieldEditor)this.transparencyFieldEditor);
        this.updateInitialState();
    }

    private void updateInitialState() {
        boolean show;
        IPreferenceStore preferenceStore = PydevPlugin.getDefault().getPreferenceStore();
        this.update(show, (show = preferenceStore.getBoolean("USE_VERTICAL_INDENT_GUIDE")) && !preferenceStore.getBoolean("USE_VERTICAL_INDENT_COLOR_EDITOR_FOREGROUND"));
    }

    public void propertyChange(PropertyChangeEvent event) {
        super.propertyChange(event);
        this.updateCurrentState();
    }

    private void updateCurrentState() {
        boolean show;
        this.update(show, (show = this.showVerticalindentGuideFieldEditor.getBooleanValue()) && !this.useEditorForegroundAsColorFieldEditor.getBooleanValue());
    }

    protected void performDefaults() {
        super.performDefaults();
        this.updateCurrentState();
    }

    private void update(boolean enableSelectEditorColor, boolean enableSelectionColor) {
        Composite p = this.getFieldEditorParent();
        this.useEditorForegroundAsColorFieldEditor.setEnabled(enableSelectEditorColor, p);
        this.selectionColorFieldEditor.setEnabled(enableSelectionColor, p);
        this.transparencyFieldEditor.setEnabled(enableSelectEditorColor, p);
    }
}

