/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.logging;

import java.io.File;
import org.eclipse.jface.preference.BooleanFieldEditor;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.jface.preference.FieldEditorPreferencePage;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.python.pydev.core.logging.DebugSettings;
import org.python.pydev.core.logging.PyLoggingPreferences;
import org.python.pydev.plugin.PydevPlugin;
import org.python.pydev.shared_core.io.FileUtils;
import org.python.pydev.shared_core.log.ToLogFile;
import org.python.pydev.shared_ui.field_editors.LabelFieldEditor;
import org.python.pydev.shared_ui.field_editors.LinkFieldEditor;

public class PyLoggingPreferencesPage
extends FieldEditorPreferencePage
implements IWorkbenchPreferencePage {
    public PyLoggingPreferencesPage() {
        super(1);
        this.setPreferenceStore(PydevPlugin.getDefault().getPreferenceStore());
    }

    protected void createFieldEditors() {
        Composite p = this.getFieldEditorParent();
        this.addField((FieldEditor)new LabelFieldEditor("UNUSED", "Note: to log, check the items for which it should be enabled.\n\nThe log output should appear in a console view tab\nand in the file with the link below.\n\nAfterwards, remember to turn it off again, as things\nmay be slower when logging is enabled.\n\n", p));
        this.addField((FieldEditor)new BooleanFieldEditor("DEBUG_CODE_COMPLETION", "Enable logging for code completion?", p));
        this.addField((FieldEditor)new BooleanFieldEditor("DEBUG_ANALYSIS_REQUESTS", "Enable logging for analysis requests?", p));
        this.addField((FieldEditor)new BooleanFieldEditor("DEBUG_INTERPRETER_UPDATE", "Enable logging for interpreter auto update?", p));
        String logOutputFile = ToLogFile.getLogOutputFile();
        if (logOutputFile != null) {
            final File f = new File(logOutputFile);
            this.addField((FieldEditor)new LinkFieldEditor("UNUSED 2", "\nDirectory containing log file: " + f.getName() + "<a>\n" + f.getParent().toString() + "</a>", p, (SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    FileUtils.openDirectory((File)f.getParentFile());
                }
            }));
        }
    }

    public void init(IWorkbench workbench) {
    }

    public boolean performOk() {
        boolean ret = super.performOk();
        DebugSettings.DEBUG_CODE_COMPLETION = PyLoggingPreferences.isToDebugCodeCompletion();
        DebugSettings.DEBUG_ANALYSIS_REQUESTS = PyLoggingPreferences.isToDebugAnalysisRequests();
        DebugSettings.DEBUG_INTERPRETER_AUTO_UPDATE = PyLoggingPreferences.isToDebugInterpreterAutoUpdate();
        return ret;
    }
}

