/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.navigator;

import java.util.List;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.ui.IWorkingSet;
import org.eclipse.ui.navigator.CommonViewer;
import org.eclipse.ui.navigator.ICommonContentExtensionSite;
import org.eclipse.ui.navigator.IExtensionStateModel;
import org.python.pydev.core.log.Log;
import org.python.pydev.navigator.elements.IWrappedResource;
import org.python.pydev.shared_core.callbacks.ICallback;

public class TopLevelProjectsOrWorkingSetChoice {
    private static final String SHOW_TOP_LEVEL_WORKING_SETS = "org.eclipse.ui.navigator.resources.workingSets.showTopLevelWorkingSets";
    public static final int WORKING_SETS = 0;
    public static final int PROJECTS = 1;
    private IExtensionStateModel extensionStateModel;
    private IPropertyChangeListener rootModeListener = new IPropertyChangeListener(){

        public void propertyChange(PropertyChangeEvent event) {
            if (TopLevelProjectsOrWorkingSetChoice.SHOW_TOP_LEVEL_WORKING_SETS.equals(event.getProperty())) {
                TopLevelProjectsOrWorkingSetChoice.this.updateRootMode();
            }
        }
    };
    protected int rootMode = 1;

    public void init(ICommonContentExtensionSite aConfig, CommonViewer viewer) {
        this.dispose();
        try {
            this.extensionStateModel = viewer.getNavigatorContentService().findStateModel("org.eclipse.ui.navigator.resources.workingSets");
            this.extensionStateModel.addPropertyChangeListener(this.rootModeListener);
        }
        catch (Exception e) {
            Log.log((Throwable)e);
        }
        this.updateRootMode();
    }

    private void updateRootMode() {
        if (this.extensionStateModel != null) {
            this.rootMode = this.extensionStateModel.getBooleanProperty(SHOW_TOP_LEVEL_WORKING_SETS) ? 0 : 1;
        }
    }

    public void dispose() {
        try {
            if (this.extensionStateModel != null) {
                this.extensionStateModel.removePropertyChangeListener(this.rootModeListener);
            }
            this.extensionStateModel = null;
        }
        catch (Exception e) {
            Log.log((Throwable)e);
        }
    }

    public int getRootMode() {
        return this.rootMode;
    }

    public Object getWorkingSetParentIfAvailable(Object object, ICallback<List<IWorkingSet>, IWorkspaceRoot> getWorkingSetsCallback) {
        if (this.rootMode != 0 || object == null) {
            return null;
        }
        List workingSets = (List)getWorkingSetsCallback.call(null);
        for (IWorkingSet w : workingSets) {
            IAdaptable[] elements = w.getElements();
            if (elements == null) continue;
            IAdaptable[] iAdaptableArray = elements;
            int n = elements.length;
            int n2 = 0;
            while (n2 < n) {
                IAdaptable a = iAdaptableArray[n2];
                if (a != null) {
                    IWrappedResource wrappedResource;
                    if (object.equals(a)) {
                        return w;
                    }
                    if (object instanceof IWrappedResource && (wrappedResource = (IWrappedResource)object).getActualObject().equals(a)) {
                        return w;
                    }
                }
                ++n2;
            }
        }
        return null;
    }
}

