/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.navigator.actions;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.actions.DeleteResourceAction;
import org.python.pydev.ast.codecompletion.revisited.PythonPathHelper;
import org.python.pydev.navigator.actions.Helpers;

public class PyDeleteResourceAction
extends DeleteResourceAction {
    private ISelectionProvider provider;
    private List<IResource> selected;
    private List<IFolder> remFolders;

    public PyDeleteResourceAction(Shell shell, ISelectionProvider selectionProvider) {
        super(shell);
        this.provider = selectionProvider;
    }

    public boolean isEnabled() {
        this.fillSelection();
        return this.selected != null && this.selected.size() > 0;
    }

    private boolean fillSelection() {
        IStructuredSelection sSelection;
        this.selected = new ArrayList<IResource>();
        ISelection selection = this.provider.getSelection();
        if (!selection.isEmpty() && (sSelection = (IStructuredSelection)selection).size() >= 1) {
            for (Object element : sSelection) {
                IAdaptable adaptable;
                IResource resource;
                if (element instanceof IAdaptable && (resource = (IResource)(adaptable = (IAdaptable)element).getAdapter(IResource.class)) != null) {
                    this.selected.add(resource);
                    continue;
                }
                this.selected = null;
                return false;
            }
        }
        return true;
    }

    private void updatePyPath() {
        if (this.remFolders.size() == 0 || this.remFolders.get(0).exists()) {
            return;
        }
        PythonPathHelper.updatePyPath((IResource[])this.remFolders.toArray(new IResource[0]), null, (int)3);
    }

    protected List<IResource> getSelectedResources() {
        return this.selected;
    }

    public IStructuredSelection getStructuredSelection() {
        return new StructuredSelection(this.selected);
    }

    public void run() {
        if (!this.fillSelection()) {
            return;
        }
        Helpers.checkValidateState();
        this.remFolders = new ArrayList<IFolder>();
        for (IResource folder : this.selected) {
            if (!(folder instanceof IFolder)) continue;
            this.remFolders.add((IFolder)folder);
        }
        super.run();
        this.updatePyPath();
        this.remFolders.clear();
    }
}

