/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.navigator.actions.copied;

import java.io.File;
import java.util.ArrayList;
import java.util.Set;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.util.LocalSelectionTransfer;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.FileTransfer;
import org.eclipse.swt.dnd.TransferData;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.actions.CopyFilesAndFoldersOperation;
import org.eclipse.ui.actions.MoveFilesAndFoldersOperation;
import org.eclipse.ui.actions.ReadOnlyStateChecker;
import org.eclipse.ui.internal.navigator.resources.plugin.WorkbenchNavigatorMessages;
import org.eclipse.ui.internal.navigator.resources.plugin.WorkbenchNavigatorPlugin;
import org.eclipse.ui.navigator.CommonDropAdapter;
import org.eclipse.ui.navigator.resources.ResourceDropAdapterAssistant;
import org.eclipse.ui.part.ResourceTransfer;
import org.python.pydev.ast.codecompletion.revisited.PythonPathHelper;
import org.python.pydev.ast.refactoring.IPyRefactoringRequest;
import org.python.pydev.ast.refactoring.ModuleRenameRefactoringRequest;
import org.python.pydev.ast.refactoring.MultiModuleMoveRefactoringRequest;
import org.python.pydev.ast.refactoring.TargetNotInPythonpathException;
import org.python.pydev.core.IPythonNature;
import org.python.pydev.core.MisconfigurationException;
import org.python.pydev.core.log.Log;
import org.python.pydev.navigator.elements.IWrappedResource;
import org.python.pydev.plugin.nature.PythonNature;
import org.python.pydev.shared_core.SharedCorePlugin;
import org.python.pydev.shared_core.io.FileUtils;
import org.python.pydev.ui.refactoring.PyRenameRefactoring;

public class PyResourceDropAdapterAssistant
extends ResourceDropAdapterAssistant {
    private static final boolean DEBUG = false;
    private static final IResource[] NO_RESOURCES = new IResource[0];

    private Object getActual(Object target) {
        if (target instanceof IWrappedResource) {
            IWrappedResource resource = (IWrappedResource)target;
            target = resource.getActualObject();
        }
        return target;
    }

    public boolean isSupportedType(TransferData aTransferType) {
        return super.isSupportedType(aTransferType) || FileTransfer.getInstance().isSupportedType(aTransferType);
    }

    public IStatus validateDrop(Object target, int aDropOperation, TransferData transferType) {
        if (!((target = this.getActual(target)) instanceof IResource)) {
            return WorkbenchNavigatorPlugin.createStatus((int)1, (int)0, (String)WorkbenchNavigatorMessages.DropAdapter_targetMustBeResource, null);
        }
        IResource resource = (IResource)target;
        if (!resource.isAccessible()) {
            return WorkbenchNavigatorPlugin.createErrorStatus((int)0, (String)WorkbenchNavigatorMessages.DropAdapter_canNotDropIntoClosedProject, null);
        }
        IContainer destination = this.getActualTarget(resource);
        if (destination.getType() == 8) {
            return WorkbenchNavigatorPlugin.createErrorStatus((int)0, (String)WorkbenchNavigatorMessages.DropAdapter_resourcesCanNotBeSiblings, null);
        }
        String message = null;
        if (LocalSelectionTransfer.getTransfer().isSupportedType(transferType)) {
            IResource[] selectedResources = this.getSelectedResources();
            if (selectedResources.length == 0) {
                message = WorkbenchNavigatorMessages.DropAdapter_dropOperationErrorOther;
            } else {
                Object operation = aDropOperation == 1 ? new CopyFilesAndFoldersOperation(this.getShell()) : new MoveFilesAndFoldersOperation(this.getShell());
                message = operation.validateDestination(destination, selectedResources);
            }
        } else if (FileTransfer.getInstance().isSupportedType(transferType)) {
            String[] sourceNames = (String[])FileTransfer.getInstance().nativeToJava(transferType);
            if (sourceNames == null) {
                sourceNames = new String[]{};
            }
            CopyFilesAndFoldersOperation copyOperation = new CopyFilesAndFoldersOperation(this.getShell());
            message = copyOperation.validateImportDestination(destination, sourceNames);
        }
        if (message != null) {
            return WorkbenchNavigatorPlugin.createErrorStatus((int)0, (String)message, null);
        }
        return Status.OK_STATUS;
    }

    public IStatus handleDrop(CommonDropAdapter aDropAdapter, DropTargetEvent aDropTargetEvent, Object aTarget) {
        if (this.getCurrentTarget(aDropAdapter) == null || aDropTargetEvent.data == null) {
            return Status.CANCEL_STATUS;
        }
        IStatus status = null;
        IResource[] resources = null;
        TransferData currentTransfer = aDropAdapter.getCurrentTransfer();
        if (LocalSelectionTransfer.getTransfer().isSupportedType(currentTransfer)) {
            resources = this.getSelectedResources();
        } else if (ResourceTransfer.getInstance().isSupportedType(currentTransfer)) {
            resources = (IResource[])aDropTargetEvent.data;
        }
        if (FileTransfer.getInstance().isSupportedType(currentTransfer)) {
            status = this.performFileDrop(aDropAdapter, aDropTargetEvent.data);
        } else if (resources != null && resources.length > 0) {
            status = aDropAdapter.getCurrentOperation() == 1 ? this.performResourceCopy(aDropAdapter, this.getShell(), resources) : this.performResourceMove(aDropAdapter, resources);
        }
        this.openError(status);
        IContainer target = this.getActualTarget((IResource)this.getCurrentTarget(aDropAdapter));
        if (target != null && target.isAccessible()) {
            try {
                target.refreshLocal(1, null);
            }
            catch (CoreException coreException) {
                // empty catch block
            }
        }
        return status;
    }

    public IStatus validatePluginTransferDrop(IStructuredSelection aDragSelection, Object aDropTarget) {
        if (!((aDropTarget = this.getActual(aDropTarget)) instanceof IResource)) {
            return WorkbenchNavigatorPlugin.createStatus((int)1, (int)0, (String)WorkbenchNavigatorMessages.DropAdapter_targetMustBeResource, null);
        }
        IResource resource = (IResource)aDropTarget;
        if (!resource.isAccessible()) {
            return WorkbenchNavigatorPlugin.createErrorStatus((int)0, (String)WorkbenchNavigatorMessages.DropAdapter_canNotDropIntoClosedProject, null);
        }
        IContainer destination = this.getActualTarget(resource);
        if (destination.getType() == 8) {
            return WorkbenchNavigatorPlugin.createErrorStatus((int)0, (String)WorkbenchNavigatorMessages.DropAdapter_resourcesCanNotBeSiblings, null);
        }
        IResource[] selectedResources = this.getSelectedResources(aDragSelection);
        String message = null;
        if (selectedResources.length == 0) {
            message = WorkbenchNavigatorMessages.DropAdapter_dropOperationErrorOther;
        } else {
            MoveFilesAndFoldersOperation operation = new MoveFilesAndFoldersOperation(this.getShell());
            message = operation.validateDestination(destination, selectedResources);
        }
        if (message != null) {
            return WorkbenchNavigatorPlugin.createErrorStatus((int)0, (String)message, null);
        }
        return Status.OK_STATUS;
    }

    public IStatus handlePluginTransferDrop(IStructuredSelection aDragSelection, Object aDropTarget) {
        aDropTarget = this.getActual(aDropTarget);
        IContainer target = this.getActualTarget((IResource)aDropTarget);
        IResource[] resources = this.getSelectedResources(aDragSelection);
        MoveFilesAndFoldersOperation operation = new MoveFilesAndFoldersOperation(this.getShell());
        operation.copyResources(resources, target);
        if (target != null && target.isAccessible()) {
            try {
                target.refreshLocal(1, null);
            }
            catch (CoreException coreException) {
                // empty catch block
            }
        }
        return Status.OK_STATUS;
    }

    private IContainer getActualTarget(IResource mouseTarget) {
        if (mouseTarget.getType() == 1) {
            return mouseTarget.getParent();
        }
        return (IContainer)mouseTarget;
    }

    private IResource[] getSelectedResources() {
        ISelection selection = LocalSelectionTransfer.getTransfer().getSelection();
        if (selection instanceof IStructuredSelection) {
            return this.getSelectedResources((IStructuredSelection)selection);
        }
        return NO_RESOURCES;
    }

    private IResource[] getSelectedResources(IStructuredSelection selection) {
        ArrayList selectedResources = new ArrayList();
        for (Object o : selection) {
            IAdaptable a;
            IResource r;
            if (o instanceof IResource) {
                selectedResources.add(o);
                continue;
            }
            if (!(o instanceof IAdaptable) || (r = (IResource)(a = (IAdaptable)o).getAdapter(IResource.class)) == null) continue;
            selectedResources.add(r);
        }
        return selectedResources.toArray(new IResource[selectedResources.size()]);
    }

    private IStatus performResourceCopy(CommonDropAdapter dropAdapter, Shell shell, IResource[] sources) {
        MultiStatus problems = new MultiStatus("org.eclipse.ui", 1, WorkbenchNavigatorMessages.DropAdapter_problemsMoving, null);
        this.mergeStatus(problems, this.validateTarget(this.getCurrentTarget(dropAdapter), dropAdapter.getCurrentTransfer(), dropAdapter.getCurrentOperation()));
        IContainer target = this.getActualTarget((IResource)this.getCurrentTarget(dropAdapter));
        CopyFilesAndFoldersOperation operation = new CopyFilesAndFoldersOperation(shell);
        IResource[] copiedResources = operation.copyResources(sources, target);
        if (copiedResources.length > 0) {
            PythonPathHelper.updatePyPath((IResource[])copiedResources, (IContainer)target, (int)2);
        }
        return problems;
    }

    private IStatus performResourceMove(CommonDropAdapter dropAdapter, IResource[] sources) {
        MoveFilesAndFoldersOperation operation;
        IResource[] copiedResources;
        PythonNature nature;
        MultiStatus problems = new MultiStatus("org.eclipse.ui", 1, WorkbenchNavigatorMessages.DropAdapter_problemsMoving, null);
        this.mergeStatus(problems, this.validateTarget(this.getCurrentTarget(dropAdapter), dropAdapter.getCurrentTransfer(), dropAdapter.getCurrentOperation()));
        IContainer target = this.getActualTarget((IResource)this.getCurrentTarget(dropAdapter));
        ReadOnlyStateChecker checker = new ReadOnlyStateChecker(this.getShell(), WorkbenchNavigatorMessages.MoveResourceAction_title, WorkbenchNavigatorMessages.MoveResourceAction_checkMoveMessage);
        sources = checker.checkReadOnlyResources(sources);
        boolean targetInSourceFolder = false;
        try {
            nature = PythonNature.getPythonNature((IResource)target);
            Set projectSourcePathSet = nature.getPythonPathNature().getProjectSourcePathSet(true);
            for (String string : projectSourcePathSet) {
                if (!FileUtils.isPrefixOf((IPath)new Path(string), (IPath)target.getFullPath())) continue;
                targetInSourceFolder = true;
                break;
            }
        }
        catch (CoreException e1) {
            Log.log((Throwable)e1);
        }
        if (targetInSourceFolder) {
            try {
                int resolved = 0;
                ArrayList<ModuleRenameRefactoringRequest> requests = new ArrayList<ModuleRenameRefactoringRequest>();
                IResource[] iResourceArray = sources;
                int n = sources.length;
                int n2 = 0;
                while (n2 < n) {
                    IResource s = iResourceArray[n2];
                    if (PythonPathHelper.isValidSourceFile((String)s.getName())) {
                        nature = PythonNature.getPythonNature((IResource)s);
                        try {
                            String resolveModule = nature.resolveModule(s);
                            if (resolveModule != null) {
                                File file = s.getLocation().toFile();
                                boolean isDir = file.isDirectory();
                                File initFile = null;
                                if (isDir) {
                                    initFile = PythonPathHelper.getFolderInit((File)file);
                                }
                                if (isDir && initFile != null) {
                                    file = initFile;
                                }
                                ++resolved;
                                requests.add(new ModuleRenameRefactoringRequest(file, (IPythonNature)nature, target));
                            }
                        }
                        catch (MisconfigurationException e) {
                            Log.log((Throwable)e);
                        }
                    }
                    ++n2;
                }
                if (resolved != 0) {
                    if (resolved != sources.length) {
                        problems.add((IStatus)SharedCorePlugin.makeStatus((int)4, (String)"Unable to do refactor action because some of the resources moved are in the PYTHONPATH and some are not.", null));
                        return problems;
                    }
                    PyRenameRefactoring.rename((IPyRefactoringRequest)new MultiModuleMoveRefactoringRequest(requests, target));
                    return problems;
                }
            }
            catch (TargetNotInPythonpathException resolved) {
            }
            catch (Exception e) {
                Log.log((Throwable)e);
            }
        }
        if ((copiedResources = (operation = new MoveFilesAndFoldersOperation(this.getShell())).copyResources(sources, target)).length > 0) {
            PythonPathHelper.updatePyPath((IResource[])copiedResources, (IContainer)target, (int)1);
        }
        return problems;
    }

    private Object getCurrentTarget(CommonDropAdapter dropAdapter) {
        return this.getActual(dropAdapter.getCurrentTarget());
    }

    private IStatus performFileDrop(CommonDropAdapter anAdapter, Object data) {
        data = this.getActual(data);
        MultiStatus problems = new MultiStatus("org.eclipse.ui", 0, WorkbenchNavigatorMessages.DropAdapter_problemImporting, null);
        this.mergeStatus(problems, this.validateTarget(this.getCurrentTarget(anAdapter), anAdapter.getCurrentTransfer(), anAdapter.getCurrentOperation()));
        final IContainer target = this.getActualTarget((IResource)this.getCurrentTarget(anAdapter));
        final String[] names = (String[])data;
        Display.getCurrent().asyncExec(new Runnable(){

            @Override
            public void run() {
                PyResourceDropAdapterAssistant.this.getShell().forceActive();
                CopyFilesAndFoldersOperation operation = new CopyFilesAndFoldersOperation(PyResourceDropAdapterAssistant.this.getShell());
                operation.copyFiles(names, target);
            }
        });
        return problems;
    }

    private IStatus validateTarget(Object target, TransferData transferType, int dropOperation) {
        if (!((target = this.getActual(target)) instanceof IResource)) {
            return WorkbenchNavigatorPlugin.createInfoStatus((String)WorkbenchNavigatorMessages.DropAdapter_targetMustBeResource);
        }
        IResource resource = (IResource)target;
        if (!resource.isAccessible()) {
            return WorkbenchNavigatorPlugin.createErrorStatus((String)WorkbenchNavigatorMessages.DropAdapter_canNotDropIntoClosedProject);
        }
        IContainer destination = this.getActualTarget(resource);
        if (destination.getType() == 8) {
            return WorkbenchNavigatorPlugin.createErrorStatus((String)WorkbenchNavigatorMessages.DropAdapter_resourcesCanNotBeSiblings);
        }
        String message = null;
        if (LocalSelectionTransfer.getTransfer().isSupportedType(transferType)) {
            IResource[] selectedResources = this.getSelectedResources();
            if (selectedResources.length == 0) {
                message = WorkbenchNavigatorMessages.DropAdapter_dropOperationErrorOther;
            } else {
                Object operation = dropOperation == 1 ? new CopyFilesAndFoldersOperation(this.getShell()) : new MoveFilesAndFoldersOperation(this.getShell());
                message = operation.validateDestination(destination, selectedResources);
            }
        } else if (FileTransfer.getInstance().isSupportedType(transferType)) {
            String[] sourceNames = (String[])FileTransfer.getInstance().nativeToJava(transferType);
            if (sourceNames == null) {
                sourceNames = new String[]{};
            }
            CopyFilesAndFoldersOperation copyOperation = new CopyFilesAndFoldersOperation(this.getShell());
            message = copyOperation.validateImportDestination(destination, sourceNames);
        }
        if (message != null) {
            return WorkbenchNavigatorPlugin.createErrorStatus((String)message);
        }
        return Status.OK_STATUS;
    }

    private void mergeStatus(MultiStatus status, IStatus toMerge) {
        if (!toMerge.isOK()) {
            status.merge(toMerge);
        }
    }

    private void openError(IStatus status) {
        if (status == null) {
            return;
        }
        String genericTitle = WorkbenchNavigatorMessages.DropAdapter_title;
        int codes = 6;
        if (!status.isMultiStatus()) {
            ErrorDialog.openError((Shell)this.getShell(), (String)genericTitle, null, (IStatus)status, (int)codes);
            return;
        }
        IStatus[] children = status.getChildren();
        if (children.length == 1) {
            ErrorDialog.openError((Shell)this.getShell(), (String)status.getMessage(), null, (IStatus)children[0], (int)codes);
            return;
        }
        ErrorDialog.openError((Shell)this.getShell(), (String)genericTitle, null, (IStatus)status, (int)codes);
    }
}

