/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.outline;

import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.python.pydev.outline.ParsedItem;
import org.python.pydev.outline.PyOutlinePage;
import org.python.pydev.parser.jython.SimpleNode;
import org.python.pydev.parser.jython.ast.FunctionDef;
import org.python.pydev.parser.jython.ast.Name;
import org.python.pydev.parser.jython.ast.decoratorsType;
import org.python.pydev.parser.visitors.scope.ASTEntryWithChildren;
import org.python.pydev.shared_core.image.IImageCache;
import org.python.pydev.shared_ui.outline.AbstractOutlineFilterAction;
import org.python.pydev.shared_ui.outline.BaseOutlinePage;

public class OutlineHideOverloadsAction
extends AbstractOutlineFilterAction {
    private static final String PREF_HIDE_OVERLOADS = "org.python.pydev.OUTLINE_HIDE_OVERLOADS";

    public OutlineHideOverloadsAction(PyOutlinePage page, IImageCache imageCache) {
        super("Hide overload Methods", (BaseOutlinePage)page, imageCache, PREF_HIDE_OVERLOADS, "icons/overload_co.gif");
    }

    protected ViewerFilter createFilter() {
        return new ViewerFilter(){

            public boolean select(Viewer viewer, Object parentElement, Object element) {
                if (element instanceof ParsedItem) {
                    ParsedItem item = (ParsedItem)((Object)element);
                    ASTEntryWithChildren astThis = item.getAstThis();
                    if (astThis == null) {
                        return true;
                    }
                    SimpleNode token = astThis.node;
                    if (token instanceof FunctionDef) {
                        FunctionDef functionDefToken = (FunctionDef)token;
                        if (functionDefToken.decs != null) {
                            decoratorsType[] decoratorsTypeArray = functionDefToken.decs;
                            int n = functionDefToken.decs.length;
                            int n2 = 0;
                            while (n2 < n) {
                                decoratorsType decorator = decoratorsTypeArray[n2];
                                if (decorator.func instanceof Name) {
                                    Name decoratorFuncName = (Name)decorator.func;
                                    if (decoratorFuncName.id.equals("overload")) {
                                        return false;
                                    }
                                }
                                ++n2;
                            }
                        }
                    }
                }
                return true;
            }
        };
    }
}

