/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.outline;

import java.util.ArrayList;
import org.eclipse.jface.viewers.StructuredSelection;
import org.python.pydev.editor.PyEdit;
import org.python.pydev.outline.ParsedItem;
import org.python.pydev.parser.jython.SimpleNode;
import org.python.pydev.parser.jython.ast.Attribute;
import org.python.pydev.parser.jython.ast.ClassDef;
import org.python.pydev.parser.jython.ast.FunctionDef;
import org.python.pydev.parser.jython.ast.Import;
import org.python.pydev.parser.jython.ast.ImportFrom;
import org.python.pydev.parser.jython.ast.NameTokType;
import org.python.pydev.parser.jython.ast.aliasType;
import org.python.pydev.parser.visitors.scope.ASTEntryWithChildren;
import org.python.pydev.parser.visitors.scope.OutlineCreatorVisitor;
import org.python.pydev.shared_core.editor.IBaseEditor;
import org.python.pydev.shared_core.model.ErrorDescription;
import org.python.pydev.shared_core.model.ISimpleNode;
import org.python.pydev.shared_ui.outline.BaseModel;
import org.python.pydev.shared_ui.outline.IParsedItem;

public class ParsedModel
extends BaseModel {
    public ParsedModel(IBaseEditor editor) {
        super(editor);
    }

    protected IParsedItem createInitialRootFromEditor() {
        SimpleNode ast = ((PyEdit)this.editor).getAST();
        return this.createParsedItemFromSimpleNode((ISimpleNode)ast);
    }

    protected IParsedItem createParsedItemFromSimpleNode(ISimpleNode ast) {
        OutlineCreatorVisitor visitor = OutlineCreatorVisitor.create((SimpleNode)((SimpleNode)ast));
        return new ParsedItem(visitor.getAll().toArray(new ASTEntryWithChildren[0]), ((PyEdit)this.editor).getErrorDescription());
    }

    protected IParsedItem duplicateRootAddingError(ErrorDescription errorDesc) {
        ParsedItem newRoot;
        IParsedItem currRoot = this.getRoot();
        if (currRoot != null) {
            newRoot = new ParsedItem(((ParsedItem)currRoot).getAstChildrenEntries(), errorDesc);
            newRoot.updateTo(currRoot);
        } else {
            newRoot = new ParsedItem(new ASTEntryWithChildren[0], errorDesc);
        }
        return newRoot;
    }

    public SimpleNode[] getSelectionPosition(StructuredSelection sel) {
        if (sel.size() == 1) {
            Object firstElement = sel.getFirstElement();
            ASTEntryWithChildren p = ((ParsedItem)((Object)firstElement)).getAstThis();
            if (p == null) {
                return null;
            }
            SimpleNode node = p.node;
            if (node instanceof ClassDef) {
                ClassDef def = (ClassDef)node;
                node = def.name;
            } else if (node instanceof Attribute) {
                Attribute attribute = (Attribute)node;
                node = attribute.attr;
            } else if (node instanceof FunctionDef) {
                FunctionDef def = (FunctionDef)node;
                node = def.name;
            } else {
                if (node instanceof Import) {
                    ArrayList<NameTokType> ret = new ArrayList<NameTokType>();
                    Import importToken = (Import)node;
                    int i = 0;
                    while (i < importToken.names.length) {
                        aliasType aliasType2 = importToken.names[i];
                        if (aliasType2.asname != null) {
                            ret.add(aliasType2.asname);
                        }
                        ret.add(aliasType2.name);
                        ++i;
                    }
                    return ret.toArray(new SimpleNode[0]);
                }
                if (node instanceof ImportFrom) {
                    ArrayList<NameTokType> ret = new ArrayList<NameTokType>();
                    ImportFrom importToken = (ImportFrom)node;
                    boolean found = false;
                    int i = 0;
                    while (i < importToken.names.length) {
                        found = true;
                        aliasType aliasType3 = importToken.names[i];
                        if (aliasType3.asname != null) {
                            ret.add(aliasType3.asname);
                        }
                        ret.add(aliasType3.name);
                        ++i;
                    }
                    if (!found) {
                        ret.add(importToken.module);
                    }
                    return ret.toArray(new SimpleNode[0]);
                }
            }
            return new SimpleNode[]{node};
        }
        return null;
    }
}

