/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.plugin;

import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.ui.dialogs.PreferencesUtil;
import org.eclipse.ui.progress.UIJob;
import org.python.pydev.ast.interpreter_managers.AbstractInterpreterManager;
import org.python.pydev.ast.interpreter_managers.IInterpreterProviderFactory;
import org.python.pydev.core.NotConfiguredInterpreterException;
import org.python.pydev.core.log.Log;
import org.python.pydev.ui.dialogs.PyDialogHelpers;
import org.python.pydev.ui.pythonpathconf.AutoConfigMaker;

public class ConfigureInterpreterJob
extends UIJob {
    private volatile Set<AbstractInterpreterManager> interpreters = new HashSet<AbstractInterpreterManager>();

    public void addInterpreter(AbstractInterpreterManager abstractInterpreterManager) {
        this.interpreters.add(abstractInterpreterManager);
    }

    public ConfigureInterpreterJob() {
        super("Configure interpreter");
    }

    public IStatus runInUIThread(IProgressMonitor monitor) {
        Set<AbstractInterpreterManager> current = this.interpreters;
        this.interpreters = new HashSet<AbstractInterpreterManager>();
        for (AbstractInterpreterManager m : current) {
            try {
                m.getDefaultInterpreterInfo(false);
            }
            catch (NotConfiguredInterpreterException e) {
                int ret = PyDialogHelpers.openQuestionConfigureInterpreter(m);
                if (ret == -1) continue;
                if (ret == 0) {
                    PreferencesUtil.createPreferenceDialogOn(null, (String)m.getPreferencesPageId(), null, null).open();
                    continue;
                }
                if (ret == 2 || ret == 1) {
                    IInterpreterProviderFactory.InterpreterType interpreterType = switch (m.getInterpreterType()) {
                        case 1 -> IInterpreterProviderFactory.InterpreterType.JYTHON;
                        case 2 -> IInterpreterProviderFactory.InterpreterType.IRONPYTHON;
                        default -> IInterpreterProviderFactory.InterpreterType.PYTHON;
                    };
                    boolean advanced = ret == 2;
                    AutoConfigMaker a = new AutoConfigMaker(interpreterType, advanced, null, null);
                    a.autoConfigSingleApply(null);
                    continue;
                }
                Log.log((String)("Unexpected option: " + ret));
            }
        }
        return Status.OK_STATUS;
    }
}

