/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.plugin;

import com.python.pydev.analysis.flake8.Flake8Preferences;
import com.python.pydev.analysis.mypy.MypyPreferences;
import com.python.pydev.analysis.pylint.PyLintPreferences;
import com.python.pydev.analysis.pyright.PyrightPreferences;
import com.python.pydev.analysis.ruff.RuffPreferences;
import java.io.File;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.Set;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.jdt.internal.launching.StandardVMType;
import org.eclipse.jdt.launching.IVMInstall;
import org.eclipse.jdt.launching.JavaRuntime;
import org.eclipse.jdt.launching.LibraryLocation;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.link.LinkedModeModel;
import org.eclipse.jface.text.link.LinkedModeUI;
import org.eclipse.jface.text.link.LinkedPosition;
import org.eclipse.jface.text.link.LinkedPositionGroup;
import org.eclipse.jface.text.link.ProposalPosition;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.console.IOConsoleOutputStream;
import org.eclipse.ui.forms.FormColors;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.eclipse.ui.texteditor.link.EditorLinkedModeUI;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.service.prefs.BackingStoreException;
import org.python.pydev.ast.codecompletion.AbstractTemplateCodeCompletion;
import org.python.pydev.ast.codecompletion.revisited.DefaultSyncSystemModulesManagerScheduler;
import org.python.pydev.ast.codecompletion.revisited.ModulesManager;
import org.python.pydev.ast.codecompletion.revisited.ProjectModulesManager;
import org.python.pydev.ast.codecompletion.revisited.SyncSystemModulesManager;
import org.python.pydev.ast.codecompletion.shell.AbstractShell;
import org.python.pydev.ast.interpreter_managers.AbstractInterpreterManager;
import org.python.pydev.ast.interpreter_managers.InterpreterInfo;
import org.python.pydev.ast.interpreter_managers.InterpreterManagersAPI;
import org.python.pydev.ast.interpreter_managers.IronpythonInterpreterManager;
import org.python.pydev.ast.interpreter_managers.JythonInterpreterManager;
import org.python.pydev.ast.interpreter_managers.PythonInterpreterManager;
import org.python.pydev.ast.listing_utils.JavaVmLocationFinder;
import org.python.pydev.consoles.MessageConsoles;
import org.python.pydev.core.CorePlugin;
import org.python.pydev.core.IInterpreterInfo;
import org.python.pydev.core.IInterpreterManager;
import org.python.pydev.core.log.Log;
import org.python.pydev.core.preferences.PydevPrefs;
import org.python.pydev.core.proposals.CompletionProposalFactory;
import org.python.pydev.core.proposals.ICompletionProposalFactory;
import org.python.pydev.editor.codecompletion.proposals.DefaultCompletionProposalFactory;
import org.python.pydev.editor.codecompletion.proposals.PyLinkedModeCompletionProposal;
import org.python.pydev.editor.codecompletion.revisited.javaintegration.JavaProjectModulesManagerCreator;
import org.python.pydev.editor.codecompletion.revisited.javaintegration.JythonModulesManagerUtils;
import org.python.pydev.editor.hover.PyEditorTextHoverDescriptor;
import org.python.pydev.editor.hover.PydevCombiningHover;
import org.python.pydev.editor.templates.TemplateHelper;
import org.python.pydev.plugin.ConfigurationElementAttributeSorter;
import org.python.pydev.plugin.ConfigureInterpreterJob;
import org.python.pydev.plugin.PyDevUiPrefs;
import org.python.pydev.plugin.nature.PythonNature;
import org.python.pydev.shared_core.SharedCorePlugin;
import org.python.pydev.shared_core.image.IImageHandle;
import org.python.pydev.shared_core.io.FileUtils;
import org.python.pydev.shared_core.progress.CancelException;
import org.python.pydev.shared_core.structure.DataAndImageTreeNode;
import org.python.pydev.shared_core.structure.TreeNode;
import org.python.pydev.shared_ui.ColorCache;
import org.python.pydev.shared_ui.ImageCache;
import org.python.pydev.shared_ui.SharedUiPlugin;
import org.python.pydev.shared_ui.bundle.BundleInfo;
import org.python.pydev.shared_ui.bundle.IBundleInfo;
import org.python.pydev.shared_ui.log.ToLogFile;
import org.python.pydev.shared_ui.utils.RunInUiThread;
import org.python.pydev.ui.dialogs.PyDialogHelpers;
import org.python.pydev.ui.dialogs.SelectNDialog;
import org.python.pydev.ui.dialogs.TreeNodeLabelProvider;
import org.python.pydev.ui.pythonpathconf.PythonSelectionLibrariesDialog;

public class PydevPlugin
extends AbstractUIPlugin {
    private PyEditorTextHoverDescriptor[] fPyEditorTextHoverDescriptors;
    public static IBundleInfo info;
    private static PydevPlugin plugin;
    private ColorCache colorCache;
    private ResourceBundle resourceBundle;
    private boolean isAlive;
    private static PyEditorTextHoverDescriptor combiningHoverDescriptor;
    Job startSynchSchedulerJob = new Job("SynchScheduler start"){

        protected IStatus run(IProgressMonitor monitor) {
            DefaultSyncSystemModulesManagerScheduler.get().start();
            return Status.OK_STATUS;
        }
    };
    private ConfigureInterpreterJob configureInterpreterJob = new ConfigureInterpreterJob();
    private Set<String> erasePrefixes = new HashSet<String>();
    private FormToolkit fDialogsFormToolkit;

    public static String getVersion() {
        try {
            return (String)Platform.getBundle((String)"org.python.pydev").getHeaders().get("Bundle-Version");
        }
        catch (Exception e) {
            Log.log((Throwable)e);
            return "Unknown";
        }
    }

    public static IBundleInfo getBundleInfo() {
        if (info == null) {
            info = new BundleInfo(PydevPlugin.getDefault().getBundle());
        }
        return info;
    }

    public static void setBundleInfo(IBundleInfo b) {
        info = b;
    }

    public PydevPlugin() {
        plugin = this;
    }

    public void start(BundleContext context) throws Exception {
        this.isAlive = true;
        super.start(context);
        AbstractTemplateCodeCompletion.getTemplateContextType = () -> TemplateHelper.getContextTypeRegistry().getContextType("org.python.pydev.editor.templates.python");
        CompletionProposalFactory.set((ICompletionProposalFactory)new DefaultCompletionProposalFactory());
        ProjectModulesManager.createJavaProjectModulesManagerIfPossible = project -> JavaProjectModulesManagerCreator.createJavaProjectModulesManagerIfPossible(project);
        ModulesManager.createModuleFromJar = (emptyModuleForZip, nature) -> JythonModulesManagerUtils.createModuleFromJar(emptyModuleForZip, nature);
        CorePlugin.pydevStatelocation = Platform.getStateLocation((Bundle)this.getBundle()).toFile();
        PyLintPreferences.createPyLintStream = projectAdaptable -> {
            if (PyLintPreferences.useConsole((IAdaptable)projectAdaptable)) {
                IOConsoleOutputStream console = MessageConsoles.getConsoleOutputStream("PyLint", "icons/pylint.png");
                return string -> console.write(string);
            }
            return null;
        };
        Flake8Preferences.createFlake8Stream = projectAdaptable -> {
            if (Flake8Preferences.useFlake8Console((IAdaptable)projectAdaptable)) {
                IOConsoleOutputStream console = MessageConsoles.getConsoleOutputStream("Flake8", "icons/flake8.png");
                return string -> console.write(string);
            }
            return null;
        };
        MypyPreferences.createMypyStream = projectAdaptable -> {
            if (MypyPreferences.useMypyConsole((IAdaptable)projectAdaptable)) {
                IOConsoleOutputStream console = MessageConsoles.getConsoleOutputStream("Mypy", "icons/python_file.gif");
                return string -> console.write(string);
            }
            return null;
        };
        RuffPreferences.createRuffStream = projectAdaptable -> {
            if (RuffPreferences.useRuffConsole((IAdaptable)projectAdaptable)) {
                IOConsoleOutputStream console = MessageConsoles.getConsoleOutputStream("Ruff", "icons/python_file.gif");
                return string -> console.write(string);
            }
            return null;
        };
        PyrightPreferences.createPyrightStream = projectAdaptable -> {
            if (PyrightPreferences.usePyrightConsole((IAdaptable)projectAdaptable)) {
                IOConsoleOutputStream console = MessageConsoles.getConsoleOutputStream("PyRight", "icons/python_file.gif");
                return string -> console.write(string);
            }
            return null;
        };
        JavaVmLocationFinder.callbackJavaJars = () -> {
            try {
                IVMInstall defaultVMInstall = JavaRuntime.getDefaultVMInstall();
                LibraryLocation[] libraryLocations = JavaRuntime.getLibraryLocations((IVMInstall)defaultVMInstall);
                ArrayList<File> jars = new ArrayList<File>();
                LibraryLocation[] libraryLocationArray = libraryLocations;
                int n = libraryLocations.length;
                int n2 = 0;
                while (n2 < n) {
                    LibraryLocation location = libraryLocationArray[n2];
                    jars.add(location.getSystemLibraryPath().toFile());
                    ++n2;
                }
                return jars;
            }
            catch (Throwable e) {
                JythonModulesManagerUtils.tryRethrowAsJDTNotAvailableException(e);
                throw new RuntimeException("Should never get here", e);
            }
        };
        JavaVmLocationFinder.callbackJavaExecutable = () -> {
            try {
                IVMInstall defaultVMInstall = JavaRuntime.getDefaultVMInstall();
                File installLocation = defaultVMInstall.getInstallLocation();
                return StandardVMType.findJavaExecutable((File)installLocation);
            }
            catch (Throwable e) {
                JythonModulesManagerUtils.tryRethrowAsJDTNotAvailableException(e);
                throw new RuntimeException("Should never get here", e);
            }
        };
        PyLinkedModeCompletionProposal.goToLinkedModeHandler = (proposal, viewer, offset, doc, exitPos, iPar, offsetsAndLens) -> {
            LinkedModeModel model = new LinkedModeModel();
            int i = 0;
            while (i < offsetsAndLens.size()) {
                Integer offs = (Integer)offsetsAndLens.get(i);
                Integer len = (Integer)offsetsAndLens.get(++i);
                if (i == 1) {
                    proposal.firstParameterLen = len;
                }
                int location = offset + iPar + offs + 1;
                LinkedPositionGroup group = new LinkedPositionGroup();
                ProposalPosition proposalPosition = new ProposalPosition(doc, location, len.intValue(), 0, new ICompletionProposal[0]);
                group.addPosition((LinkedPosition)proposalPosition);
                model.addGroup(group);
                ++i;
            }
            model.forceInstall();
            EditorLinkedModeUI ui = new EditorLinkedModeUI(model, viewer);
            ui.setDoContextInfo(true);
            ui.setExitPosition(viewer, exitPos, 0, Integer.MAX_VALUE);
            Runnable r = new Runnable((LinkedModeUI)ui){
                private final /* synthetic */ LinkedModeUI val$ui;
                {
                    this.val$ui = linkedModeUI;
                }

                @Override
                public void run() {
                    this.val$ui.enter();
                }
            };
            RunInUiThread.async((Runnable)r);
        };
        SyncSystemModulesManager.selectElementsInDialog = (root, initialSelection) -> {
            List<TreeNode> selectElements = SelectNDialog.selectElements((TreeNode)root, new TreeNodeLabelProvider(){

                @Override
                public Image getImage(Object element) {
                    DataAndImageTreeNode n = (DataAndImageTreeNode)element;
                    return ImageCache.asImage((IImageHandle)n.image);
                }

                @Override
                public String getText(Object element) {
                    TreeNode n = (TreeNode)element;
                    Object data = n.getData();
                    if (data == null) {
                        return "null";
                    }
                    if (data instanceof IInterpreterInfo) {
                        IInterpreterInfo iInterpreterInfo = (IInterpreterInfo)data;
                        return iInterpreterInfo.getNameForUI();
                    }
                    return data.toString();
                }
            }, "System PYTHONPATH changes detected", "Please check which interpreters and paths should be updated.", true, initialSelection);
            return selectElements;
        };
        InterpreterInfo.selectLibraries = new InterpreterInfo.IPythonSelectLibraries(){

            public List<String> select(List<String> selection, List<String> toAsk) throws CancelException {
                boolean result = true;
                PythonSelectionLibrariesDialog runnable = new PythonSelectionLibrariesDialog(selection, toAsk, true);
                try {
                    RunInUiThread.sync((Runnable)runnable);
                }
                catch (NoClassDefFoundError noClassDefFoundError) {
                }
                catch (UnsatisfiedLinkError unsatisfiedLinkError) {
                    // empty catch block
                }
                result = runnable.getOkResult();
                if (!result) {
                    throw new CancelException();
                }
                return runnable.getSelection();
            }
        };
        org.python.pydev.shared_core.log.ToLogFile.afterOnToLogFile = buffer -> {
            Runnable r = new Runnable((String)buffer){
                private final /* synthetic */ String val$buffer;
                {
                    this.val$buffer = string;
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    Object object = org.python.pydev.shared_core.log.ToLogFile.lock;
                    synchronized (object) {
                        try {
                            IOConsoleOutputStream c = ToLogFile.getConsoleOutputStream();
                            c.write(this.val$buffer.toString());
                            c.write(System.lineSeparator());
                        }
                        catch (Throwable e) {
                            Log.log((Throwable)e);
                        }
                    }
                }
            };
            RunInUiThread.async((Runnable)r, (boolean)true);
            return null;
        };
        AbstractInterpreterManager.configWhenInterpreterNotAvailable = manager -> {
            if (PyDialogHelpers.getAskAgainInterpreter(manager)) {
                this.configureInterpreterJob.addInterpreter((AbstractInterpreterManager)manager);
                this.configureInterpreterJob.schedule(50L);
            }
            return null;
        };
        AbstractInterpreterManager.errorCreatingInterpreterInfo = (title, reason) -> {
            try {
                Display disp = Display.getDefault();
                disp.asyncExec(new Runnable((String)title, (String)reason){
                    private final /* synthetic */ String val$title;
                    private final /* synthetic */ String val$reason;
                    {
                        this.val$title = string;
                        this.val$reason = string2;
                    }

                    @Override
                    public void run() {
                        ErrorDialog.openError(null, (String)this.val$title, (String)"Unable to get information on interpreter!", (IStatus)new Status(4, PydevPlugin.getPluginID(), 0, this.val$reason, null));
                    }
                });
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            return null;
        };
        try {
            this.resourceBundle = ResourceBundle.getBundle("org.python.pydev.PyDevPluginResources");
        }
        catch (MissingResourceException x) {
            this.resourceBundle = null;
        }
        IEclipsePreferences preferences = PydevPrefs.getEclipsePreferences();
        InterpreterManagersAPI.setPythonInterpreterManager((IInterpreterManager)new PythonInterpreterManager(preferences));
        InterpreterManagersAPI.setJythonInterpreterManager((IInterpreterManager)new JythonInterpreterManager(preferences));
        InterpreterManagersAPI.setIronpythonInterpreterManager((IInterpreterManager)new IronpythonInterpreterManager(preferences));
        this.startSynchSchedulerJob.schedule(1000L);
    }

    public File getTempFile(String prefix) {
        this.erasePrefixes.add(prefix);
        IPath stateLocation = this.getStateLocation();
        File file = stateLocation.toFile();
        File tempFileAt = FileUtils.getTempFileAt((File)file, (String)prefix);
        return tempFileAt;
    }

    public void stop(BundleContext context) throws Exception {
        DefaultSyncSystemModulesManagerScheduler.get().stop();
        IPath stateLocation = this.getStateLocation();
        File file = stateLocation.toFile();
        for (String prefix : this.erasePrefixes) {
            FileUtils.clearTempFilesAt((File)file, (String)prefix);
        }
        this.isAlive = false;
        try {
            try {
                AbstractShell.shutdownAllShells();
            }
            catch (Exception e) {
                Log.log((Throwable)e);
            }
            for (PythonNature nature : PythonNature.getInitializedPythonNatures()) {
                try {
                    nature.saveAstManager();
                }
                catch (Exception e) {
                    Log.log((Throwable)e);
                }
            }
        }
        finally {
            super.stop(context);
        }
    }

    public static boolean isAlive() {
        PydevPlugin p = plugin;
        if (p == null) {
            return false;
        }
        return p.isAlive;
    }

    public static PydevPlugin getDefault() {
        return plugin;
    }

    public static String getPluginID() {
        if (SharedCorePlugin.inTestMode()) {
            return "PyDevPluginID(null plugin)";
        }
        return PydevPlugin.getBundleInfo().getPluginID();
    }

    public static IWorkspace getWorkspace() {
        return ResourcesPlugin.getWorkspace();
    }

    public static String getResourceString(String key) {
        ResourceBundle bundle = plugin.getResourceBundle();
        try {
            return bundle.getString(key);
        }
        catch (MissingResourceException e) {
            return key;
        }
    }

    public ResourceBundle getResourceBundle() {
        return this.resourceBundle;
    }

    public ImageDescriptor getImageDescriptor(String key) {
        return this.getImageRegistry().getDescriptor(key);
    }

    public static ColorCache getColorCache() {
        PydevPlugin plugin = PydevPlugin.getDefault();
        if (plugin.colorCache == null) {
            IPreferenceStore chainedPrefStore = PyDevUiPrefs.getChainedPrefStore();
            plugin.colorCache = new ColorCache(chainedPrefStore, chainedPrefStore){
                {
                    iPreferenceStore.addPropertyChangeListener(new IPropertyChangeListener(){

                        public void propertyChange(PropertyChangeEvent event) {
                            if (fNamedColorTable.containsKey(event.getProperty())) {
                                this.reloadProperty(event.getProperty());
                            }
                        }
                    });
                }
            };
        }
        return plugin.colorCache;
    }

    public static void setCssId(Object control, String id, boolean applyToChildren) {
        SharedUiPlugin.setCssId((Object)control, (String)id, (boolean)applyToChildren);
    }

    public static void fixSelectionStatusDialogStatusLineColor(Object dialog, Color color) {
        SharedUiPlugin.fixSelectionStatusDialogStatusLineColor((Object)dialog, (Color)color);
    }

    public synchronized PyEditorTextHoverDescriptor[] getPyEditorTextHoverDescriptors() {
        if (this.fPyEditorTextHoverDescriptors == null) {
            this.fPyEditorTextHoverDescriptors = PyEditorTextHoverDescriptor.getContributedHovers();
            ConfigurationElementAttributeSorter sorter = new ConfigurationElementAttributeSorter(){

                @Override
                public IConfigurationElement getConfigurationElement(Object object) {
                    return ((PyEditorTextHoverDescriptor)object).getConfigurationElement();
                }
            };
            sorter.sort(this.fPyEditorTextHoverDescriptors, "priority");
        }
        return this.fPyEditorTextHoverDescriptors;
    }

    public static void flushInstanceScope() {
        try {
            InstanceScope.INSTANCE.getNode(PydevPlugin.getPluginID()).flush();
        }
        catch (BackingStoreException e) {
            Log.log((Throwable)e);
        }
    }

    public FormToolkit getDialogsFormToolkit() {
        if (this.fDialogsFormToolkit == null) {
            FormColors colors = new FormColors(Display.getCurrent());
            colors.setBackground(null);
            colors.setForeground(null);
            this.fDialogsFormToolkit = new FormToolkit(colors);
        }
        return this.fDialogsFormToolkit;
    }

    public synchronized void resetPyEditorTextHoverDescriptors() {
        this.fPyEditorTextHoverDescriptors = null;
        combiningHoverDescriptor = null;
    }

    public static PyEditorTextHoverDescriptor getCombiningHoverDescriptor() {
        if (combiningHoverDescriptor == null) {
            combiningHoverDescriptor = new PyEditorTextHoverDescriptor(new PydevCombiningHover());
            PydevPlugin.initializeDefaultCombiningHoverPreferences();
            PyEditorTextHoverDescriptor.initializeHoversFromPreferences(new PyEditorTextHoverDescriptor[]{combiningHoverDescriptor});
        }
        return combiningHoverDescriptor;
    }

    private static void initializeDefaultCombiningHoverPreferences() {
        PyDevUiPrefs.getPreferenceStore().setDefault("PYDEV_TEXT_HOVER_MODIFIER_" + PydevPlugin.getCombiningHoverDescriptor().getId(), "0");
        PyDevUiPrefs.getPreferenceStore().setDefault("PYDEV_TEXT_HOVER_MODIFIER_MASK_" + PydevPlugin.getCombiningHoverDescriptor().getId(), PyEditorTextHoverDescriptor.DEFAULT_MODIFIER_MASK.intValue());
        PyDevUiPrefs.getPreferenceStore().setDefault("PYDEV_TEXT_HOVER_PRORITY_" + PydevPlugin.getCombiningHoverDescriptor().getId(), 1);
        PyDevUiPrefs.getPreferenceStore().setDefault("PYDEV_TEXT_HOVER_ENABLE_" + PydevPlugin.getCombiningHoverDescriptor().getId(), true);
    }
}

