/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.plugin.preferences;

import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.jface.preference.FieldEditorPreferencePage;
import org.eclipse.jface.preference.RadioGroupFieldEditor;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.python.pydev.core.preferences.PyDevCodeStylePreferences;
import org.python.pydev.plugin.PydevPlugin;

public class PyCodeStylePreferencesPage
extends FieldEditorPreferencePage
implements IWorkbenchPreferencePage {
    private Label labelLocalsFormat;
    private Label labelMethodsFormat;
    private RadioGroupFieldEditor useLocalsAndAttrsCamelCase;
    private RadioGroupFieldEditor useMethodsFormat;

    public PyCodeStylePreferencesPage() {
        super(1);
        this.setPreferenceStore(PydevPlugin.getDefault().getPreferenceStore());
    }

    public void createFieldEditors() {
        Composite p = this.getFieldEditorParent();
        this.useLocalsAndAttrsCamelCase = new RadioGroupFieldEditor("USE_LOCALS_AND_ATTRS_CAMELCASE", "Locals and attributes format (used for assign quick-assist)?", 1, PyDevCodeStylePreferences.LOCALS_LABEL_AND_VALUE, p, true);
        this.addField((FieldEditor)this.useLocalsAndAttrsCamelCase);
        this.useMethodsFormat = new RadioGroupFieldEditor("USE_METHODS_FORMAT", "Methods format (used for generate properties refactoring)", 1, PyDevCodeStylePreferences.LABEL_AND_VALUE, p, true);
        this.addField((FieldEditor)this.useMethodsFormat);
        this.labelLocalsFormat = new Label(p, 0);
        this.labelMethodsFormat = new Label(p, 0);
        this.updateLabelLocalsAndAttrs(PyDevCodeStylePreferences.useLocalsAndAttrsCamelCase());
        this.updateLabelMethods(PyDevCodeStylePreferences.useMethodsCamelCase());
    }

    private void updateLabelMethods(int useMethodsFormat) {
        if (useMethodsFormat == 1) {
            this.labelMethodsFormat.setText("Refactoring property methods in the format def MyMethod()    ");
        } else if (useMethodsFormat == 2) {
            this.labelMethodsFormat.setText("Refactoring property methods in the format def my_method()   ");
        } else {
            this.labelMethodsFormat.setText("Refactoring property methods in the format def myMethod()    ");
        }
    }

    private void updateLabelLocalsAndAttrs(boolean useCamelCase) {
        if (useCamelCase) {
            this.labelLocalsFormat.setText("Ctrl+1 for assign to variable will suggest: myValue = MyValue()    ");
        } else {
            this.labelLocalsFormat.setText("Ctrl+1 for assign to variable will suggest: my_value = MyValue()   ");
        }
    }

    public void init(IWorkbench workbench) {
    }

    public void propertyChange(PropertyChangeEvent event) {
        super.propertyChange(event);
        if (this.useLocalsAndAttrsCamelCase.equals(event.getSource())) {
            boolean newValue = Boolean.parseBoolean((String)event.getNewValue());
            this.updateLabelLocalsAndAttrs(newValue);
        } else if (this.useMethodsFormat.equals(event.getSource())) {
            int val;
            try {
                String newValue = (String)event.getNewValue();
                val = Integer.parseInt(newValue);
            }
            catch (NumberFormatException e) {
                val = 2;
            }
            this.updateLabelMethods(val);
        }
    }
}

