/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.plugin.preferences;

import org.eclipse.jface.preference.BooleanFieldEditor;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.jface.preference.FieldEditorPreferencePage;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.python.pydev.plugin.PydevPlugin;
import org.python.pydev.plugin.preferences.CheckDefaultPreferencesDialog;
import org.python.pydev.shared_core.string.StringUtils;
import org.python.pydev.shared_ui.dialogs.DialogHelpers;
import org.python.pydev.shared_ui.field_editors.ButtonFieldEditor;

public class PydevRootPrefs
extends FieldEditorPreferencePage
implements IWorkbenchPreferencePage {
    public static final String CHECK_PREFERRED_PYDEV_SETTINGS = "CHECK_PREFERRED_PYDEV_SETTINGS";
    public static final boolean DEFAULT_CHECK_PREFERRED_PYDEV_SETTINGS = true;

    public PydevRootPrefs() {
        this.setDescription(StringUtils.format((String)"PyDev version: %s", (Object[])new Object[]{PydevPlugin.getVersion()}));
        this.setPreferenceStore(PydevPlugin.getDefault().getPreferenceStore());
    }

    public void init(IWorkbench workbench) {
    }

    protected void createFieldEditors() {
        Composite p = this.getFieldEditorParent();
        final BooleanFieldEditor booleanField = new BooleanFieldEditor(CHECK_PREFERRED_PYDEV_SETTINGS, "Check preferred Eclipse settings for PyDev on editor open", p);
        this.addField((FieldEditor)booleanField);
        this.addField((FieldEditor)new ButtonFieldEditor("__UNUSED__", "Check preferred settings now.", p, new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                CheckDefaultPreferencesDialog.CheckInfo[] missing = CheckDefaultPreferencesDialog.CheckInfo.getMissing();
                if (missing.length == 0) {
                    DialogHelpers.openInfo((String)"Checked", (String)"Preferences in Eclipse already match preferred PyDev settings.");
                    return;
                }
                Shell shell = PydevRootPrefs.this.getShell();
                CheckDefaultPreferencesDialog dialog = new CheckDefaultPreferencesDialog(shell, missing);
                dialog.open();
                booleanField.load();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        }));
    }

    public static void setCheckPreferredPydevSettings(boolean b) {
        PydevPlugin.getDefault().getPreferenceStore().setValue(CHECK_PREFERRED_PYDEV_SETTINGS, b);
    }

    public static boolean getCheckPreferredPydevSettings() {
        return PydevPlugin.getDefault().getPreferenceStore().getBoolean(CHECK_PREFERRED_PYDEV_SETTINGS);
    }
}

