/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.tree;

import org.eclipse.swt.dnd.DragSource;
import org.eclipse.swt.dnd.DragSourceEvent;
import org.eclipse.swt.dnd.DragSourceListener;
import org.eclipse.swt.dnd.DropTarget;
import org.eclipse.swt.dnd.DropTargetAdapter;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.python.pydev.shared_core.callbacks.ICallback;
import org.python.pydev.shared_core.image.IImageHandle;
import org.python.pydev.shared_ui.ImageCache;
import org.python.pydev.shared_ui.SharedUiPlugin;
import org.python.pydev.tree.TreeItemDragDataTransfer;

public class EnabledTreeDragReorder {
    public static final String DRAG_IMAGE_DATA_KEY = "DRAG_IMAGE";

    public static void enableDrag(final Tree tree, final boolean acceptDropInTree, final boolean canChangeParent, final ICallback<Object, Object> onDNDFinished) {
        Transfer[] types = new Transfer[]{TreeItemDragDataTransfer.getInstance()};
        int operations = 2;
        DragSource source = new DragSource((Control)tree, operations);
        source.setTransfer(types);
        final TreeItem[] dragSourceItem = new TreeItem[1];
        source.addDragListener(new DragSourceListener(){

            public void dragStart(DragSourceEvent event) {
                TreeItem[] selection = tree.getSelection();
                if (selection.length > 0 && selection[0].getItemCount() == 0) {
                    event.doit = true;
                    dragSourceItem[0] = selection[0];
                } else {
                    event.doit = false;
                }
            }

            public void dragSetData(DragSourceEvent event) {
                TreeItem treeItem = dragSourceItem[0];
                if (treeItem != null) {
                    event.data = new DragData(treeItem.getText(), (String)treeItem.getData(EnabledTreeDragReorder.DRAG_IMAGE_DATA_KEY));
                }
            }

            public void dragFinished(DragSourceEvent event) {
                if (event.detail == 2 && dragSourceItem[0] != null) {
                    dragSourceItem[0].dispose();
                    onDNDFinished.call(null);
                }
                dragSourceItem[0] = null;
            }
        });
        DropTarget target = new DropTarget((Control)tree, operations);
        target.setTransfer(types);
        target.addDropListener((DropTargetListener)new DropTargetAdapter(){

            public void dropAccept(DropTargetEvent event) {
                TreeItem item = (TreeItem)event.item;
                if (item != null) {
                    TreeItem parent = item.getParentItem();
                    if (!acceptDropInTree && parent == null && dragSourceItem[0] != null) {
                        dragSourceItem[0] = null;
                    }
                }
            }

            public void dragOver(DropTargetEvent event) {
                event.feedback = 24;
                event.detail = 0;
                if (event.item != null) {
                    TreeItem item = (TreeItem)event.item;
                    if (item.getParentItem() == null && !acceptDropInTree) {
                        event.feedback = 0;
                        return;
                    }
                    event.detail = 2;
                    Point pt = tree.getDisplay().map(null, (Control)tree, event.x, event.y);
                    Rectangle bounds = item.getBounds();
                    event.feedback = pt.y < bounds.y + bounds.height / 3 ? (event.feedback |= 2) : (pt.y > bounds.y + 2 * bounds.height / 3 ? (event.feedback |= 4) : (event.feedback |= 1));
                }
            }

            public void drop(DropTargetEvent event) {
                if (event.data == null) {
                    event.detail = 0;
                    return;
                }
                DragData data = (DragData)event.data;
                if (event.item == null) {
                    TreeItem item = new TreeItem(tree, 0);
                    data.update(item);
                } else {
                    TreeItem item = (TreeItem)event.item;
                    TreeItem parent = item.getParentItem();
                    Point pt = tree.getDisplay().map(null, (Control)tree, event.x, event.y);
                    Rectangle bounds = item.getBounds();
                    if (parent != null) {
                        TreeItem[] items = parent.getItems();
                        int index = 0;
                        int i = 0;
                        while (i < items.length) {
                            if (items[i] == item) {
                                index = i;
                                break;
                            }
                            ++i;
                        }
                        if (pt.y < bounds.y + bounds.height / 3) {
                            TreeItem newItem = new TreeItem(parent, 0, index);
                            data.update(newItem);
                        } else if (pt.y > bounds.y + 2 * bounds.height / 3) {
                            TreeItem newItem = new TreeItem(parent, 0, index + 1);
                            data.update(newItem);
                        } else if (canChangeParent) {
                            TreeItem newItem = new TreeItem(item, 0);
                            data.update(newItem);
                        } else {
                            TreeItem newItem = new TreeItem(parent, 0, index + 1);
                            data.update(newItem);
                        }
                    } else {
                        if (!acceptDropInTree) {
                            return;
                        }
                        TreeItem[] items = tree.getItems();
                        int index = 0;
                        int i = 0;
                        while (i < items.length) {
                            if (items[i] == item) {
                                index = i;
                                break;
                            }
                            ++i;
                        }
                        if (pt.y < bounds.y + bounds.height / 3) {
                            TreeItem newItem = new TreeItem(tree, 0, index);
                            data.update(newItem);
                        } else if (pt.y > bounds.y + 2 * bounds.height / 3) {
                            TreeItem newItem = new TreeItem(tree, 0, index + 1);
                            data.update(newItem);
                        } else {
                            TreeItem newItem = new TreeItem(item, 0);
                            data.update(newItem);
                        }
                    }
                }
            }
        });
    }

    public static class DragData {
        public final String text;
        public final String image;

        public DragData(String text, String image) {
            this.text = text;
            this.image = image;
        }

        public void update(TreeItem item) {
            item.setText(this.text);
            if (this.image != null) {
                item.setImage(ImageCache.asImage((IImageHandle)SharedUiPlugin.getImageCache().get(this.image)));
                item.setData(EnabledTreeDragReorder.DRAG_IMAGE_DATA_KEY, (Object)this.image);
            }
        }
    }
}

