/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.ui;

import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.part.ViewPart;
import org.python.pydev.plugin.PyDevUiPrefs;
import org.python.pydev.shared_core.SharedCorePlugin;
import org.python.pydev.shared_core.callbacks.CallbackWithListeners;
import org.python.pydev.shared_core.callbacks.ICallbackWithListeners;
import org.python.pydev.ui.SetOrientationAction;

public abstract class ViewPartWithOrientation
extends ViewPart
implements IPropertyChangeListener {
    protected Composite fParent;
    protected int fCurrentOrientation;
    private int orientationPreference;
    static final int PREFERENCES_VIEW_ORIENTATION_AUTOMATIC = 0;
    static final int PREFERENCES_VIEW_ORIENTATION_HORIZONTAL = 1;
    static final int PREFERENCES_VIEW_ORIENTATION_VERTICAL = 2;
    public static final int VIEW_ORIENTATION_HORIZONTAL = 1;
    public static final int VIEW_ORIENTATION_VERTICAL = 2;
    public final ICallbackWithListeners onControlCreated = new CallbackWithListeners();
    public final ICallbackWithListeners onControlDisposed = new CallbackWithListeners();

    protected ViewPartWithOrientation() {
        String orientationPreferencesKey = this.getOrientationPreferencesKey();
        if (!SharedCorePlugin.inTestMode()) {
            IPreferenceStore preferenceStore = PyDevUiPrefs.getPreferenceStore();
            this.orientationPreference = preferenceStore.getInt(orientationPreferencesKey);
            PyDevUiPrefs.getPreferenceStore().addPropertyChangeListener((IPropertyChangeListener)this);
        }
    }

    public void createPartControl(Composite parent) {
        this.fParent = parent;
        this.addResizeListener(parent);
    }

    public abstract String getOrientationPreferencesKey();

    int getOrientationPreferenceValue() {
        return this.orientationPreference;
    }

    protected void addOrientationPreferences(IMenuManager menuManager) {
        menuManager.add((IAction)new SetOrientationAction(this));
    }

    protected void updateOrientation() {
        switch (this.orientationPreference) {
            case 1: {
                this.setNewOrientation(1);
                break;
            }
            case 2: {
                this.setNewOrientation(2);
                break;
            }
            default: {
                Point size = this.fParent.getSize();
                if (size.x == 0 || size.y == 0) break;
                if (size.x > size.y) {
                    this.setNewOrientation(1);
                    break;
                }
                this.setNewOrientation(2);
            }
        }
    }

    private void addResizeListener(Composite parent) {
        parent.addControlListener(new ControlListener(){

            public void controlMoved(ControlEvent e) {
            }

            public void controlResized(ControlEvent e) {
                ViewPartWithOrientation.this.updateOrientation();
            }
        });
    }

    protected abstract void setNewOrientation(int var1);

    public void dispose() {
        PyDevUiPrefs.getPreferenceStore().removePropertyChangeListener((IPropertyChangeListener)this);
        super.dispose();
    }

    public void propertyChange(PropertyChangeEvent event) {
        if (event.getProperty().equals(this.getOrientationPreferencesKey())) {
            this.orientationPreference = (Integer)event.getNewValue();
            this.updateOrientation();
        }
    }
}

