/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.ui.pythonpathconf;

import java.util.List;
import java.util.Set;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.swt.widgets.TreeItem;
import org.python.pydev.ast.interpreter_managers.InterpreterInfo;
import org.python.pydev.core.IInterpreterInfo;
import org.python.pydev.core.IInterpreterManager;
import org.python.pydev.shared_core.image.IImageCache;
import org.python.pydev.shared_core.image.IImageHandle;
import org.python.pydev.shared_ui.ImageCache;
import org.python.pydev.shared_ui.SharedUiPlugin;
import org.python.pydev.shared_ui.utils.RunInUiThread;
import org.python.pydev.ui.pythonpathconf.AbstractInterpreterEditor;
import org.python.pydev.ui.pythonpathconf.package_manager.AbstractPackageManager;
import org.python.pydev.ui.pythonpathconf.package_manager.CondaPackageManager;
import org.python.pydev.ui.pythonpathconf.package_manager.PipPackageManager;
import org.python.pydev.ui.pythonpathconf.package_manager.PipenvPackageManager;
import org.python.pydev.ui.pythonpathconf.package_manager.PipenvUnconfiguredException;

public class PackageTab {
    private Composite boxPackage;
    private volatile InterpreterInfo interpreterInfo;
    private Tree tree;
    AbstractPackageManager packageManager;
    private Button btConda;
    private Button btPipenv;
    private Button btPip;
    private Button checkUseConda;
    private AbstractInterpreterEditor abstractInterpreterEditor;
    private static final Object listJobLock = new Object();
    private static volatile ListJob listJob;

    public PackageTab(AbstractInterpreterEditor abstractInterpreterEditor) {
        this.abstractInterpreterEditor = abstractInterpreterEditor;
    }

    public void createPackageControlTab(TabFolder tabFolder, Set<String> exeOrJarOfInterpretersToRestore, IInterpreterManager interpreterManager) {
        Composite composite;
        TabItem tabItem = new TabItem(tabFolder, 0);
        tabItem.setText("Packages");
        IImageCache imageCache = SharedUiPlugin.getImageCache();
        tabItem.setImage(ImageCache.asImage((IImageHandle)imageCache.get("icons/package_obj.gif")));
        Composite parent = composite = new Composite((Composite)tabFolder, 0);
        GridLayout layout = new GridLayout(2, false);
        composite.setLayout((Layout)layout);
        this.tree = new Tree(parent, 2818);
        this.tree.setHeaderVisible(true);
        this.createColumn("Library", 300);
        this.createColumn("Version", 100);
        this.createColumn("", 100);
        GridData gd = new GridData(1808);
        gd.horizontalSpan = 1;
        gd.grabExcessHorizontalSpace = true;
        gd.grabExcessVerticalSpace = true;
        this.tree.setLayoutData((Object)gd);
        Composite control = this.getButtonBoxPackage(parent, interpreterManager);
        gd = new GridData();
        gd.verticalAlignment = 1;
        control.setLayoutData((Object)gd);
        tabItem.setControl((Control)composite);
    }

    public Composite getButtonBoxPackage(Composite parent, final IInterpreterManager interpreterManager) {
        if (this.boxPackage == null) {
            this.boxPackage = new Composite(parent, 0);
            GridLayout layout = new GridLayout();
            layout.marginWidth = 0;
            this.boxPackage.setLayout((Layout)layout);
            String packageManagersDisableProperty = System.getProperty("pydev.packagemanagers.disable", "false");
            boolean packageManagersDisable = packageManagersDisableProperty.equalsIgnoreCase("true") || packageManagersDisableProperty.equalsIgnoreCase("1");
            this.btPip = AbstractInterpreterEditor.createBt(this.boxPackage, "Manage with &pip", (SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    PipPackageManager packageManager = new PipPackageManager((IInterpreterInfo)PackageTab.this.interpreterInfo);
                    ((AbstractPackageManager)packageManager).manage();
                    PackageTab.this.update();
                }
            });
            this.btConda = AbstractInterpreterEditor.createBt(this.boxPackage, "Manage with c&onda", (SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    AbstractPackageManager packageManager = AbstractPackageManager.createPackageManager((IInterpreterInfo)PackageTab.this.interpreterInfo);
                    packageManager.manage();
                    PackageTab.this.update();
                }
            });
            if (interpreterManager.getInterpreterType() == 0) {
                this.btPipenv = AbstractInterpreterEditor.createBt(this.boxPackage, "Manage with pip&env", (SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        PipenvPackageManager packageManager;
                        try {
                            packageManager = new PipenvPackageManager((IInterpreterInfo)PackageTab.this.interpreterInfo, interpreterManager, PackageTab.this.abstractInterpreterEditor.getNameToInfo().values().toArray(new IInterpreterInfo[0]));
                        }
                        catch (PipenvUnconfiguredException e1) {
                            return;
                        }
                        ((AbstractPackageManager)packageManager).manage();
                        PackageTab.this.update();
                    }
                });
            }
            if (packageManagersDisable) {
                this.btPip.setEnabled(false);
                this.btPipenv.setEnabled(false);
                this.btConda.setEnabled(false);
            }
            this.checkUseConda = new Button(this.boxPackage, 32);
            this.checkUseConda.setText("Load conda env vars before run?");
            this.checkUseConda.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    PackageTab.this.interpreterInfo.setActivateCondaEnv(PackageTab.this.checkUseConda.getSelection());
                }
            });
        } else {
            this.checkParent((Control)this.boxPackage, parent);
        }
        return this.boxPackage;
    }

    protected void checkParent(Control control, Composite parent) {
        Assert.isTrue((control.getParent() == parent ? 1 : 0) != 0, (String)"Different parents");
    }

    public void setInfo(InterpreterInfo info) {
        this.interpreterInfo = info;
        this.update();
    }

    private TreeColumn createColumn(String text, int width) {
        TreeColumn col = new TreeColumn(this.tree, 16384);
        col.setText(text);
        if (width > 0) {
            col.setWidth(width);
        }
        col.setMoveable(true);
        return col;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void update() {
        this.makeUIClean();
        this.packageManager = null;
        if (this.interpreterInfo == null) {
            return;
        }
        this.checkUseConda.setSelection(this.interpreterInfo.getActivateCondaEnv());
        TreeItem loadingItem = new TreeItem(this.tree, 0);
        loadingItem.setText(new String[]{"Loading info...", ""});
        Object object = listJobLock;
        synchronized (object) {
            if (listJob != null) {
                listJob.cancel();
            }
            listJob = new ListJob((IInterpreterInfo)this.interpreterInfo);
            listJob.schedule();
        }
    }

    private void makeUIClean() {
        if (this.tree.isDisposed()) {
            return;
        }
        TreeColumn column = this.tree.getColumn(0);
        column.setText("Library");
        this.tree.clearAll(true);
        this.tree.setItemCount(0);
        this.btConda.setEnabled(false);
        if (this.btPipenv != null) {
            this.btPipenv.setEnabled(false);
        }
        this.btPip.setEnabled(false);
        if (this.checkUseConda != null) {
            this.checkUseConda.setEnabled(false);
        }
    }

    private class ListJob
    extends Job {
        private final IInterpreterInfo initialInfo;
        private AbstractPackageManager packageManager;

        public ListJob(IInterpreterInfo initialInfo) {
            super("List dependencies for: " + initialInfo.getNameForUI());
            this.initialInfo = initialInfo;
        }

        protected IStatus run(IProgressMonitor monitor) {
            this.packageManager = AbstractPackageManager.createPackageManager((IInterpreterInfo)PackageTab.this.interpreterInfo);
            if (this.initialInfo != PackageTab.this.interpreterInfo || monitor.isCanceled() || PackageTab.this.tree.isDisposed()) {
                return Status.OK_STATUS;
            }
            List<String[]> list = this.packageManager.listLibrariesInEnv();
            RunInUiThread.async(() -> {
                if (this.initialInfo != PackageTab.this.interpreterInfo || PackageTab.this.tree.isDisposed() || monitor.isCanceled()) {
                    return;
                }
                PackageTab.this.makeUIClean();
                this.packageManager.updateTree(PackageTab.this.tree, list);
                PackageTab.this.btPip.setEnabled(true);
                PackageTab.this.btPipenv.setEnabled(true);
                if (this.packageManager instanceof CondaPackageManager) {
                    PackageTab.this.btConda.setEnabled(true);
                    if (PackageTab.this.checkUseConda != null) {
                        PackageTab.this.checkUseConda.setEnabled(true);
                    }
                }
            });
            return Status.OK_STATUS;
        }
    }
}

